/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.client.jdbc.TDatabaseMetaData;
import com.taobao.tddl.client.jdbc.TPreparedStatementImp;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.listener.Context;
import com.taobao.tddl.client.jdbc.listener.HookPoints;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelRealSqlExecutor;
import com.taobao.tddl.client.jdbc.sqlexecutor.serial.SerialRealSqlExecutor;
import com.taobao.tddl.client.jdbc.sqlexecutor.serial.SimpleSerialRealSqlExecutor;
import com.taobao.tddl.client.pipeline.PipelineFactory;
import com.taobao.tddl.client.pipeline.bootstrap.PipelineBootstrap;
import com.taobao.tddl.client.util.ExceptionUtils;
import com.taobao.tddl.client.util.ThreadLocalMap;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TConnectionImp
implements ConnectionManager,
Connection {
    private TDataSource.TDSProperties properties;
    protected static final Log log = LogFactory.getLog(TConnectionImp.class);
    private int transactionIsolation = -1;
    private boolean closed;
    private final boolean enableProfileRealDBAndTables;
    private final PipelineFactory pipelineFactory;
    protected boolean isAutoCommit = true;
    protected Set<TStatementImp> openedStatements = new HashSet<TStatementImp>(2);
    private HookPoints hookPoints;
    private final Context context = new Context();
    private static final boolean closeInvokedByTStatement = false;
    private static final int maxTransactionDSCount = 1;
    protected Map<String, DataSource> dsMap = Collections.emptyMap();
    Map<String, Connection> connectionMap = new HashMap<String, Connection>(2);

    public TConnectionImp(boolean enableProfileRealDBAndTables, PipelineFactory pipelineFactory) {
        this.enableProfileRealDBAndTables = enableProfileRealDBAndTables;
        this.pipelineFactory = pipelineFactory;
    }

    public TConnectionImp(String username, String password, boolean enableProfileRealDBAndTables, PipelineFactory pipelineFactory) {
        this.enableProfileRealDBAndTables = enableProfileRealDBAndTables;
        this.pipelineFactory = pipelineFactory;
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("No operations allowed after connection closed.");
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public Connection getConnection(String dbIndex, boolean goSlave) throws SQLException {
        Connection conn = this.connectionMap.get(dbIndex);
        if (conn == null) {
            DataSource datasource = this.dsMap.get(dbIndex);
            if (datasource == null) {
                throw new SQLException("can't find datasource by your dbIndex :" + dbIndex);
            }
            if (this.isAutoCommit) {
                conn = datasource.getConnection();
                conn.setAutoCommit(this.isAutoCommit);
                this.connectionMap.put(dbIndex, conn);
            } else {
                this.validTransactionCondition(true);
                conn = datasource.getConnection();
                conn.setAutoCommit(this.isAutoCommit);
                this.connectionMap.put(dbIndex, conn);
            }
        } else {
            return conn;
        }
        return conn;
    }

    protected void validTransactionCondition(boolean createNew) throws SQLException {
        if (this.connectionMap.size() > 1 - (createNew ? 1 : 0)) {
            StringBuilder sb = new StringBuilder("\u4e8b\u52a1\u4e2d\u8de8\u5e93\u4e2a\u6570\u8d85\u8fc7\u9884\u671f\uff0c\u9884\u671f\u503c: ");
            sb.append(1);
            sb.append(",current dbIndexes in connectionMap is:");
            for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
                sb.append(entry.getKey());
                sb.append(";");
            }
            throw new SQLException(sb.toString());
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        TStatementImp stmt = (TStatementImp)this.createStatement();
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        PipelineBootstrap bootstrap = new PipelineBootstrap(this, this.pipelineFactory);
        TStatementImp stmt = new TStatementImp(this, bootstrap);
        SerialRealSqlExecutor serialRealSqlExecutor = new SerialRealSqlExecutor(this);
        ParallelRealSqlExecutor parallelRealSqlExecutor = new ParallelRealSqlExecutor(this);
        SimpleSerialRealSqlExecutor simpleSerialRealSqlExecutor = new SimpleSerialRealSqlExecutor(this);
        stmt.setTimeoutThreshold(this.properties.timeoutThreshold);
        stmt.setHookPoints(this.hookPoints);
        stmt.setContext(this.context);
        stmt.setEnableProfileRealDBAndTables(this.enableProfileRealDBAndTables);
        stmt.setProperties(this.properties);
        stmt.setSerialRealSqlExecutor(serialRealSqlExecutor);
        stmt.setParallelRealSqlExecutor(parallelRealSqlExecutor);
        stmt.setSimpleSerialRealSqlExecutor(simpleSerialRealSqlExecutor);
        this.openedStatements.add(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TStatementImp stmt = (TStatementImp)this.createStatement(resultSetType, resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        PipelineBootstrap bootstrap = new PipelineBootstrap(this, this.pipelineFactory);
        TPreparedStatementImp stmt = new TPreparedStatementImp(this, sql, bootstrap);
        SerialRealSqlExecutor serialRealSqlExecutor = new SerialRealSqlExecutor(this);
        ParallelRealSqlExecutor parallelRealSqlExecutor = new ParallelRealSqlExecutor(this);
        SimpleSerialRealSqlExecutor simpleSerialRealSqlExecutor = new SimpleSerialRealSqlExecutor(this);
        stmt.setTimeoutThreshold(this.properties.timeoutThreshold);
        stmt.setHookPoints(this.hookPoints);
        stmt.setContext(this.context);
        stmt.setEnableProfileRealDBAndTables(this.enableProfileRealDBAndTables);
        stmt.setProperties(this.properties);
        stmt.setSerialRealSqlExecutor(serialRealSqlExecutor);
        stmt.setParallelRealSqlExecutor(parallelRealSqlExecutor);
        stmt.setSimpleSerialRealSqlExecutor(simpleSerialRealSqlExecutor);
        this.openedStatements.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        TPreparedStatementImp stmt = (TPreparedStatementImp)this.prepareStatement(sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public boolean containDBIndex(String dbIndex) {
        return this.dsMap.containsKey(dbIndex);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TPreparedStatementImp stmt = (TPreparedStatementImp)this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        TPreparedStatementImp stmt = (TPreparedStatementImp)this.prepareStatement(sql);
        stmt.setAutoGeneratedKeys(autoGeneratedKeys);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        TPreparedStatementImp stmt = (TPreparedStatementImp)this.prepareStatement(sql);
        stmt.setColumnIndexes(columnIndexes);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        TPreparedStatementImp stmt = (TPreparedStatementImp)this.prepareStatement(sql);
        stmt.setColumnNames(columnNames);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("prepareCall");
    }

    @Override
    public void commit() throws SQLException {
        log.debug((Object)"invoke commit");
        this.checkClosed();
        if (this.isAutoCommit) {
            return;
        }
        this.hookPoints.getBeforeExecute().execute(this.context);
        LinkedList<SQLException> exceptions = null;
        for (Map.Entry<String, Connection> conn : this.connectionMap.entrySet()) {
            try {
                if (!this.isTransactionConnection(conn.getKey())) continue;
                conn.getValue().commit();
            }
            catch (SQLException e) {
                if (exceptions == null) {
                    exceptions = new LinkedList<SQLException>();
                }
                exceptions.add(e);
            }
        }
        ExceptionUtils.throwSQLException(exceptions, null, (List<Object>)null);
        this.hookPoints.getAfterExecute().execute(this.context);
        this.context.reset();
    }

    @Override
    public void rollback() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke rollback");
        }
        this.checkClosed();
        if (this.isAutoCommit) {
            return;
        }
        ArrayList<SQLException> exceptions = null;
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            try {
                Connection conn = entry.getValue();
                if (!this.isTransactionConnection(entry.getKey())) continue;
                conn.rollback();
            }
            catch (SQLException e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<SQLException>();
                }
                exceptions.add(e);
                log.error((Object)("data source name: " + entry.getKey()), (Throwable)e);
            }
        }
        this.context.reset();
        ExceptionUtils.throwSQLException(exceptions, null, (List<Object>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryClose(String dbIndex) throws SQLException {
        Connection conn = this.connectionMap.get(dbIndex);
        if (conn == null) {
            return;
        }
        if (this.isAutoCommit && this.openedStatements.size() <= 1) {
            try {
                conn.close();
            }
            finally {
                this.connectionMap.remove(dbIndex);
            }
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.isAutoCommit == autoCommit) {
            return;
        }
        List<SQLException> sqlExceptions = null;
        if (autoCommit) {
            this.isAutoCommit = autoCommit;
            sqlExceptions = this.setAutoCommitFalse2True(autoCommit, sqlExceptions);
        } else {
            for (TStatementImp it : this.openedStatements) {
                if (it.isCurrentRSClosedOrNull()) continue;
                try {
                    it.getResultSet().close();
                }
                catch (SQLException e) {
                    sqlExceptions = ExceptionUtils.appendToExceptionList(sqlExceptions, e);
                }
            }
            this.isAutoCommit = autoCommit;
            sqlExceptions = this.setAutoCommitTrue2False(autoCommit, sqlExceptions);
        }
        if (sqlExceptions != null && !sqlExceptions.isEmpty()) {
            throw ExceptionUtils.mergeException(sqlExceptions);
        }
    }

    protected List<SQLException> setAutoCommitTrue2False(boolean autoCommit, List<SQLException> sqlExceptions) throws SQLException {
        this.validTransactionCondition(false);
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            if (!this.isTransactionConnection(entry.getKey())) continue;
            sqlExceptions = this.setAutoCommitAndPutSQLExceptionToList(autoCommit, sqlExceptions, entry);
        }
        return sqlExceptions;
    }

    protected List<SQLException> setAutoCommitFalse2True(boolean autoCommit, List<SQLException> sqlExceptions) {
        boolean closeAndclearRetryableDSGroup = true;
        for (TStatementImp it : this.openedStatements) {
            if (it.isCurrentRSClosedOrNull()) continue;
            closeAndclearRetryableDSGroup = false;
        }
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            try {
                if (this.isTransactionConnection(entry.getKey())) {
                    sqlExceptions = this.setAutoCommitAndPutSQLExceptionToList(autoCommit, sqlExceptions, entry);
                }
                if (!closeAndclearRetryableDSGroup) continue;
                Connection conn = entry.getValue();
                if (!conn.getAutoCommit()) {
                    log.info((Object)("trying to close a not auto commit connection ,connection map is " + this.connectionMap));
                }
                conn.close();
            }
            catch (SQLException e) {
                sqlExceptions = ExceptionUtils.appendToExceptionList(sqlExceptions, e);
            }
        }
        if (closeAndclearRetryableDSGroup) {
            this.connectionMap.clear();
        }
        return sqlExceptions;
    }

    protected boolean isTransactionConnection(String dbIndex) {
        return true;
    }

    protected List<SQLException> setAutoCommitAndPutSQLExceptionToList(boolean autoCommit, List<SQLException> sqlExceptions, Map.Entry<String, Connection> entry) {
        try {
            entry.getValue().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            sqlExceptions = ExceptionUtils.appendToExceptionList(sqlExceptions, e);
        }
        return sqlExceptions;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.isAutoCommit;
    }

    public static void flush_hint() {
        TConnectionImp.flushOne("ROUTE_CONDITION");
        TConnectionImp.flushOne("DB_SELECTOR");
        TConnectionImp.flushOne("RULE_SELECTOR");
    }

    private static void flushOne(String key) {
        RouteCondition rc = (RouteCondition)ThreadLocalMap.get((Object)key);
        if (rc != null && RouteCondition.ROUTE_TYPE.FLUSH_ON_CLOSECONNECTION.equals((Object)rc.getRouteType())) {
            ThreadLocalMap.put((Object)key, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke close");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        List<SQLException> exceptions = null;
        try {
            for (TStatementImp stmt : this.openedStatements) {
                try {
                    stmt.closeInterval(false);
                }
                catch (SQLException e) {
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
                }
            }
            for (Connection conn : this.connectionMap.values()) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
                }
            }
        }
        finally {
            TConnectionImp.flush_hint();
            this.openedStatements.clear();
            this.openedStatements = null;
            this.connectionMap.clear();
            this.connectionMap = null;
        }
        ExceptionUtils.throwSQLException(exceptions, "close tconnection", (List<Object>)Collections.EMPTY_LIST);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) throws SQLException {
        this.checkClosed();
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public Connection getProxyConnection() {
        return this;
    }

    @Override
    public void removeCurrentStatement(Statement statement) {
        if (!this.openedStatements.remove(statement)) {
            log.warn((Object)("current statmenet \uff1a" + statement + " doesn't exist!"));
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("rollback");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("setSavepoint");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("releaseSavepoint");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new UnsupportedOperationException("getCatalog");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException("setCatalog");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("setHoldability");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("setTypeMap");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("nativeSQL");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new TDatabaseMetaData();
    }

    public Map<String, DataSource> getDsMap() {
        return this.dsMap;
    }

    public void setDsMap(Map<String, DataSource> dsMap) {
        this.dsMap = dsMap;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    public void setHookPoints(HookPoints hookPoints) {
        this.hookPoints = hookPoints;
    }

    public HookPoints getHookPoints() {
        return this.hookPoints;
    }

    public TDataSource.TDSProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TDataSource.TDSProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new RuntimeException("not support exception");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new RuntimeException("not support exception");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("not support exception");
    }
}

