/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.controller.SpringBasedDispatcherImpl;
import com.taobao.tddl.client.jdbc.AllowAllLevelTconnection;
import com.taobao.tddl.client.jdbc.AllowReadLevelTConnection;
import com.taobao.tddl.client.jdbc.TConnectionImp;
import com.taobao.tddl.client.jdbc.TDataSourceConfig;
import com.taobao.tddl.client.jdbc.TDataSourceState;
import com.taobao.tddl.client.jdbc.TddlRuntime;
import com.taobao.tddl.client.jdbc.listener.Adapter;
import com.taobao.tddl.client.jdbc.listener.HookPoints;
import com.taobao.tddl.client.jdbc.replication.ReplicationAdapter;
import com.taobao.tddl.client.jdbc.replication.ReplicationConfig;
import com.taobao.tddl.common.sync.BizTDDLContext;
import com.taobao.tddl.rule.bean.LogicTable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class TDataSource
extends TDataSourceConfig
implements DataSource,
Cloneable {
    private final TDSProperties properties = new TDSProperties();
    private static final long DEFAULT_TIMEOUT_THRESHOLD = 100L;
    private static DataSource indexMappingCacheDatasource = null;
    private ReplicationConfig replicationConfig;
    private String replicationConfigFile;
    private Map<String, DataSource> replicationTargetDataSources = Collections.EMPTY_MAP;
    public TDataSourceState state = new TDataSourceState("");
    private List<Adapter> adapters = Collections.EMPTY_LIST;
    private TransactionCrossDb restrictionLEVEL = TransactionCrossDb.NOT_ALLOW_READ;

    @Override
    public void init() {
        this.state = new TDataSourceState(this.getAppName());
        super.init();
        this.initReplication();
    }

    private void initReplication() {
        if (this.isHandleReplication) {
            this.replicationConfig = new ReplicationConfig();
            this.replicationConfig.setAppName(this.getAppName());
            this.replicationConfig.setUseLocalConfig(this.isUseLocalConfig());
            this.replicationConfig.setReplicationConfigFile(this.doExternalResolve(this.replicationConfigFile)[0]);
            this.replicationConfig.init(this);
            if (this.defaultDispatcher instanceof SpringBasedDispatcherImpl) {
                SpringBasedDispatcherImpl dispatcher = (SpringBasedDispatcherImpl)this.defaultDispatcher;
                for (Map.Entry<String, BizTDDLContext> e : this.replicationConfig.getLogicTableName2TDDLContext().entrySet()) {
                    LogicTable logicTable;
                    if (dispatcher.getRoot() != null) {
                        logicTable = dispatcher.getRoot().getLogicTable(e.getKey());
                        if (logicTable == null) continue;
                        logicTable.setNeedRowCopy(true);
                        logicTable.setUniqueKeys(e.getValue().getUniqueKey());
                        continue;
                    }
                    if (dispatcher.getVtabroot() != null) {
                        logicTable = dispatcher.getVtabroot().getVirtualTable(e.getKey());
                        if (logicTable == null) continue;
                        logicTable.setNeedRowCopy(true);
                        logicTable.setUniqueKeys(e.getValue().getUniqueKey());
                        continue;
                    }
                    logger.error((Object)"[REPLICATION] rule error,no old rule or new rule!check the config");
                }
            }
        }
        try {
            this.hookPoints = new HookPoints();
            for (Adapter adapter : this.adapters) {
                adapter.init(this, this.hookPoints);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        TConnectionImp returnConnection = null;
        if (TransactionCrossDb.NOT_ALLOW_READ == this.restrictionLEVEL) {
            returnConnection = new TConnectionImp(this.enableProfileRealDBAndTables, this.pipelineFactory);
        } else if (TransactionCrossDb.ALLOW_READ == this.restrictionLEVEL) {
            returnConnection = new AllowReadLevelTConnection(this.enableProfileRealDBAndTables, this.pipelineFactory);
        } else if (TransactionCrossDb.ALLOW_ALL == this.restrictionLEVEL) {
            returnConnection = new AllowAllLevelTconnection(this.enableProfileRealDBAndTables, this.pipelineFactory);
        }
        this.buildConnection1(returnConnection);
        return returnConnection;
    }

    private void buildConnection1(TConnectionImp connectionImp) {
        TddlRuntime rt = (TddlRuntime)this.runtimeConfigHolder.get();
        connectionImp.setHookPoints(this.hookPoints);
        if (rt == null) {
            throw new IllegalArgumentException("rt is null");
        }
        connectionImp.setProperties(this.properties);
        connectionImp.setDsMap(rt.dsMap);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("getLoginTimeout");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("getLogWriter");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    protected TDataSource clone() throws CloneNotSupportedException {
        return (TDataSource)super.clone();
    }

    public String toString() {
        return "{MasterOnly:" + this.isMasterOnly + ",SlaveOnly:" + this.isSlaveOnly + ",ReadOnly:" + this.isReadOnly + "}";
    }

    public void setTimeoutThreshold(long timeoutThreshold) {
        this.properties.timeoutThreshold = timeoutThreshold;
    }

    public static DataSource getIndexMappingCacheDatasource() {
        return indexMappingCacheDatasource;
    }

    public static void setIndexMappingCacheDatasource(DataSource indexMappingCacheDatasource) {
        TDataSource.indexMappingCacheDatasource = indexMappingCacheDatasource;
    }

    public void setListenerAdapter(Adapter adapter) throws SQLException {
        LinkedList<Adapter> adapters = new LinkedList<Adapter>();
        adapters.add(adapter);
        this.setListenerAdapters(adapters);
    }

    public void setListenerAdapters(List<Adapter> adapters) throws SQLException {
        this.adapters = adapters;
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof ReplicationAdapter)) continue;
            this.isHandleReplication = true;
            break;
        }
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public void setReplicationConfigFile(String replicationConfigFile) {
        this.replicationConfigFile = replicationConfigFile;
    }

    public String getReplicationConfigFile() {
        return this.replicationConfigFile;
    }

    public boolean isEnableReplaceTableSuffixByIdentifier() {
        return this.properties.enableReplaceTableSuffixByIdentifier;
    }

    public void setEnableReplaceTableSuffixByIdentifier(boolean enableReplaceTableSuffixByIdentifier) {
        this.properties.enableReplaceTableSuffixByIdentifier = enableReplaceTableSuffixByIdentifier;
    }

    public void setUsePlaceHolder(boolean usePlaceHolder) {
        this.properties.usePlaceHolder = usePlaceHolder;
    }

    public boolean getUsePlaceHolder() {
        return this.properties.usePlaceHolder;
    }

    public void setRemoveThreadLocalOnCloseConn(boolean re) {
        this.properties.removeThreadLocalOnCloseConn = re;
    }

    public boolean getRemoveThreadLocalOnCloseConn() {
        return this.properties.removeThreadLocalOnCloseConn;
    }

    public DataSource getDataSource(String dbIndex) {
        return ((TddlRuntime)this.runtimeConfigHolder.get()).dsMap.get(dbIndex);
    }

    public TransactionCrossDb getTransactionCrossDb() {
        return this.restrictionLEVEL;
    }

    public void setTransactionCrossDb(TransactionCrossDb restrictionLEVEL) {
        this.restrictionLEVEL = restrictionLEVEL;
    }

    public Map<String, DataSource> getReplicationTargetDataSources() {
        return this.replicationTargetDataSources;
    }

    public void setReplicationTargetDataSources(Map<String, DataSource> replicationTargetDataSources) {
        this.replicationTargetDataSources = replicationTargetDataSources;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public static enum TransactionCrossDb {
        NOT_ALLOW_READ,
        ALLOW_READ,
        ALLOW_ALL;

    }

    public static class TDSProperties {
        public long timeoutThreshold = 100L;
        public boolean enableReplaceTableSuffixByIdentifier = false;
        public boolean usePlaceHolder = false;
        public boolean removeThreadLocalOnCloseConn = false;
    }
}

