/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.alibaba.common.lang.io.ByteArrayInputStream;
import com.taobao.tddl.client.controller.SpringBasedDispatcherImpl;
import com.taobao.tddl.client.dispatcher.SqlDispatcher;
import com.taobao.tddl.client.dsmatrixcreator.DataSourceMatrixCreatorImp;
import com.taobao.tddl.client.jdbc.TddlRuntime;
import com.taobao.tddl.client.jdbc.listener.HookPoints;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelDiamondConfigManager;
import com.taobao.tddl.client.pipeline.DefaultPipelineFactory;
import com.taobao.tddl.client.pipeline.NewRulePipelineFactory;
import com.taobao.tddl.client.pipeline.PipelineFactory;
import com.taobao.tddl.client.pipeline.RuleLePipelineFactory;
import com.taobao.tddl.client.rule.le.RuleLeBeanConvert;
import com.taobao.tddl.client.util.DataSourceType;
import com.taobao.tddl.common.ConfigServerHelper;
import com.taobao.tddl.common.DataSourceChangeListener;
import com.taobao.tddl.common.Monitor;
import com.taobao.tddl.common.RuntimeConfigHolder;
import com.taobao.tddl.common.config.DefaultTddlConfigParser;
import com.taobao.tddl.common.config.PropertiesConfigParser;
import com.taobao.tddl.common.config.TddlConfigParser;
import com.taobao.tddl.common.config.beans.AppRule;
import com.taobao.tddl.common.jdbc.DataSourceConfig;
import com.taobao.tddl.common.util.DataSourceFetcher;
import com.taobao.tddl.common.util.StringXmlApplicationContext;
import com.taobao.tddl.common.util.TDDLMBeanServer;
import com.taobao.tddl.common.util.TDataSourceConfigHolder;
import com.taobao.tddl.common.util.mbean.TDDLMBean;
import com.taobao.tddl.interact.monitor.TotalStatMonitor;
import com.taobao.tddl.interact.rule.VirtualTableRoot;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import com.taobao.tddl.parser.SQLParser;
import com.taobao.tddl.parser.SQLParserImp;
import com.taobao.tddl.rule.bean.PropertyBaseTDDLRoot;
import com.taobao.tddl.rule.bean.TDDLRoot;
import com.taobao.tddl.rule.le.TddlRuleInner;
import com.taobao.tddl.rule.le.bean.RuleChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TDataSourceConfig
implements ApplicationContextAware,
DataSourceChangeListener,
RuleChangeListener {
    protected static final Log logger = LogFactory.getLog(TDataSourceConfig.class);
    public static final String DBINDEX_DSKEY_CONN_CHAR = "_";
    public static final String STR_LINE_MARK = "-";
    private static final String DEFAULT_WRITE_RULE_ID = "tddl_root";
    private String ruleUrl;
    protected DBType dbType = DBType.MYSQL;
    protected Map<String, SqlDispatcher> dispatcherMap;
    protected SqlDispatcher defaultDispatcher;
    protected HookPoints hookPoints = HookPoints.DEFAULT;
    protected boolean isHandleReplication;
    protected final RuntimeConfigHolder<TddlRuntime> runtimeConfigHolder = new RuntimeConfigHolder();
    protected boolean enableProfileRealDBAndTables;
    protected boolean isReadOnly = false;
    protected boolean isMasterOnly = false;
    protected boolean isSlaveOnly = false;
    protected PipelineFactory pipelineFactory = null;
    protected ParallelDiamondConfigManager parallelManager = null;
    protected DataSourceMatrixCreatorImp dataSourceMatrixCreator;
    private Map<String, ? extends Object> rwDataSourcePoolConfig;
    private ApplicationContext springContext;
    private String appName;
    private boolean isUseLocalConfig = false;
    private String[] appRuleFiles;
    private String appRulePropertiesString;
    private String appRuleString;
    private DataSourceType dataSourceType = DataSourceType.TbDataSource;
    private ClassLoader specifyClassLoader = null;
    private boolean useNewRule = false;
    private boolean dynamicRule = false;
    private TddlRuleInner tddlRule = null;
    private List<RuleChangeListener> outListeners = new ArrayList<RuleChangeListener>();
    protected DBType defaultDbType;
    private String ruleRootBeanID = "tddl_root";
    public static final TotalStatMonitor statMonitor = TotalStatMonitor.getInstance();
    private final TddlConfigParser<AppRule> shardRuleParser = new DefaultTddlConfigParser();
    private ConfigServerHelper.DataListener shardRuleListener = new ConfigServerHelper.DataListener(){

        public void onDataReceiveAtRegister(Object data) {
            Object tddlConfig = TDataSourceConfig.this.shardRuleParser.parseCongfig((String)data);
            if (tddlConfig != null) {
                if (tddlConfig instanceof AppRule) {
                    TDataSourceConfig.this.init((AppRule)tddlConfig);
                } else if (tddlConfig instanceof VirtualTableRoot) {
                    TDataSourceConfig.this.init((VirtualTableRoot)tddlConfig);
                }
            }
        }

        public void onDataReceive(Object data) {
            logger.warn((Object)("\u6682\u4e0d\u652f\u6301\u52a8\u6001\u4fee\u6539\u5206\u5e93\u5206\u8868\u89c4\u5219\uff0c\u6536\u5230\u63a8\u9001\uff1a" + data));
        }
    };
    private DataSourceFetcher springDataSourceFetcher = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (this.appRuleFiles != null) {
            this.isUseLocalConfig = true;
            this.appRuleFiles = this.doExternalResolve(this.appRuleFiles);
            if (this.appRuleFiles[0] != null && this.appRuleFiles[0].indexOf(".xml") != -1) {
                this.initBySpringBaseAppRuleFile(this.appRuleFiles);
            } else {
                if (this.appRuleFiles[0] == null || this.appRuleFiles[0].indexOf(".properties") == -1) throw new IllegalArgumentException("appRuleFile\u5c5e\u6027\u4e3a\u7a7a\u6216\u8005\u4e0d\u652f\u6301\u7684\u89c4\u5219\u6587\u4ef6\u7c7b\u578b");
                this.initByPropertyBaseAppRuleFile(this.appRuleFiles[0]);
            }
        } else if (this.appRuleString != null) {
            this.isUseLocalConfig = true;
            this.initByXmlBaseAppRuleString(this.appRuleString);
        } else if (this.appRulePropertiesString != null) {
            this.isUseLocalConfig = true;
            this.initByPropertyBaseAppRuleString(this.appRulePropertiesString);
        } else if (!this.isUseLocalConfig) {
            if (!this.dynamicRule) {
                Object firstFetchedShardRule = ConfigServerHelper.subscribeShardRuleConfig((String)this.appName, (ConfigServerHelper.DataListener)this.shardRuleListener);
                if (firstFetchedShardRule == null) {
                    throw new IllegalStateException("\u6ca1\u6709\u63a5\u6536\u5230\u5206\u5e93\u5206\u8868\u89c4\u5219\u914d\u7f6e");
                }
            } else {
                if (this.tddlRule == null) {
                    this.tddlRule = new TddlRuleInner();
                    this.tddlRule.setAppName(this.appName);
                    this.tddlRule.addRuleChangeListener((RuleChangeListener)this);
                    this.tddlRule.init();
                }
                for (RuleChangeListener listener : this.outListeners) {
                    this.tddlRule.addRuleChangeListener(listener);
                }
                String tddlRuleStr = RuleLeBeanConvert.convertLeAndOriRuleStr2InteractRule(this.tddlRule.getOldRuleStr());
                this.initByXmlBaseAppRuleString(tddlRuleStr);
            }
        }
        this.initDSMap();
        this.initPipeline();
        statMonitor.setAppName(this.appName);
        statMonitor.start();
    }

    protected String[] doExternalResolve(String ... locations) {
        if (this.springContext == null) {
            return this.appRuleFiles;
        }
        String[] externals = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                URL appRuleRes = this.springContext.getResource(locations[i]).getURL();
                logger.info((Object)("Resolving file: " + locations[i] + " --> " + appRuleRes));
                externals[i] = appRuleRes.toExternalForm();
                continue;
            }
            catch (IOException e) {
                logger.warn((Object)("error on resolving file: " + locations[i]));
                externals[i] = locations[i];
            }
        }
        return externals;
    }

    public void init(Map<String, DataSource> dataSourcePool, VirtualTableRoot vtr) {
        this.rwDataSourcePoolConfig = dataSourcePool;
        this.init(vtr);
        this.initDSMap();
        this.initPipeline();
    }

    private void initPipeline() {
        if (null == this.pipelineFactory) {
            this.pipelineFactory = this.dynamicRule && this.tddlRule != null ? new RuleLePipelineFactory(this.tddlRule) : (this.useNewRule ? new NewRulePipelineFactory() : new DefaultPipelineFactory());
        }
        this.pipelineFactory.setDefaultDispatcher(this.defaultDispatcher);
        this.pipelineFactory.setDispatcherMap(this.dispatcherMap);
        this.parallelManager = new ParallelDiamondConfigManager(this.appName);
        if (null != this.defaultDispatcher) {
            this.defaultDispatcher.setPipelineFactory(this.pipelineFactory);
        }
        Monitor.setAppName((String)this.appName);
    }

    private void initBySpringBaseAppRuleFile(String[] appRuleFiles) {
        FileSystemXmlApplicationContext ctx = null;
        ctx = null != this.specifyClassLoader ? new FileSystemXmlApplicationContext(appRuleFiles){

            public ClassLoader getClassLoader() {
                return TDataSourceConfig.this.specifyClassLoader;
            }
        } : new FileSystemXmlApplicationContext(appRuleFiles);
        this.initXmlAppRule((ApplicationContext)ctx);
    }

    private void initByPropertyBaseAppRuleFile(String propertyBaseRuleFile) {
        Properties prop = new Properties();
        try {
            InputStream is = null;
            is = null == this.springContext ? TDataSourceConfig.class.getClassLoader().getResourceAsStream(propertyBaseRuleFile) : this.springContext.getResource(propertyBaseRuleFile).getInputStream();
            prop.load(is);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u8bfb\u53d6property\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", e);
        }
        if (prop.get("table_rules") != null) {
            AppRule appRule = new AppRule();
            PropertyBaseTDDLRoot root = new PropertyBaseTDDLRoot();
            root.init(prop);
            appRule.setDefaultTddlRoot((TDDLRoot)root);
            this.init(appRule);
        } else if (prop.getProperty("tableRules") != null) {
            VirtualTableRoot vtr = PropertiesConfigParser.parseVirtualTableRoot((Properties)prop);
            this.init(vtr);
        } else {
            throw new IllegalStateException("No tableRules in properties:" + propertyBaseRuleFile);
        }
    }

    private void initByPropertyBaseAppRuleString(String propertyRuleString) {
        AppRule appRule = new AppRule();
        PropertyBaseTDDLRoot root = new PropertyBaseTDDLRoot();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(propertyRuleString.getBytes());
        Properties prop = new Properties();
        try {
            prop.load((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("\u8bfb\u53d6property\u914d\u7f6e\u6587\u4ef6\u9519\u8bef");
        }
        root.init(prop);
        appRule.setDefaultTddlRoot((TDDLRoot)root);
        this.init(appRule);
    }

    private void initByXmlBaseAppRuleString(String xmlRuleString) {
        StringXmlApplicationContext ctx = new StringXmlApplicationContext(xmlRuleString);
        this.initXmlAppRule((ApplicationContext)ctx);
    }

    private void initXmlAppRule(ApplicationContext ctx) {
        if (ctx.containsBean("root")) {
            AppRule appRule = (AppRule)ctx.getBean("root");
            this.init(appRule);
        } else if (ctx.containsBean("vtabroot")) {
            VirtualTableRoot vtr = (VirtualTableRoot)ctx.getBean("vtabroot");
            TDDLMBean mbean = new TDDLMBean("TDDL 2.4.4 Rule Info");
            mbean.setAttribute("dbType", (Object)vtr.getDbType().toString());
            if (vtr.getDbIndexMap() != null) {
                mbean.setAttribute("dbIndexMap", (Object)vtr.getDbIndexMap());
            }
            if (vtr.getDefaultDbIndex() != null) {
                mbean.setAttribute("defaultDBIndex", (Object)vtr.getDefaultDbIndex());
            }
            mbean.setAttribute("tableRules", (Object)vtr.getVirtualTableMap().toString());
            TDDLMBeanServer.registerMBeanWithId((Object)mbean, (String)"vtabroot");
            this.init(vtr);
        } else {
            TDDLRoot root = (TDDLRoot)ctx.getBean(this.ruleRootBeanID);
            TDDLMBean mbean = new TDDLMBean("Tddl Rule Info");
            if (root.getDefaultDBSelectorID() != null) {
                mbean.setAttribute("defaultDBIndex", (Object)root.getDefaultDBSelectorID());
            }
            mbean.setAttribute("dbType", (Object)root.getDBType().toString());
            mbean.setAttribute("logicTableMap", (Object)root.getLogicTableMap().toString());
            TDDLMBeanServer.registerMBean((Object)mbean, (String)"default rule");
            AppRule appRule = new AppRule();
            appRule.setDefaultTddlRoot(root);
            this.init(appRule);
        }
    }

    private void init(AppRule appRule) {
        SQLParserImp parser = new SQLParserImp();
        TDataSourceConfigHolder.setApplicationContext((ApplicationContext)this.springContext);
        appRule.init();
        TDataSourceConfigHolder.setApplicationContext(null);
        this.defaultDispatcher = TDataSourceConfig.buildSqlDispatcher((SQLParser)parser, appRule.getDefaultTddlRoot());
        this.dispatcherMap = new HashMap<String, SqlDispatcher>(4);
        for (Map.Entry entry : appRule.getRootMap().entrySet()) {
            TDDLMBean mbean = new TDDLMBean("Tddl Rule Info");
            if (((TDDLRoot)entry.getValue()).getDefaultDBSelectorID() != null) {
                mbean.setAttribute("defaultDBIndex", (Object)((TDDLRoot)entry.getValue()).getDefaultDBSelectorID());
            }
            mbean.setAttribute("dbType", (Object)((TDDLRoot)entry.getValue()).getDBType().toString());
            mbean.setAttribute("logicTableMap", (Object)((TDDLRoot)entry.getValue()).getLogicTableMap().toString());
            TDDLMBeanServer.registerMBean((Object)mbean, (String)((String)entry.getKey()));
            this.dispatcherMap.put((String)entry.getKey(), TDataSourceConfig.buildSqlDispatcher((SQLParser)parser, (TDDLRoot)entry.getValue()));
        }
    }

    private void init(VirtualTableRoot vtr) {
        SQLParserImp parser = new SQLParserImp();
        this.defaultDispatcher = TDataSourceConfig.buildSqlDispatcher((SQLParser)parser, vtr);
        this.dispatcherMap = new HashMap<String, SqlDispatcher>(1);
        this.dispatcherMap.put("master", this.defaultDispatcher);
        this.useNewRule = true;
    }

    private static SpringBasedDispatcherImpl buildSqlDispatcher(SQLParser parser, TDDLRoot tddlRoot) {
        if (tddlRoot != null) {
            SpringBasedDispatcherImpl dispatcher = new SpringBasedDispatcherImpl();
            dispatcher.setParser(parser);
            dispatcher.setRoot(tddlRoot);
            return dispatcher;
        }
        return null;
    }

    private static SpringBasedDispatcherImpl buildSqlDispatcher(SQLParser parser, VirtualTableRoot vtabroot) {
        if (vtabroot != null) {
            SpringBasedDispatcherImpl dispatcher = new SpringBasedDispatcherImpl();
            dispatcher.setParser(parser);
            dispatcher.setVtabroot(vtabroot);
            return dispatcher;
        }
        return null;
    }

    private Map<String, DataSource> initDSMap() {
        Map<String, DataSource> dsMap = null;
        if (this.rwDataSourcePoolConfig != null) {
            logger.warn((Object)("init data source map by local config ,ds map :[" + dsMap + "]"));
            dsMap = this.buildDbSelectors(this.rwDataSourcePoolConfig);
        } else {
            if (this.dataSourceMatrixCreator == null) {
                logger.warn((Object)"doesn't specfic datasource Matrix creator, use default ");
                this.dataSourceMatrixCreator = new DataSourceMatrixCreatorImp(this.dataSourceType);
            }
            if (this.appName == null || "".equals(this.appName)) {
                throw new IllegalArgumentException("\u5982\u679c\u6ca1\u6709\u6307\u5b9arwDatasource,\u90a3\u4e48\u4f1a\u4ece\u914d\u7f6e\u4e2d\u5fc3\u53bb\u53d6\uff0c\u56e0\u6b64\u5fc5\u987b\u6307\u5b9aappName.");
            }
            this.dataSourceMatrixCreator.setNewDSMatrixKey(this.appName);
            dsMap = this.dataSourceMatrixCreator.getDataSourceMap();
            this.dataSourceMatrixCreator.addPropertiesChangeListener(this);
        }
        if (this.dispatcherMap != null) {
            for (String key : this.dispatcherMap.keySet()) {
                if (!dsMap.containsKey(key)) continue;
                throw new IllegalArgumentException("\u6570\u636e\u6e90\u4e2d\u7684key\u4e0d\u80fd\u4e0e\u89c4\u5219\u5236\u5b9a\u7684key\u76f8\u540c\uff0c\u76f8\u540c\u7684key\u662f\uff1a" + key);
            }
        } else {
            logger.warn((Object)"dispatcher Map is null");
        }
        this.runtimeConfigHolder.set((Object)new TddlRuntime(dsMap));
        return dsMap;
    }

    private Map<String, DataSource> buildDbSelectors(Map<String, ? extends Object> dataSourcePool) {
        HashMap<String, DataSource> dsMap = new HashMap<String, DataSource>();
        for (Map.Entry<String, ? extends Object> e : dataSourcePool.entrySet()) {
            String dsKey = e.getKey();
            if (e.getValue() instanceof DataSource) {
                DataSourceConfig dbConfig = new DataSourceConfig();
                dbConfig.setDsObject((Object)((DataSource)e.getValue()));
                dsMap.put(dsKey, (DataSource)e.getValue());
                continue;
            }
            if (e.getValue() instanceof String) {
                if (this.springDataSourceFetcher == null) {
                    this.springDataSourceFetcher = new DataSourceFetcher(){

                        public DataSource getDataSource(String key) {
                            return (DataSource)TDataSourceConfig.this.springContext.getBean(key);
                        }

                        public DBType getDataSourceDBType(String key) {
                            return TDataSourceConfig.this.dbType;
                        }
                    };
                }
                dsMap.put(dsKey, (DataSource)TGroupDataSource.build((String)dsKey, (String)((String)e.getValue()), (DataSourceFetcher)this.springDataSourceFetcher, (DataSourceType)this.dataSourceType));
                continue;
            }
            if (e.getValue() instanceof DataSourceConfig) {
                dsMap.put(dsKey, ((DataSourceConfig)e.getValue()).getDataSource());
                continue;
            }
            if (!(e.getValue() instanceof DataSourceConfig[])) continue;
            throw new IllegalArgumentException("not support");
        }
        return Collections.unmodifiableMap(dsMap);
    }

    public TGroupDataSource buildGroupDS(String dbGroupKey, List<DataSourceWrapper> dss) {
        TGroupDataSource tGroupDataSource = new TGroupDataSource();
        tGroupDataSource.setDbGroupKey(dbGroupKey);
        tGroupDataSource.setDataSourceType(this.dataSourceType);
        tGroupDataSource.init(dss);
        return tGroupDataSource;
    }

    public void setDataSourcePool(Map<String, ? extends Object> dataSourcePool) {
        this.rwDataSourcePoolConfig = dataSourcePool;
    }

    public void setRwDataSourcePool(Map<String, ? extends Object> dataSourcePool) {
        this.rwDataSourcePoolConfig = dataSourcePool;
    }

    public void setRuleUrl(String ruleUrl) {
        throw new IllegalArgumentException("\u65b0\u5b9e\u73b0\u4e2d\u5c06\u4e0d\u518d\u652f\u6301\u65e7\u6709\u89c4\u5219\uff0c\u5982\u679c\u5e0c\u671b\u4f7f\u7528\u65e7\u6709\u89c4\u5219\u8bf7\u9009\u75282.1.9\u4ea7\u54c1\u3002");
    }

    public void setDefaultDbType(String defaultDbType) {
        this.defaultDbType = DBType.valueOf((String)defaultDbType);
    }

    public boolean isEnableProfileRealDBAndTables() {
        return this.enableProfileRealDBAndTables;
    }

    public void setEnableProfileRealDBAndTables(boolean enableProfileRealDBAndTables) {
        this.enableProfileRealDBAndTables = enableProfileRealDBAndTables;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setMasterOnly(boolean isMasterOnly) {
        this.isMasterOnly = isMasterOnly;
    }

    public void setSlaveOnly(boolean isSlaveOnly) {
        this.isSlaveOnly = isSlaveOnly;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setSlaveDispatcherRuleUrl(String[] appName) {
        this.setAppRuleFiles(appName);
    }

    public void setMasterDispatcherRuleUrl(String[] appName) {
        this.setAppRuleFiles(appName);
    }

    public void setMasterSlaveDispatcherRuleUrl(String[] masterSlaveDispatcherRuleUrl) {
        this.setAppRuleFiles(masterSlaveDispatcherRuleUrl);
    }

    public void setAppRuleFile(String appRuleFile) {
        this.appRuleFiles = appRuleFile.split(",");
    }

    public void setAppRuleFiles(String[] appRuleFiles) {
        this.appRuleFiles = appRuleFiles;
    }

    public void setUseLocalConfig(boolean isUseLocalConfig) {
        this.isUseLocalConfig = isUseLocalConfig;
    }

    public boolean isUseLocalConfig() {
        return this.isUseLocalConfig;
    }

    public boolean isHandleReplication() {
        return this.isHandleReplication;
    }

    public void setHandleReplication(boolean isHandleReplication) {
        this.isHandleReplication = isHandleReplication;
    }

    public void setHookPoints(HookPoints hookPoints) {
        this.hookPoints = hookPoints;
    }

    public HookPoints getHookPoints() {
        return this.hookPoints;
    }

    public Map<String, SqlDispatcher> getDispatcherMap() {
        return this.dispatcherMap;
    }

    public void setDispatcherMap(Map<String, SqlDispatcher> dispatcherMap) {
        this.dispatcherMap = dispatcherMap;
    }

    public SqlDispatcher getDefaultDispatcher() {
        return this.defaultDispatcher;
    }

    public void setDefaultDispatcher(SqlDispatcher defaultDispatcher) {
        this.defaultDispatcher = defaultDispatcher;
    }

    public RuntimeConfigHolder<TddlRuntime> getRuntimeConfigHolder() {
        return this.runtimeConfigHolder;
    }

    public String getRuleUrl() {
        return this.ruleUrl;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public String getWriteRuleRootBeanID() {
        return this.ruleRootBeanID;
    }

    public void setWriteRuleRootBeanID(String writeRuleRootBeanID) {
        this.ruleRootBeanID = writeRuleRootBeanID;
    }

    public String getReadRuleRootBeanID() {
        return this.ruleRootBeanID;
    }

    public void setReadRuleRootBeanID(String readRuleRootBeanID) {
        this.ruleRootBeanID = readRuleRootBeanID;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.springContext = applicationContext;
    }

    public ApplicationContext getSpringContext() throws BeansException {
        return this.springContext;
    }

    public synchronized void onDataSourceChanged(Map<String, DataSource> newDataSourceMap) {
        if (this.rwDataSourcePoolConfig != null) {
            logger.warn((Object)"receive a set of ds map . but TDDL DS has already using local rwDataSourcePool.abandon! ");
            logger.warn((Object)("ds map to be abandoned:" + newDataSourceMap));
        } else {
            this.runtimeConfigHolder.set((Object)new TddlRuntime(newDataSourceMap));
        }
    }

    public void setPipelineFactory(PipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public PipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    public String getAppRulePropertiesString() {
        return this.appRulePropertiesString;
    }

    public void setAppRulePropertiesString(String appRulePropertiesString) {
        this.appRulePropertiesString = appRulePropertiesString;
    }

    public void setDynamicRule(boolean dynamicRule) {
        this.dynamicRule = dynamicRule;
    }

    public void setAppRuleString(String appRuleString) {
        this.appRuleString = RuleLeBeanConvert.convertLeAndOriRuleStr2InteractRule(appRuleString);
    }

    public void setShutDownMBean(boolean shutDownMBean) {
        TDDLMBeanServer.shutDownMBean = shutDownMBean;
    }

    public void addOuterListener(RuleChangeListener listener) {
        this.outListeners.add(listener);
    }

    public void onRuleRecieve(String ruleString) {
        String tddlRuleStr = RuleLeBeanConvert.convertLeAndOriRuleStr2InteractRule(ruleString);
        this.initByXmlBaseAppRuleString(tddlRuleStr);
        this.defaultDispatcher.setPipelineFactory(this.pipelineFactory);
        this.pipelineFactory.setDefaultDispatcher(this.defaultDispatcher);
    }

    public void setSpecifyClassLoader(ClassLoader specifyClassLoader) {
        this.specifyClassLoader = specifyClassLoader;
    }

    public void setTddlRule(TddlRuleInner tddlRule) {
        this.tddlRule = tddlRule;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void destroyDataSource() {
        if (this.tddlRule != null) {
            this.tddlRule.destory();
        }
        this.dataSourceMatrixCreator.destroyAll();
    }
}

