/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.common.Monitor;
import com.taobao.tddl.common.monitor.SnapshotValuesOutputCallBack;
import com.taobao.tddl.common.monitor.stat.StatLogWriter;
import com.taobao.tddl.parser.ParserCache;
import java.util.concurrent.ThreadPoolExecutor;

public class TDataSourceState
implements SnapshotValuesOutputCallBack {
    private ThreadPoolExecutor replicationExecutor;
    private Integer replicationQueueSize;
    private final String dataSourceName;

    public TDataSourceState(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        Monitor.addSnapshotValuesCallbask((SnapshotValuesOutputCallBack)this);
    }

    public int getReplicationMinPoolSize() {
        return this.replicationExecutor == null ? -1 : this.replicationExecutor.getCorePoolSize();
    }

    public int getReplicationMaxPoolSize() {
        return this.replicationExecutor == null ? -1 : this.replicationExecutor.getMaximumPoolSize();
    }

    public int getReplicationCurrentPoolSize() {
        return this.replicationExecutor == null ? -1 : this.replicationExecutor.getPoolSize();
    }

    public int getReplicationCurrentQueueSize() {
        return this.replicationExecutor == null ? -1 : this.replicationExecutor.getQueue().size();
    }

    public int getReplicationMaxQueueSize() {
        return this.replicationQueueSize == null ? -1 : this.replicationQueueSize;
    }

    public int getParserCacheSize() {
        return ParserCache.instance().size();
    }

    public void snapshotValues(StatLogWriter statLog) {
        statLog.log((Object)(this.dataSourceName + "_replicationQueueSize"), new long[]{this.getReplicationCurrentQueueSize(), this.getReplicationMaxQueueSize()});
        statLog.log((Object)(this.dataSourceName + "_replicationPoolSize"), new long[]{this.getReplicationCurrentPoolSize(), this.getReplicationMaxPoolSize()});
        statLog.log((Object)(this.dataSourceName + "_parserCacheSize"), new long[]{this.getParserCacheSize(), ParserCache.instance().capacity});
    }

    public void setReplicationExecutor(ThreadPoolExecutor replicationExecutor) {
        this.replicationExecutor = replicationExecutor;
    }

    public void setReplicationQueueSize(Integer replicationQueueSize) {
        this.replicationQueueSize = replicationQueueSize;
    }
}

