/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.pipeline.DefaultPipelineFactory;
import com.taobao.tddl.client.pipeline.bootstrap.Bootstrap;
import com.taobao.tddl.client.util.ExceptionUtils;
import com.taobao.tddl.common.jdbc.ParameterContext;
import com.taobao.tddl.common.jdbc.ParameterMethod;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TPreparedStatementImp
extends TStatementImp
implements PreparedStatement {
    private static final Log log = LogFactory.getLog(TPreparedStatementImp.class);
    private final String originalSQL;
    List<Map<Integer, ParameterContext>> pstArgs;
    private int autoGeneratedKeys = -1;
    private int[] columnIndexes;
    private String[] columnNames;
    private Map<Integer, ParameterContext> parameterSettings = new TreeMap<Integer, ParameterContext>();

    public TPreparedStatementImp(ConnectionManager connectionManager, String originalSQL, Bootstrap bootStrap) {
        super(connectionManager, bootStrap);
        this.originalSQL = originalSQL;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameterSettings.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        SqlType sqlType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke execute, sql = " + this.originalSQL));
        }
        if ((sqlType = DefaultPipelineFactory.getSqlType(this.originalSQL)) == SqlType.SELECT || sqlType == SqlType.SELECT_FOR_UPDATE || sqlType == SqlType.SHOW) {
            this.executeQuery();
            return true;
        }
        if (sqlType == SqlType.INSERT || sqlType == SqlType.UPDATE || sqlType == SqlType.DELETE || sqlType == SqlType.REPLACE || sqlType == SqlType.TRUNCATE) {
            this.executeUpdate();
            return false;
        }
        throw new SQLException("only select, insert, update, delete ,replace,truncate sql is supported");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        SqlType sqlType = DefaultPipelineFactory.getSqlType(this.originalSQL);
        return this.executeQueryInternal(this.originalSQL, this.parameterSettings, sqlType, this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        SqlType sqlType = DefaultPipelineFactory.getSqlType(this.originalSQL);
        return this.executeUpdateInternal(this.originalSQL, this.autoGeneratedKeys, this.columnIndexes, this.columnNames, this.parameterSettings, sqlType, this);
    }

    protected PreparedStatement prepareStatementInternal(Connection connection, String targetSql) throws SQLException {
        PreparedStatement ps = this.getResultSetType() != -1 && this.getResultSetConcurrency() != -1 && this.getResultSetHoldability() != -1 ? connection.prepareStatement(targetSql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability()) : (this.getResultSetType() != -1 && this.getResultSetConcurrency() != -1 ? connection.prepareStatement(targetSql, this.getResultSetType(), this.getResultSetConcurrency()) : (this.autoGeneratedKeys != -1 ? connection.prepareStatement(targetSql, this.autoGeneratedKeys) : (this.columnIndexes != null ? connection.prepareStatement(targetSql, this.columnIndexes) : (this.columnNames != null ? connection.prepareStatement(targetSql, this.columnNames) : connection.prepareStatement(targetSql)))));
        return ps;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException("getMetaData");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("getParameterMetaData");
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setArray, new Object[]{i, x}));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setAsciiStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBigDecimal, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBinaryStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setBlob, new Object[]{i, x}));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBoolean, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setByte, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBytes, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setCharacterStream, new Object[]{parameterIndex, reader, length}));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setClob, new Object[]{i, x}));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDate1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDate2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDouble, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setFloat, new Object[]{parameterIndex, Float.valueOf(x)}));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setInt, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setLong, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setNull1, new Object[]{parameterIndex, sqlType}));
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.parameterSettings.put(paramIndex, new ParameterContext(ParameterMethod.setNull2, new Object[]{paramIndex, sqlType, typeName}));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject2, new Object[]{parameterIndex, x, targetSqlType}));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject3, new Object[]{parameterIndex, x, targetSqlType, scale}));
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setRef, new Object[]{i, x}));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setShort, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setString, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTime1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTime2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTimestamp1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTimestamp2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setURL, new Object[]{parameterIndex, x}));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setUnicodeStream, new Object[]{parameterIndex, x, length}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke executeBatch, sql = " + this.originalSQL));
        }
        if (this.batchedArgs == null || this.batchedArgs.size() != 0) {
            // empty if block
        }
        List<SQLException> exceptions = new ArrayList<SQLException>();
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        if (this.pstArgs == null || this.pstArgs.isEmpty()) {
            return new int[0];
        }
        Map<String, Map<String, List<List<ParameterContext>>>> pstExecutionContext = null;
        DirectlyRouteCondition ruleCondition = (DirectlyRouteCondition)this.getRouteContiongFromThreadLocal("RULE_SELECTOR");
        if (ruleCondition != null) {
            String dbRuleId = ruleCondition.getDbRuleID();
            pstExecutionContext = super.sortPreparedBatch(this.originalSQL, this.pstArgs, dbRuleId);
        } else {
            pstExecutionContext = super.sortPreparedBatch(this.originalSQL, this.pstArgs, null);
        }
        if (pstExecutionContext.size() > 1 && !this.connectionManager.getAutoCommit()) {
            throw new SQLException("executeBatch\u6682\u4e0d\u652f\u6301\u8de8\u5e93\u4e8b\u52a1\uff0c\u8be5\u4e8b\u52a1\u6d89\u53ca " + pstExecutionContext.size() + " \u4e2a\u5e93\u3002");
        }
        for (Map.Entry<String, Map<String, List<List<ParameterContext>>>> entry : pstExecutionContext.entrySet()) {
            String dbSelectorID = entry.getKey();
            List<Integer> list = null;
            try {
                Connection conn = this.connectionManager.getConnection(dbSelectorID, false);
                try {
                    list = this.executeBatchOnOneConnAndClosePreparedStatement(exceptions, entry.getValue(), conn);
                    result.addAll(list);
                }
                finally {
                    exceptions = this.tryCloseConnection(exceptions, dbSelectorID);
                }
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
            finally {
                this.pstArgs.clear();
            }
        }
        this.currentResultSet = null;
        this.moreResults = false;
        this.updateCount = 0;
        ExceptionUtils.throwSQLException(exceptions, "batch", (List<Object>)null);
        super.executeBatch();
        return TPreparedStatementImp.fromListToArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> executeBatchOnOneConnAndClosePreparedStatement(List<SQLException> sqlExceptions, Map<String, List<List<ParameterContext>>> sqlMap, Connection conn) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            for (Map.Entry<String, List<List<ParameterContext>>> sqlMapEntry : sqlMap.entrySet()) {
                PreparedStatement ps = this.prepareStatementInternal(conn, sqlMapEntry.getKey());
                try {
                    int[] temp = null;
                    for (List<ParameterContext> params : sqlMapEntry.getValue()) {
                        TPreparedStatementImp.setBatchParameters(ps, params);
                        ps.addBatch();
                    }
                    temp = ps.executeBatch();
                    result.addAll(TStatementImp.fromArrayToList(temp));
                    ps.clearBatch();
                }
                finally {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            sqlExceptions = ExceptionUtils.appendToExceptionList(sqlExceptions, e);
        }
        return result;
    }

    private static void setBatchParameters(PreparedStatement ps, List<ParameterContext> batchedParameters) throws SQLException {
        for (ParameterContext context : batchedParameters) {
            context.getParameterMethod().setParameter(ps, context.getArgs());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.pstArgs == null) {
            this.pstArgs = new LinkedList<Map<Integer, ParameterContext>>();
        }
        TreeMap<Integer, ParameterContext> newArg = new TreeMap<Integer, ParameterContext>();
        newArg.putAll(this.parameterSettings);
        this.pstArgs.add(newArg);
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnIndexes(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("not support exception");
    }
}

