/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.databus.StartInfo;
import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.OrderByColumn;
import com.taobao.tddl.client.jdbc.PreparedStatementExecutorCommon;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.SqlExecuteEvent;
import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.listener.Context;
import com.taobao.tddl.client.jdbc.listener.Handler;
import com.taobao.tddl.client.jdbc.listener.HookPoints;
import com.taobao.tddl.client.jdbc.resultset.newImp.CountTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.DistinctTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.DummyTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.MaxTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.MinTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.OrderByTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.ShallowTResultSetWrapper;
import com.taobao.tddl.client.jdbc.resultset.newImp.SimpleTResultSet;
import com.taobao.tddl.client.jdbc.resultset.newImp.SumTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutorImp;
import com.taobao.tddl.client.jdbc.sqlexecutor.SimpleRealSqlExecutorImp;
import com.taobao.tddl.client.jdbc.sqlexecutor.UpdateReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelRealSqlExecutor;
import com.taobao.tddl.client.jdbc.sqlexecutor.serial.SerialRealSqlExecutor;
import com.taobao.tddl.client.pipeline.DefaultPipelineFactory;
import com.taobao.tddl.client.pipeline.bootstrap.Bootstrap;
import com.taobao.tddl.client.util.ExceptionUtils;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.jdbc.ParameterContext;
import com.taobao.tddl.interact.monitor.TotalStatMonitor;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.sqlobjecttree.GroupFunctionType;
import com.taobao.tddl.sqlobjecttree.OrderByEle;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TStatementImp
extends PreparedStatementExecutorCommon
implements Statement {
    private TDataSource.TDSProperties properties;
    protected final Bootstrap bootstrap;
    protected SerialRealSqlExecutor serialRealSqlExecutor;
    protected ParallelRealSqlExecutor parallelRealSqlExecutor;
    protected SerialRealSqlExecutor simpleSerialRealSqlExecutor;
    private static final Log log = LogFactory.getLog(TStatementImp.class);
    private static final Log sqlLog = LogFactory.getLog((String)"TDDL_SQL_LOG");
    protected int queryTimeout = 0;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    protected DummyTResultSet currentResultSet;
    protected boolean moreResults;
    protected int updateCount;
    protected boolean closed;
    private int resultSetType = -1;
    private int resultSetConcurrency = -1;
    private int resultSetHoldability = -1;
    protected List<String> batchedArgs;
    private HookPoints hookPoints;
    private Context context;

    protected static void dumpSql(String originalSql, Map<String, List<RealSqlContext>> targets, Map<Integer, ParameterContext> parameters) {
        if (sqlLog.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n[original sql]:").append(originalSql.trim()).append("\n");
            for (Map.Entry<String, List<RealSqlContext>> entry : targets.entrySet()) {
                for (RealSqlContext targetSql : entry.getValue()) {
                    buffer.append(" [").append(entry.getKey()).append(".").append(targetSql.getRealTable()).append("]:").append(targetSql.getSql().trim()).append("\n");
                }
            }
            if (parameters != null && !parameters.isEmpty() && !parameters.values().isEmpty()) {
                buffer.append("[parameters]:").append(parameters.values().toString());
            }
            sqlLog.debug((Object)buffer.toString());
        }
        for (Map.Entry<String, List<RealSqlContext>> entry : targets.entrySet()) {
            for (RealSqlContext rsc : entry.getValue()) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getKey());
                sb.append("#@#");
                sb.append(rsc.getRealTable());
                TotalStatMonitor.dbTabIncrement((String)sb.toString());
            }
        }
    }

    public TStatementImp(ConnectionManager connectionManager, Bootstrap bootstrap) {
        super(connectionManager);
        this.bootstrap = bootstrap;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateInternal(sql, -1, null, null);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdateInternal(sql, autoGeneratedKeys, null, null);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdateInternal(sql, -1, columnIndexes, null);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdateInternal(sql, -1, null, columnNames);
    }

    protected RouteCondition getRouteContiongFromThreadLocal(String key) {
        RouteCondition.ROUTE_TYPE routeType;
        RouteCondition rc = (RouteCondition)ThreadLocalMap.get((Object)key);
        if (rc != null && RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE.equals((Object)(routeType = rc.getRouteType()))) {
            ThreadLocalMap.put((Object)key, null);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInterval(boolean closeInvokeByCurrTStatement) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke close");
        }
        if (this.closed) {
            return;
        }
        List<SQLException> exceptions = null;
        this.closed = true;
        try {
            try {
                if (this.currentResultSet != null) {
                    this.currentResultSet.closeInternal();
                }
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
        }
        finally {
            this.closed = true;
            this.currentResultSet = null;
            if (closeInvokeByCurrTStatement) {
                this.connectionManager.removeCurrentStatement(this);
            }
        }
        ExceptionUtils.throwSQLException(exceptions, "close", Collections.<Object>emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdateInternal(String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, Map<Integer, ParameterContext> sqlParam, SqlType sqlType, TStatementImp statementImp) throws SQLException {
        try {
            int n = this.executeUpdateInternalInTry(sql, autoGeneratedKeys, columnIndexes, columnNames, sqlParam, sqlType, statementImp);
            return n;
        }
        finally {
            if (this.connectionManager.getAutoCommit()) {
                this.context.reset();
            }
        }
    }

    protected int executeUpdateInternalInTry(String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, Map<Integer, ParameterContext> sqlParam, SqlType sqlType, TStatementImp tStatementImp) throws SQLException {
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        long startTime = System.currentTimeMillis();
        ExecutionPlan context = this.buildSqlExecutionContextUsePipeline(sql, sqlParam, sqlType);
        if (context.getEvents() != null) {
            this.context.getEvents().addAll(context.getEvents());
        }
        if (context.mappingRuleReturnNullValue()) {
            return 0;
        }
        this.beforeSqlExecute();
        int tablesSize = 0;
        Map<String, List<RealSqlContext>> sqlMap = context.getSqlMap();
        int databaseSize = sqlMap.size();
        TStatementImp.dumpSql(sql, sqlMap, null);
        int affectedRows = 0;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        Set<Map.Entry<String, List<RealSqlContext>>> set = sqlMap.entrySet();
        RealSqlExecutorImp rse = new RealSqlExecutorImp(this.parallelRealSqlExecutor, this.serialRealSqlExecutor, tStatementImp, context);
        context.setAutoGeneratedKeys(autoGeneratedKeys);
        context.setColumnIndexes(columnIndexes);
        context.setColumnNames(columnNames);
        for (Map.Entry<String, List<RealSqlContext>> entry : set) {
            UpdateReturn ur = null;
            try {
                ur = rse.update();
            }
            catch (SQLException e) {
                exceptions.add(e);
                break;
            }
            affectedRows += ur.getAffectedRows();
            exceptions.addAll(ur.getExceptions());
            tablesSize += entry.getValue().size();
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        ExceptionUtils.throwSQLException(exceptions, sql, sqlParam);
        this.currentResultSet = null;
        this.moreResults = false;
        this.updateCount = affectedRows;
        this.context.setAffectedRows(affectedRows);
        this.profileUpdate(sql, context, tablesSize, databaseSize, exceptions, elapsedTime);
        this.afterSqlExecute();
        return affectedRows;
    }

    private int executeUpdateInternal(String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        SqlType sqlType = DefaultPipelineFactory.getSqlType(sql);
        return this.executeUpdateInternal(sql, autoGeneratedKeys, columnIndexes, columnNames, null, sqlType, this);
    }

    protected void profileUpdate(String sql, ExecutionPlan context, int tablesSize, int databaseSize, List<SQLException> exceptions, long elapsedTime) throws SQLException {
        this.profileWithException(exceptions, context.getVirtualTableName().toString(), sql, elapsedTime);
        this.profileNumberOfDBAndTablesAndDuringTime(context.getVirtualTableName().toString(), databaseSize, tablesSize, sql, elapsedTime);
    }

    protected void afterSqlExecute() throws SQLException {
        if (this.connectionManager.getAutoCommit()) {
            if (this.hookPoints.getAfterExecute() != Handler.DUMMY_HANDLER && !this.context.isEventsEmpty()) {
                for (SqlExecuteEvent event : this.context.getEvents()) {
                    event.setAfterMainDBSqlExecuteTime(System.currentTimeMillis());
                }
            }
            this.hookPoints.getAfterExecute().execute(this.context);
        }
    }

    private Statement createStatementInternal(Connection connection) throws SQLException {
        Statement stmt = this.resultSetType != -1 && this.resultSetConcurrency != -1 && this.resultSetHoldability != -1 ? connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability) : (this.resultSetType != -1 && this.resultSetConcurrency != -1 ? connection.createStatement(this.resultSetType, this.resultSetConcurrency) : connection.createStatement());
        return stmt;
    }

    private boolean executeInternal(String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        SqlType sqlType = DefaultPipelineFactory.getSqlType(sql);
        if (sqlType == SqlType.SELECT || sqlType == SqlType.SELECT_FOR_UPDATE || sqlType == SqlType.SHOW) {
            this.executeQuery(sql);
            return true;
        }
        if (sqlType == SqlType.INSERT || sqlType == SqlType.UPDATE || sqlType == SqlType.DELETE || sqlType == SqlType.REPLACE || sqlType == SqlType.TRUNCATE) {
            if (autoGeneratedKeys == -1 && columnIndexes == null && columnNames == null) {
                this.executeUpdate(sql);
            } else if (autoGeneratedKeys != -1) {
                this.executeUpdate(sql, autoGeneratedKeys);
            } else if (columnIndexes != null) {
                this.executeUpdate(sql, columnIndexes);
            } else if (columnNames != null) {
                this.executeUpdate(sql, columnNames);
            } else {
                this.executeUpdate(sql);
            }
            return false;
        }
        throw new SQLException("only select, insert, update, delete,truncate sql is supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, -1, null, null);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, autoGeneratedKeys, null, null);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, -1, columnIndexes, null);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, -1, null, columnNames);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new LinkedList<String>();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        this.closeInterval(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        if (this.batchedArgs == null || this.batchedArgs.isEmpty()) {
            return new int[0];
        }
        List<SQLException> exceptions = new ArrayList<SQLException>();
        ArrayList<Integer> result = new ArrayList<Integer>();
        Map<String, List<String>> sqls = null;
        try {
            DirectlyRouteCondition ruleCondition = (DirectlyRouteCondition)this.getRouteContiongFromThreadLocal("RULE_SELECTOR");
            if (ruleCondition != null) {
                String dbRuleId = ruleCondition.getDbRuleID();
                sqls = this.sortBatch(this.batchedArgs, dbRuleId);
            } else {
                sqls = this.sortBatch(this.batchedArgs, null);
            }
            if (sqls.size() > 1 && !this.connectionManager.getAutoCommit()) {
                throw new SQLException("executeBatch\u6682\u4e0d\u652f\u6301\u8de8\u5e93\u4e8b\u52a1\uff0c\u8be5\u4e8b\u52a1\u6d89\u53ca " + sqls.size() + " \u4e2a\u5e93\u3002");
            }
            for (Map.Entry<String, List<String>> entry : sqls.entrySet()) {
                String dbSelectorID = entry.getKey();
                List<Integer> list = null;
                try {
                    Connection conn = this.connectionManager.getConnection(dbSelectorID, false);
                    try {
                        list = this.executeBatchOnOneConnAndCloseStatement(exceptions, entry.getValue(), conn);
                        result.addAll(list);
                    }
                    finally {
                        exceptions = this.tryCloseConnection(exceptions, dbSelectorID);
                    }
                }
                catch (SQLException e) {
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
                }
            }
        }
        finally {
            this.batchedArgs.clear();
        }
        this.currentResultSet = null;
        this.moreResults = false;
        this.updateCount = 0;
        ExceptionUtils.throwSQLException(exceptions, "batch", (Map<Integer, ParameterContext>)Collections.EMPTY_MAP);
        return TStatementImp.fromListToArray(result);
    }

    public Map<String, List<String>> sortBatch(List<String> sql, String selectKey) throws SQLException {
        HashMap<String, List<String>> targetSqls = new HashMap<String, List<String>>(8);
        StartInfo startInfo = new StartInfo();
        for (String originalSql : sql) {
            startInfo.setSql(originalSql);
            startInfo.setSqlType(DefaultPipelineFactory.getSqlType(originalSql));
            this.bootstrap.bootstrapForBatch(startInfo, false, targetSqls, selectKey);
        }
        return targetSqls;
    }

    public Map<String, Map<String, List<List<ParameterContext>>>> sortPreparedBatch(String sql, List<Map<Integer, ParameterContext>> batchedParameters, String selectKey) throws SQLException {
        HashMap<String, Map<String, List<List<ParameterContext>>>> targetSqls = new HashMap<String, Map<String, List<List<ParameterContext>>>>(16);
        StartInfo startInfo = new StartInfo();
        startInfo.setSql(sql);
        startInfo.setSqlType(DefaultPipelineFactory.getSqlType(sql));
        for (Map<Integer, ParameterContext> map : batchedParameters) {
            startInfo.setSqlParam(map);
            this.bootstrap.bootstrapForPrepareBatch(startInfo, false, targetSqls, selectKey);
        }
        return targetSqls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> executeBatchOnOneConnAndCloseStatement(List<SQLException> exceptions, List<String> sqls, Connection conn) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            Statement stmt = this.createStatementInternal(conn);
            try {
                try {
                    int[] temp = null;
                    for (String targetSql : sqls) {
                        stmt.addBatch(targetSql);
                    }
                    temp = stmt.executeBatch();
                    result.addAll(TStatementImp.fromArrayToList(temp));
                }
                catch (SQLException e) {
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
                }
                stmt.clearBatch();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
        }
        return result;
    }

    public static List<Integer> fromArrayToList(int[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int num : array) {
            result.add(num);
        }
        return result;
    }

    public static int[] fromListToArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("No operations allowed after statement closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureResultSetIsEmpty() throws SQLException {
        if (this.currentResultSet != null) {
            log.debug((Object)"result set is not null,close current result set");
            try {
                this.currentResultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"exception on close last result set . can do nothing..", (Throwable)e);
            }
            finally {
                this.currentResultSet = null;
            }
        }
    }

    protected ResultSet executeQueryInternal(String sql, Map<Integer, ParameterContext> originalParameterSettings, SqlType sqlType, TStatementImp tStatementImp) throws SQLException {
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        ExecutionPlan context = null;
        context = this.buildSqlExecutionContextUsePipeline(sql, originalParameterSettings, sqlType);
        if (context.mappingRuleReturnNullValue()) {
            this.currentResultSet = this.getEmptyResultSet(this);
            return this.currentResultSet;
        }
        TStatementImp.dumpSql(sql, context.getSqlMap(), originalParameterSettings);
        DummyTResultSet result = null;
        this.currentResultSet = result = this.mergeResultSets(this, this.connectionManager, context);
        this.moreResults = false;
        this.updateCount = -1;
        if (this.connectionManager.getAutoCommit()) {
            this.context.reset();
        }
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        SqlType sqlType = DefaultPipelineFactory.getSqlType(sql);
        return this.executeQueryInternal(sql, null, sqlType, this);
    }

    protected DummyTResultSet mergeResultSets(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan context) throws SQLException {
        if (context.getOrderByColumns() != null && !context.getOrderByColumns().isEmpty() && context.getGroupFunctionType() != GroupFunctionType.NORMAL) {
            throw new SQLException("'group function' and 'order by' can't be together!");
        }
        Map<String, List<RealSqlContext>> map = context.getSqlMap();
        if (map.size() == 1) {
            for (List<RealSqlContext> rscs : map.values()) {
                if (rscs.size() != 1) continue;
                return new ShallowTResultSetWrapper(tStatementImp, connectionManager, context);
            }
        }
        RealSqlExecutorImp rse = new RealSqlExecutorImp(this.parallelRealSqlExecutor, this.serialRealSqlExecutor, tStatementImp, context);
        if (context.getGroupFunctionType() == GroupFunctionType.AVG) {
            throw new SQLException("The group function 'AVG' is not supported now!");
        }
        if (context.getGroupFunctionType() == GroupFunctionType.COUNT) {
            return new CountTResultSet(tStatementImp, connectionManager, context, rse);
        }
        if (context.getGroupFunctionType() == GroupFunctionType.MAX) {
            return new MaxTResultSet(tStatementImp, connectionManager, context, rse);
        }
        if (context.getGroupFunctionType() == GroupFunctionType.MIN) {
            return new MinTResultSet(tStatementImp, connectionManager, context, rse);
        }
        if (context.getGroupFunctionType() == GroupFunctionType.SUM) {
            return new SumTResultSet(tStatementImp, connectionManager, context, rse);
        }
        if (context.getDistinctColumns() != null && context.getDistinctColumns().size() != 0) {
            DistinctTResultSet rs = new DistinctTResultSet(tStatementImp, connectionManager, context, rse);
            rs.setDistinctColumn(context.getDistinctColumns());
            return rs;
        }
        if (context.getOrderByColumns() != null && !context.getOrderByColumns().isEmpty()) {
            OrderByColumn[] orderByColumns = new OrderByColumn[context.getOrderByColumns().size()];
            int i = 0;
            for (OrderByEle element : context.getOrderByColumns()) {
                orderByColumns[i] = new OrderByColumn();
                orderByColumns[i].setColumnName(element.getName());
                orderByColumns[i++].setAsc(element.isASC());
            }
            OrderByTResultSet orderByTResultSet = new OrderByTResultSet(tStatementImp, connectionManager, context, rse);
            orderByTResultSet.setOrderByColumns(orderByColumns);
            orderByTResultSet.setLimitFrom(context.getSkip());
            orderByTResultSet.setLimitTo(context.getMax());
            return orderByTResultSet;
        }
        SimpleRealSqlExecutorImp spe = new SimpleRealSqlExecutorImp(this.parallelRealSqlExecutor, this.simpleSerialRealSqlExecutor, tStatementImp, context);
        SimpleTResultSet simpleTResultSet = new SimpleTResultSet(tStatementImp, connectionManager, context, spe);
        simpleTResultSet.setLimitFrom(context.getSkip());
        simpleTResultSet.setLimitTo(context.getMax());
        return simpleTResultSet;
    }

    protected void beforeSqlExecute() throws SQLException {
        if (this.connectionManager.getAutoCommit()) {
            this.hookPoints.getBeforeExecute().execute(this.context);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connectionManager.getProxyConnection();
    }

    private ExecutionPlan buildSqlExecutionContextUsePipeline(String sql, Map<Integer, ParameterContext> originalParameterSettings, SqlType sqlType) throws SQLException {
        StartInfo startInfo = new StartInfo();
        startInfo.setSql(sql);
        startInfo.setSqlType(sqlType);
        startInfo.setSqlParam(originalParameterSettings);
        return this.bootstrap.bootstrap(startInfo);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("getFetchDirection");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("getMaxFieldSize");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.moreResults;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        throw new UnsupportedOperationException("setCursorName");
    }

    @Override
    public void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        throw new UnsupportedOperationException("setEscapeProcessing");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("getMoreResults");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        throw new UnsupportedOperationException("setFetchDirection");
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        throw new UnsupportedOperationException("setMaxFieldSize");
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.maxRows = maxRows;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("getGeneratedKeys");
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException("cancel");
    }

    public boolean isCurrentRSClosedOrNull() {
        return this.currentResultSet == null ? true : this.currentResultSet.isClosed();
    }

    public void setHookPoints(HookPoints hookPoints) {
        this.hookPoints = hookPoints;
    }

    public HookPoints getHookPoints() {
        return this.hookPoints;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public int getQueryTimeOut() {
        return this.queryTimeout;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public TDataSource.TDSProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TDataSource.TDSProperties properties) {
        this.properties = properties;
    }

    public void setSerialRealSqlExecutor(SerialRealSqlExecutor serialRealSqlExecutor) {
        this.serialRealSqlExecutor = serialRealSqlExecutor;
    }

    public void setParallelRealSqlExecutor(ParallelRealSqlExecutor parallelRealSqlExecutor) {
        this.parallelRealSqlExecutor = parallelRealSqlExecutor;
    }

    public void setSimpleSerialRealSqlExecutor(SerialRealSqlExecutor simpleSerialRealSqlExecutor) {
        this.simpleSerialRealSqlExecutor = simpleSerialRealSqlExecutor;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("not support exception");
    }
}

