/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.listener;

import com.taobao.tddl.client.jdbc.listener.Context;
import java.sql.SQLException;

public abstract class Handler {
    protected Handler onSuccess;
    protected Handler onFail;
    protected Handler onFinally;
    public static final Handler DUMMY_HANDLER = new Handler(){

        @Override
        public boolean run(Context context) {
            return true;
        }

        @Override
        public void setOnSuccess(Handler onSuccess) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOnFail(Handler onFail) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOnFinally(Handler onFinally) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void appendFinally(Handler onFinally) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Handler.DUMMY_HANDLER";
        }
    };

    protected abstract boolean run(Context var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Context context) throws SQLException {
        try {
            if (this.run(context)) {
                if (this.onSuccess != null) {
                    this.onSuccess.execute(context);
                }
            } else if (this.onFail != null) {
                this.onFail.execute(context);
            }
        }
        finally {
            if (this.onFinally != null) {
                this.onFinally.execute(context);
            }
        }
    }

    public void setOnSuccess(Handler onSuccess) {
        this.onSuccess = onSuccess;
    }

    public Handler getOnSuccess() {
        return this.onSuccess;
    }

    public void setOnFail(Handler onFail) {
        this.onFail = onFail;
    }

    public Handler getOnFail() {
        return this.onFail;
    }

    public void setOnFinally(Handler onFinally) {
        this.onFinally = onFinally;
    }

    public void appendFinally(Handler onFinally) {
        Handler insertPoint = this;
        while (insertPoint.getOnFinally() != null) {
            insertPoint = insertPoint.getOnFinally();
        }
        insertPoint.setOnFinally(onFinally);
    }

    public Handler getOnFinally() {
        return this.onFinally;
    }
}

