/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.replication;

import com.taobao.tddl.client.jdbc.SqlExecuteEvent;
import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.client.jdbc.replication.ReplicationSwitcher;
import com.taobao.tddl.client.jdbc.replication.RowBasedReplicationListener;
import com.taobao.tddl.common.sync.ReplicationTaskListener;
import com.taobao.tddl.common.sync.RowBasedReplicationContext;
import com.taobao.tddl.common.sync.RowBasedReplicationTask;
import java.sql.SQLException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncRowBasedReplicationListener
extends RowBasedReplicationListener
implements ReplicationSwitcher.ReplicationConfigAware {
    private static final Log logger = LogFactory.getLog(AsyncRowBasedReplicationListener.class);
    private static final Log localFailSyncLog = LogFactory.getLog((String)"TDDL_LOCAL_FAIL_SYNC_LOG");
    private int threadPoolSize = 4;
    private int workQueueSize = 4096;
    private ThreadPoolExecutor replicationExecutor;
    private int insertSyncLogThreadPoolSize = 2;
    private int insertSyncLogWorkQueueSize = 1024;
    private ThreadPoolExecutor insertSyncLogExecutor;
    private ReplicationTaskListener taskListener;

    @Override
    public void init(TDataSource tds) {
        super.init(tds);
        this.init();
        tds.state.setReplicationExecutor(this.replicationExecutor);
        tds.state.setReplicationQueueSize(this.workQueueSize);
    }

    @Override
    public void init() {
        super.init();
        this.replicationSwitcher.addReplicationConfigAware(this);
        this.replicationExecutor = new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.workQueueSize), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                logger.warn((Object)"A RowBasedReplicationTask discarded");
            }
        });
        this.insertSyncLogExecutor = new ThreadPoolExecutor(this.insertSyncLogThreadPoolSize, this.insertSyncLogThreadPoolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.insertSyncLogWorkQueueSize), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                2 v0 = this;
                AsyncRowBasedReplicationListener.access$301(localFailSyncLog, ((InsertSyncLogTask)r).event);
            }
        });
    }

    @Override
    protected void doAfterSqlExecute(RowBasedReplicationContext context) {
        this.replicationExecutor.execute((Runnable)new RowBasedReplicationTask(context, this.taskListener));
    }

    @Override
    protected void asyncInsertSyncLog2Db(SqlExecuteEvent event) {
        RowBasedReplicationListener.insertSyncLog2LocalFile(event);
        this.insertSyncLogExecutor.execute(new InsertSyncLogTask(event, this));
    }

    @Override
    public void setInsertSyncLogThreadPoolSize(int threadPoolSize) {
        StringBuilder sb = new StringBuilder("InsertSyncLogThreadPoolSize [").append(this.insertSyncLogThreadPoolSize);
        sb.append("] switching to [").append(threadPoolSize).append("] ");
        this.insertSyncLogThreadPoolSize = threadPoolSize;
        this.insertSyncLogExecutor.setCorePoolSize(this.insertSyncLogThreadPoolSize);
        this.insertSyncLogExecutor.setMaximumPoolSize(this.insertSyncLogThreadPoolSize);
        sb.append("succeed.");
        logger.warn((Object)sb.toString());
    }

    @Override
    public int getInsertSyncLogThreadPoolSize() {
        return this.insertSyncLogThreadPoolSize;
    }

    @Override
    public void setReplicationThreadPoolSize(int threadPoolSize) {
        StringBuilder sb = new StringBuilder("ReplicationThreadPoolSize [").append(this.threadPoolSize);
        sb.append("] switching to [").append(threadPoolSize).append("] ");
        this.threadPoolSize = threadPoolSize;
        this.replicationExecutor.setCorePoolSize(this.threadPoolSize);
        this.replicationExecutor.setMaximumPoolSize(this.threadPoolSize);
        sb.append("succeed.");
        logger.warn((Object)sb.toString());
    }

    @Override
    public int getReplicationThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setWorkQueueSize(int workQueueSize) {
        this.workQueueSize = workQueueSize;
    }

    public void setInsertSyncLogWorkQueueSize(int insertSyncLogWorkQueueSize) {
        this.insertSyncLogWorkQueueSize = insertSyncLogWorkQueueSize;
    }

    public void setTaskListener(ReplicationTaskListener taskListener) {
        this.taskListener = taskListener;
    }

    public ReplicationTaskListener getTaskListener() {
        return this.taskListener;
    }

    static /* synthetic */ void access$301(Log x0, SqlExecuteEvent x1) {
        RowBasedReplicationListener.insertSyncLog2LocalFile(x0, x1);
    }

    static class InsertSyncLogTask
    implements Runnable {
        private final SqlExecuteEvent event;
        private final RowBasedReplicationListener listener;

        public InsertSyncLogTask(SqlExecuteEvent event, RowBasedReplicationListener listener) {
            this.event = event;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.listener.insertSyncLog2Db(this.event);
            }
            catch (SQLException e) {
                RowBasedReplicationListener.insertSyncLog2LocalFile(localFailSyncLog, this.event);
            }
        }
    }
}

