/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.replication;

import com.alibaba.common.lang.io.ByteArrayInputStream;
import com.taobao.tddl.client.jdbc.replication.ReplicationSwitcher;
import com.taobao.tddl.common.ConfigServerHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigServerReplicationSwitcher
implements ReplicationSwitcher {
    private static final Log logger = LogFactory.getLog(ConfigServerReplicationSwitcher.class);
    private String appName;
    private volatile ReplicationSwitcher.Level level = ReplicationSwitcher.Level.ALL_ON;
    private volatile ReplicationSwitcher.InsertSyncLogMode insertSyncLogMode = ReplicationSwitcher.InsertSyncLogMode.normal;
    private List<ReplicationSwitcher.ReplicationConfigAware> replicationConfigAwares = new ArrayList<ReplicationSwitcher.ReplicationConfigAware>(1);
    private final ConfigServerHelper.DataListener replicationSwitchListener = new ConfigServerHelper.AbstractDataListener(){

        public void onDataReceive(Object data) {
            ConfigServerReplicationSwitcher.this.parsePropertiesConfig(ConfigServerHelper.parseProperties((Object)data, (String)"[replicationSwitchListener]"));
        }
    };

    public void init() {
        Object firstFetchedConfigs = ConfigServerHelper.subscribeReplicationSwitch((String)this.appName, (ConfigServerHelper.DataListener)this.replicationSwitchListener);
        if (firstFetchedConfigs == null) {
            if (this.level == null) {
                throw new IllegalArgumentException("\u65e2\u4e0d\u80fd\u4ececonfig server\u83b7\u5f97\u884c\u590d\u5236\u5f00\u5173\u914d\u7f6e\uff0c\u4e5f\u6ca1\u6709\u9ed8\u8ba4\u914d\u7f6e!");
            }
            logger.warn((Object)("\u4f7f\u7528\u672c\u5730level\u914d\u7f6e\uff1a" + (Object)((Object)this.level)));
        }
    }

    @Override
    public ReplicationSwitcher.Level level() {
        return this.level;
    }

    @Override
    public ReplicationSwitcher.InsertSyncLogMode insertSyncLogMode() {
        return this.insertSyncLogMode;
    }

    @Override
    public void addReplicationConfigAware(ReplicationSwitcher.ReplicationConfigAware replicationConfigAware) {
        this.replicationConfigAwares.add(replicationConfigAware);
    }

    private void parsePropertiesConfig(Properties properties) {
        if (properties == null) {
            logger.warn((Object)"Empty ReplicationSwitcher config");
            return;
        }
        block16: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ReplicationSwitcher.PropKey propKey;
            String key = ((String)entry.getKey()).trim();
            String value = ((String)entry.getValue()).trim();
            try {
                propKey = ReplicationSwitcher.PropKey.valueOf(key);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to parse ReplicationSwitcher's properties key:" + key), (Throwable)e);
                continue;
            }
            switch (propKey) {
                case level: {
                    StringBuilder sb1 = new StringBuilder("Old level [").append((Object)this.level);
                    sb1.append("] switching to new level [").append(value).append("] ");
                    try {
                        this.level = ReplicationSwitcher.Level.valueOf(value);
                        sb1.append("succeed.");
                    }
                    catch (Exception e) {
                        sb1.append("failed:").append(e.getMessage());
                    }
                    logger.warn((Object)sb1.toString());
                    break;
                }
                case insertSyncLogMode: {
                    StringBuilder sb = new StringBuilder("Old insertSyncLogMode [").append((Object)this.insertSyncLogMode);
                    sb.append("] switching to new insertSyncLogMode [").append(value).append("] ");
                    try {
                        this.insertSyncLogMode = ReplicationSwitcher.InsertSyncLogMode.valueOf(value);
                        sb.append("succeed.");
                    }
                    catch (Exception e) {
                        sb.append("failed:").append(e.getMessage());
                    }
                    logger.warn((Object)sb.toString());
                    break;
                }
                case replicationThreadPoolSize: {
                    if (this.replicationConfigAwares.isEmpty()) continue block16;
                    Integer poolsize = null;
                    try {
                        poolsize = Integer.valueOf(value);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to parse replicationThreadPoolSize:" + value), (Throwable)e);
                    }
                    if (poolsize == null) continue block16;
                    for (ReplicationSwitcher.ReplicationConfigAware aware : this.replicationConfigAwares) {
                        aware.setReplicationThreadPoolSize(poolsize);
                    }
                    continue block16;
                }
                case insertSyncLogThreadPoolSize: {
                    if (this.replicationConfigAwares.isEmpty()) continue block16;
                    Integer poolsize = null;
                    try {
                        poolsize = Integer.valueOf(value);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to parse insertSyncLogThreadPoolSize:" + value), (Throwable)e);
                    }
                    if (poolsize == null) continue block16;
                    for (ReplicationSwitcher.ReplicationConfigAware aware : this.replicationConfigAwares) {
                        aware.setInsertSyncLogThreadPoolSize(poolsize);
                    }
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("PropKey \u589e\u52a0\u4e86\u9009\u9879\u5374\u6ca1\u6709\u5728\u8fd9\u91cc\u66f4\u65b0");
                }
            }
        }
    }

    public void setLevel(String level) {
        this.level = ReplicationSwitcher.Level.valueOf(level);
    }

    public void setInsertSyncLogMode(String insertSyncLogMode) {
        this.insertSyncLogMode = ReplicationSwitcher.InsertSyncLogMode.valueOf(insertSyncLogMode);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public static void main(String[] args) {
        String str = "level=ALL_OFF";
        Properties p = new Properties();
        try {
            p.load((InputStream)new ByteArrayInputStream(str.getBytes()));
        }
        catch (IOException e) {
            logger.error((Object)("\u65e0\u6cd5\u89e3\u6790\u63a8\u9001\u7684\u914d\u7f6e\uff1a" + str), (Throwable)e);
            return;
        }
        System.out.println(p.get("level"));
        System.out.println((Object)ReplicationSwitcher.Level.valueOf("bbb"));
    }
}

