/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.replication;

import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.client.jdbc.listener.Adapter;
import com.taobao.tddl.client.jdbc.listener.Context;
import com.taobao.tddl.client.jdbc.listener.Handler;
import com.taobao.tddl.client.jdbc.listener.HookPoints;
import com.taobao.tddl.client.jdbc.replication.ReplicationCallbackHandler;
import com.taobao.tddl.client.jdbc.replication.ReplicationSwitcher;
import com.taobao.tddl.client.jdbc.replication.RowBasedReplicationListener;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ReplicationAdapter
implements Adapter {
    private final RowBasedReplicationListener rowBasedReplicationListener;

    public ReplicationAdapter(RowBasedReplicationListener rowBasedReplicationListener) {
        this.rowBasedReplicationListener = rowBasedReplicationListener;
    }

    @Override
    public void init(TDataSource tDataSource, HookPoints hookPoints) {
        this.rowBasedReplicationListener.setReplicationConfig(tDataSource.getReplicationConfig());
        this.rowBasedReplicationListener.init(tDataSource);
        hookPoints.appendBeforeExecuteFinally(new Handler(){

            @Override
            protected boolean run(Context context) throws SQLException {
                ReplicationAdapter.this.rowBasedReplicationListener.beforeSqlExecute(context);
                return true;
            }
        });
        hookPoints.appendAfterExecuteFinally(new Handler(){

            @Override
            protected boolean run(Context context) throws SQLException {
                ReplicationAdapter.this.rowBasedReplicationListener.afterSqlExecute(context);
                return true;
            }
        });
    }

    public void setMaxTxTime(long maxTxTime) {
        this.rowBasedReplicationListener.setMaxTxTime(maxTxTime);
    }

    public void setReplicationSwitcher(ReplicationSwitcher replicationSwitcher) {
        this.rowBasedReplicationListener.replicationSwitcher = replicationSwitcher;
    }

    public void setReplicationCallbackHandler(ReplicationCallbackHandler replicationCallbackHandler) {
        this.rowBasedReplicationListener.setReplicationCallbackHandler(replicationCallbackHandler);
    }

    public void setSyncLogDataSource(DataSource syncLogDataSource) {
        this.rowBasedReplicationListener.setSyncLogDataSource(syncLogDataSource);
    }

    public RowBasedReplicationListener getRowBasedReplicationListener() {
        return this.rowBasedReplicationListener;
    }
}

