/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.replication;

import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.client.jdbc.replication.ReplicationHelper;
import com.taobao.tddl.common.ConfigServerHelper;
import com.taobao.tddl.common.config.DefaultTddlConfigParser;
import com.taobao.tddl.common.config.TddlConfigParser;
import com.taobao.tddl.common.sync.BizTDDLContext;
import java.util.Map;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ReplicationConfig {
    private boolean isUseLocalConfig = false;
    private String appName;
    private Map<String, BizTDDLContext> logicTableName2TDDLContext;
    private String replicationConfigFile;
    private TddlConfigParser<Map<String, BizTDDLContext>> configParser = new DefaultTddlConfigParser();
    private final ConfigServerHelper.DataListener replicationListener = new ConfigServerHelper.DataListener(){

        public void onDataReceive(Object data) {
        }

        public void onDataReceiveAtRegister(Object data) {
            if (data != null) {
                ReplicationConfig.this.logicTableName2TDDLContext = (Map)ReplicationConfig.this.configParser.parseCongfig((String)data);
            }
        }
    };

    public void init(TDataSource tds) {
        if (!this.isUseLocalConfig) {
            this.logicTableName2TDDLContext = null;
            Object first = ConfigServerHelper.subscribeReplicationConfig((String)this.appName, (ConfigServerHelper.DataListener)this.replicationListener);
            if (first == null) {
                throw new IllegalStateException("\u6ca1\u6709\u63a5\u6536\u5230\u884c\u590d\u5236\u914d\u7f6e");
            }
            if (this.logicTableName2TDDLContext == null) {
                throw new IllegalStateException("\u89e3\u6790\u884c\u590d\u5236\u914d\u7f6e\u5931\u8d25\uff1a" + first);
            }
        } else if (this.replicationConfigFile != null) {
            FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(this.replicationConfigFile);
            this.logicTableName2TDDLContext = (Map)this.convert(ctx.getBean("root"));
        } else if (this.logicTableName2TDDLContext == null) {
            throw new IllegalArgumentException("logicTableName2TDDLContext\u5c5e\u6027\u6ca1\u6709\u914d\u7f6e");
        }
        ReplicationHelper.initReplicationContextByTDataSource(tds, this.logicTableName2TDDLContext);
    }

    private <T> T convert(Object obj) {
        return (T)obj;
    }

    public void setLogicTableName2TDDLContext(Map<String, BizTDDLContext> logicTableName2TDDLContext) {
        this.logicTableName2TDDLContext = logicTableName2TDDLContext;
    }

    public Map<String, BizTDDLContext> getLogicTableName2TDDLContext() {
        return this.logicTableName2TDDLContext;
    }

    public void setUseLocalConfig(boolean isUseLocalConfig) {
        this.isUseLocalConfig = isUseLocalConfig;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setReplicationConfigFile(String replicationConfigFile) {
        this.replicationConfigFile = replicationConfigFile;
    }
}

