/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.replication;

import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.common.sync.BizTDDLContext;
import com.taobao.tddl.common.sync.SlaveInfo;
import com.taobao.tddl.common.sync.SlaveReplicater;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class ReplicationHelper {
    public static void initReplicationContextByTDataSource(TDataSource tds, Map<String, BizTDDLContext> logicTableName2TDDLContext) {
        for (Map.Entry<String, BizTDDLContext> e : logicTableName2TDDLContext.entrySet()) {
            BizTDDLContext rplCtx = e.getValue();
            rplCtx.setMasterJdbcTemplate(new JdbcTemplate((DataSource)tds));
            for (SlaveInfo slaveInfo : rplCtx.getSlaveInfos()) {
                if (slaveInfo.getName() == null) {
                    slaveInfo.setName(e.getKey());
                }
                if (slaveInfo.getSlaveReplicater() != null) continue;
                if (slaveInfo.getSlaveReplicaterName() != null) {
                    slaveInfo.setSlaveReplicater((SlaveReplicater)tds.getSpringContext().getBean(slaveInfo.getSlaveReplicaterName()));
                    continue;
                }
                if (slaveInfo.getJdbcTemplate() != null) continue;
                if (slaveInfo.getDataSourceName() == null) {
                    throw new IllegalStateException("2.4.1\u4e4b\u540eSlaveInfo\u7684 DataSourceName\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e");
                }
                DataSource targetDS = tds.getReplicationTargetDataSources().get(slaveInfo.getDataSourceName());
                if (targetDS == null) {
                    targetDS = tds.getDataSource(slaveInfo.getDataSourceName());
                }
                if (targetDS == null) {
                    throw new IllegalArgumentException("[SlaveInfo.dataSourceName]Replication target DataSource could not found in TDataSource config:" + slaveInfo.getDataSourceName());
                }
                slaveInfo.setJdbcTemplate(new JdbcTemplate(targetDS));
            }
        }
    }
}

