/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.replication;

import com.taobao.tddl.client.jdbc.SqlExecuteEvent;
import com.taobao.tddl.client.jdbc.SqlExecuteListener;
import com.taobao.tddl.client.jdbc.TDataSource;
import com.taobao.tddl.client.jdbc.listener.Context;
import com.taobao.tddl.client.jdbc.replication.ConfigServerReplicationSwitcher;
import com.taobao.tddl.client.jdbc.replication.ReplicationCallbackHandler;
import com.taobao.tddl.client.jdbc.replication.ReplicationConfig;
import com.taobao.tddl.client.jdbc.replication.ReplicationSwitcher;
import com.taobao.tddl.client.jdbc.replication.SaveSyncLogFailedException;
import com.taobao.tddl.client.util.ExceptionUtils;
import com.taobao.tddl.client.util.UniqId;
import com.taobao.tddl.common.Monitor;
import com.taobao.tddl.common.sync.BizTDDLContext;
import com.taobao.tddl.common.sync.RowBasedReplicationContext;
import com.taobao.tddl.common.sync.RowBasedReplicationExecutor;
import com.taobao.tddl.common.sync.SyncUtils;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class RowBasedReplicationListener
implements SqlExecuteListener {
    private static final Log log = LogFactory.getLog(RowBasedReplicationListener.class);
    private static final Log localSyncLog = LogFactory.getLog((String)"TDDL_LOCAL_SYNC_LOG");
    private static final String syncLogSep = "\t";
    private static final long DEFAULT_MAX_TX_TIME = 300000L;
    private UniqId uniqId = UniqId.getInstance();
    private long maxTxTime = 300000L;
    protected ReplicationSwitcher replicationSwitcher;
    private ReplicationCallbackHandler replicationCallbackHandler = new SpecialExceptionPolicy();
    private ReplicationConfig replicationConfig;
    private DataSource syncLogDataSource;
    private boolean syncLogIsGroupDataSource = true;
    protected String appName;

    public void setSyncLogDataSource(DataSource syncLogDataSource) {
        this.syncLogDataSource = syncLogDataSource;
        this.syncLogIsGroupDataSource = syncLogDataSource instanceof TGroupDataSource;
        if (this.syncLogIsGroupDataSource) {
            ((TGroupDataSource)syncLogDataSource).setTracerWriteTarget(true);
        }
    }

    @Override
    public void init(TDataSource tds) {
        if (tds.getReplicationConfig() == null) {
            throw new IllegalArgumentException("\u7528\u65b0\u7684" + this.getClass().getName() + ",TDataSource\u5fc5\u987b\u914d\u7f6ereplicationConfig");
        }
        this.appName = tds.getAppName();
        this.replicationConfig = tds.getReplicationConfig();
        if (this.replicationSwitcher == null) {
            ConfigServerReplicationSwitcher csrs = new ConfigServerReplicationSwitcher();
            csrs.setAppName(this.appName);
            csrs.init();
            this.replicationSwitcher = csrs;
        } else if (this.replicationSwitcher instanceof ConfigServerReplicationSwitcher) {
            ConfigServerReplicationSwitcher csrs = (ConfigServerReplicationSwitcher)this.replicationSwitcher;
            if (csrs.getAppName() == null) {
                csrs.setAppName(this.appName);
            }
            csrs.init();
        }
    }

    public void init() {
    }

    public void destroy() {
    }

    @Override
    public void beforeSqlExecute(Context context) throws SQLException {
        if (this.replicationSwitcher != null && this.replicationSwitcher.level() == ReplicationSwitcher.Level.ALL_OFF) {
            return;
        }
        for (SqlExecuteEvent event : context.getEvents()) {
            this.beforeSqlExecute(event);
        }
    }

    private void beforeSqlExecute(SqlExecuteEvent event) throws SQLException {
        if (!event.isReplicated()) {
            return;
        }
        if (event.getSqlType() == SqlType.DELETE) {
            throw new IllegalArgumentException("\u5728\u884c\u590d\u5236\u6a21\u5f0f\u4e2d\u4e0d\u652f\u6301\u4f7f\u7528delete:" + event.getSql());
        }
        if (event.getSqlType() == SqlType.INSERT || event.getSqlType() == SqlType.UPDATE) {
            this.doBeforeSqlExecute(event);
        }
    }

    @Override
    public void afterSqlExecute(Context context) throws SQLException {
        if (context.getAffectedRows() == 0) {
            for (SqlExecuteEvent event : context.getEvents()) {
                RowBasedReplicationExecutor.deleteSyncLog((RowBasedReplicationContext)this.buildRowBasedReplicationContext(event));
            }
            return;
        }
        if (this.replicationSwitcher != null && (this.replicationSwitcher.level() == ReplicationSwitcher.Level.ALL_OFF || this.replicationSwitcher.level() == ReplicationSwitcher.Level.INSERT_LOG)) {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("current level :").append((Object)this.replicationSwitcher.level()).append(", return from after sql");
                log.debug((Object)sb.toString());
            }
            return;
        }
        for (SqlExecuteEvent event : context.getEvents()) {
            this.afterSqlExecute(event);
        }
    }

    private void afterSqlExecute(SqlExecuteEvent event) throws SQLException {
        if (!event.isReplicated()) {
            return;
        }
        if (event.getSqlType() == SqlType.INSERT || event.getSqlType() == SqlType.UPDATE) {
            this.doAfterSqlExecute(this.buildRowBasedReplicationContext(event));
        }
    }

    public RowBasedReplicationContext buildRowBasedReplicationContext(SqlExecuteEvent event) {
        RowBasedReplicationContext context = new RowBasedReplicationContext();
        context.setSqlType(event.getSqlType());
        context.setPrimaryKeyColumn(event.getPrimaryKeyColumn());
        context.setPrimaryKeyValue(event.getPrimaryKeyValue());
        context.setMasterLogicTableName(event.getLogicTableName());
        context.setMasterDatabaseShardColumn(event.getDatabaseShardColumn());
        context.setMasterDatabaseShardValue(event.getDatabaseShardValue());
        context.setMasterTableShardColumn(event.getTableShardColumn());
        context.setMasterTableShardValue(event.getTableShardValue());
        context.setSyncLogJdbcTemplate(event.getSyncLogJdbcTemplate());
        context.setSyncLogId(event.getSyncLogId());
        BizTDDLContext xmlElement = this.replicationConfig.getLogicTableName2TDDLContext().get(context.getMasterLogicTableName());
        context.setSlaveInfos(xmlElement.getSlaveInfos());
        context.setMasterColumns(xmlElement.getMasterColumns());
        context.setMasterJdbcTemplate(xmlElement.getMasterJdbcTemplate());
        context.setCreateTime(new Timestamp(System.currentTimeMillis()));
        context.setAfterMainDBSqlExecuteTime(event.getAfterMainDBSqlExecuteTime());
        context.setSql(event.getSql());
        return context;
    }

    protected abstract void doAfterSqlExecute(RowBasedReplicationContext var1);

    protected abstract void asyncInsertSyncLog2Db(SqlExecuteEvent var1);

    private void doBeforeSqlExecute(SqlExecuteEvent event) throws SQLException {
        if (this.replicationSwitcher == null || this.replicationSwitcher.insertSyncLogMode() == null) {
            this.insertSyncLog2Db(event);
            return;
        }
        switch (this.replicationSwitcher.insertSyncLogMode()) {
            case normal: {
                this.insertSyncLog2Db(event);
                break;
            }
            case logfileonly: {
                RowBasedReplicationListener.insertSyncLog2LocalFile(event);
                break;
            }
            case streaking: {
                break;
            }
            case asynchronous: {
                this.asyncInsertSyncLog2Db(event);
                break;
            }
            default: {
                throw new IllegalStateException("InsertSyncLogMode\u6709\u65b0\u589e\u9009\u9879");
            }
        }
    }

    protected void insertSyncLog2Db(SqlExecuteEvent event) throws SQLException {
        long time = System.currentTimeMillis();
        try {
            event.setSyncLogJdbcTemplate(new JdbcTemplate(this.syncLogDataSource));
            this.insertSyncLog(event);
            if (this.syncLogIsGroupDataSource) {
                DataSourceWrapper dsw = ((TGroupDataSource)this.syncLogDataSource).getCurrentTarget();
                event.setSyncLogDsKey(dsw.getDataSourceKey());
                event.setSyncLogJdbcTemplate(new JdbcTemplate(dsw.getWrappedDataSource()));
            }
        }
        catch (SQLException e) {
            Monitor.add((String)Monitor.buildTableKey1((String)event.getLogicTableName()), (String)Monitor.buildReplicationSqlKey2((String)event.getSql()), (String)"WRITE_LOG_EXCEPTION", (long)(System.currentTimeMillis() - time), (long)1L);
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
            exceptions.add(e);
            this.replicationCallbackHandler.insertSyncLogFailed(event, exceptions);
        }
        Monitor.add((String)Monitor.buildTableKey1((String)event.getLogicTableName()), (String)Monitor.buildReplicationSqlKey2((String)event.getSql()), (String)"WRITE_LOG_SUCCESS", (long)(System.currentTimeMillis() - time), (long)1L);
    }

    protected static void insertSyncLog2LocalFile(SqlExecuteEvent event) {
        RowBasedReplicationListener.insertSyncLog2LocalFile(localSyncLog, event);
    }

    protected static void insertSyncLog2LocalFile(Log logger, SqlExecuteEvent event) {
        logger.fatal((Object)(event.getSqlType().value() + syncLogSep + event.getLogicTableName() + syncLogSep + event.getPrimaryKeyColumn() + syncLogSep + event.getPrimaryKeyValue() + syncLogSep + event.getDatabaseShardColumn() + syncLogSep + event.getDatabaseShardValue() + syncLogSep + event.getTableShardColumn() + syncLogSep + event.getTableShardValue()));
    }

    private void insertSyncLog(SqlExecuteEvent event) throws SQLException {
        String syncLogId = this.uniqId.getUniqIDHashString();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into sync_log_").append(SyncUtils.getSyncLogTableSuffix((String)syncLogId));
        sql.append(" (id, sql_type, logic_table_name, primary_key_column, primary_key_value,");
        sql.append(" database_shard_column, database_shard_value, table_shard_column, table_shard_value,");
        sql.append(" hash_code, gmt_create, next_sync_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Object[] args = new Object[]{syncLogId, event.getSqlType().value(), event.getLogicTableName(), event.getPrimaryKeyColumn(), event.getPrimaryKeyValue(), event.getDatabaseShardColumn(), event.getDatabaseShardValue(), event.getTableShardColumn(), event.getTableShardValue(), RowBasedReplicationListener.getHashcode(event.getPrimaryKeyValue()), new Date(), new Date(System.currentTimeMillis() + this.maxTxTime)};
        if (log.isDebugEnabled()) {
            log.debug((Object)("insertSyncLog, sql = [" + sql.toString() + "], args = " + Arrays.asList(args)));
        }
        try {
            event.getSyncLogJdbcTemplate().update(sql.toString(), args);
            event.setSyncLogId(syncLogId);
        }
        catch (DataAccessException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    private static int getHashcode(Object pkValue) {
        if (pkValue == null) {
            log.warn((Object)"PrimaryKeyValue is null");
            return 0;
        }
        try {
            byte[] bytes = RowBasedReplicationListener.getMd5(pkValue.toString().getBytes());
            if (bytes.length < 2) {
                log.error((Object)"Invalid MD5 digest!");
                return 0;
            }
            return ((0xFF & bytes[0]) << 8) + (0xFF & bytes[1]);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"HashCode failed!", (Throwable)e);
            return 0;
        }
    }

    private static byte[] getMd5(byte[] src) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        return md.digest(src);
    }

    public void setMaxTxTime(long maxTxTime) {
        this.maxTxTime = maxTxTime;
    }

    public void setReplicationSwitcher(ReplicationSwitcher replicationSwitcher) {
        this.replicationSwitcher = replicationSwitcher;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public void setReplicationCallbackHandler(ReplicationCallbackHandler replicationCallbackHandler) {
        this.replicationCallbackHandler = replicationCallbackHandler;
    }

    public static class LocalLogPolicy
    implements ReplicationCallbackHandler {
        @Override
        public void insertSyncLogFailed(SqlExecuteEvent event, List<SQLException> exceptions) throws SQLException {
            log.warn((Object)"insert sync_log sql failed.", (Throwable)ExceptionUtils.mergeException(exceptions));
            RowBasedReplicationListener.insertSyncLog2LocalFile(event);
        }
    }

    public static class SpecialExceptionPolicy
    implements ReplicationCallbackHandler {
        @Override
        public void insertSyncLogFailed(SqlExecuteEvent event, List<SQLException> exceptions) throws SQLException {
            if (exceptions == null) {
                exceptions = new LinkedList<SQLException>();
            }
            exceptions.add(0, (SQLException)((Object)new SaveSyncLogFailedException("insert log exception,first exception is ", exceptions.size() > 0 ? exceptions.get(0) : null)));
            ExceptionUtils.throwSQLException(exceptions, "insert sync_log sql", Collections.<Object>emptyList());
        }
    }
}

