/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AddRealizer {
    private static Map<String, Add<Object>> adds = new HashMap<String, Add<Object>>();

    public static Add<Object> getNumberAdd(Object obj) {
        return adds.get(obj.getClass().getName());
    }

    public static void main(String[] args) {
        AddRealizer.getNumberAdd(new StringBuffer());
    }

    static {
        adds.put(Integer.class.getName(), new IntegerAdd());
        adds.put(Float.class.getName(), new FloatAdd());
        adds.put(Long.class.getName(), new LongAdd());
        adds.put(Double.class.getName(), new DoubleAdd());
        adds.put(BigDecimal.class.getName(), new BigDecimalAdd());
        adds.put(Short.class.getName(), new ShortAdd());
        adds.put(Byte.class.getName(), new ByteAdd());
    }

    private static class ByteAdd
    implements Add<Object> {
        private ByteAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return (Byte)left + (Byte)right;
        }
    }

    private static class ShortAdd
    implements Add<Object> {
        private ShortAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return (Short)left + (Short)right;
        }
    }

    private static class BigDecimalAdd
    implements Add<Object> {
        private BigDecimalAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return ((BigDecimal)left).add((BigDecimal)right);
        }
    }

    private static class DoubleAdd
    implements Add<Object> {
        private DoubleAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return (Double)left + (Double)right;
        }
    }

    private static class LongAdd
    implements Add<Object> {
        private LongAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return (Long)left + (Long)right;
        }
    }

    private static class FloatAdd
    implements Add<Object> {
        private FloatAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return Float.valueOf(((Float)left).floatValue() + ((Float)right).floatValue());
        }
    }

    private static class IntegerAdd
    implements Add<Object> {
        private IntegerAdd() {
        }

        @Override
        public Object add(Object left, Object right) {
            return (Integer)left + (Integer)right;
        }
    }

    public static interface Add<T> {
        public T add(T var1, T var2);
    }
}

