/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.helper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ComparatorRealizer {
    private static final String BOTH_NULL = "both_null";
    private static Map<String, Comparator<Object>> comparators = new HashMap<String, Comparator<Object>>();

    public static Comparator<Object> getObjectComparator(Class clazz) {
        return comparators.get(clazz.getName());
    }

    public static Comparator<Object> getBothNullComparator() {
        return comparators.get(BOTH_NULL);
    }

    static {
        comparators.put(Integer.class.getName(), new IntegerComparator());
        comparators.put(BigDecimal.class.getName(), new BigDecimalComparator());
        comparators.put(String.class.getName(), new StringComparator());
        comparators.put(Timestamp.class.getName(), new TimestampComparator());
        comparators.put(Short.class.getName(), new ShortComparator());
        comparators.put(Long.class.getName(), new LongComparator());
        comparators.put(Float.class.getName(), new FloatComparator());
        comparators.put(Double.class.getName(), new DoubleComparator());
        comparators.put(Byte.class.getName(), new ByteComparator());
        comparators.put(Boolean.class.getName(), new BooleanComparator());
        comparators.put(Date.class.getName(), new DateComparator());
        comparators.put(Time.class.getName(), new TimeComparator());
        comparators.put(BOTH_NULL, new BothNullComparator());
    }

    private static class TimeComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1690128776314769246L;

        private TimeComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                Time t1 = (Time)r1;
                Time t2 = (Time)r2;
                return t1.compareTo(t2);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class DateComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -1384424759889207483L;

        private DateComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                Date d1 = (Date)r1;
                Date d2 = (Date)r2;
                return d1.compareTo(d2);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class BooleanComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 2462499445166978825L;

        private BooleanComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                boolean b2;
                boolean b1 = (Boolean)r1;
                return b1 == (b2 = ((Boolean)r2).booleanValue()) ? 0 : (b1 ? 1 : -1);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class ByteComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -5517415727670106744L;

        private ByteComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                byte b2;
                byte b1 = (Byte)r1;
                return b1 == (b2 = ((Byte)r2).byteValue()) ? 0 : (b1 < b2 ? -1 : 1);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class DoubleComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1309653334825180274L;

        private DoubleComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                double d2;
                double d1 = (Double)r1;
                return d1 == (d2 = ((Double)r2).doubleValue()) ? 0 : (d1 < d2 ? -1 : 1);
            }
            if (r1 == null && r2 != null) {
                double d2 = (Double)r2;
                return 0.0 < d2 ? -1 : 1;
            }
            if (r1 != null && r2 == null) {
                double d1 = (Double)r1;
                return d1 < 0.0 ? -1 : 1;
            }
            return 0;
        }
    }

    private static class FloatComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -7381280113304667070L;

        private FloatComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                float f2;
                float f1 = ((Float)r1).floatValue();
                return f1 == (f2 = ((Float)r2).floatValue()) ? 0 : (f1 < f2 ? -1 : 1);
            }
            if (r1 == null && r2 != null) {
                float f2 = ((Float)r2).floatValue();
                return 0.0f < f2 ? -1 : 1;
            }
            if (r1 != null && r2 == null) {
                float f1 = ((Float)r1).floatValue();
                return f1 < 0.0f ? -1 : 1;
            }
            return 0;
        }
    }

    private static class LongComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 3715803260495696600L;

        private LongComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                long l2;
                long l1 = (Long)r1;
                return l1 == (l2 = ((Long)r2).longValue()) ? 0 : (l1 < l2 ? -1 : 1);
            }
            if (r1 == null && r2 != null) {
                long l2 = (Long)r2;
                return 0L < l2 ? -1 : 1;
            }
            if (r1 != null && r2 == null) {
                long l1 = (Long)r1;
                return l1 < 0L ? -1 : 1;
            }
            return 0;
        }
    }

    private static class ShortComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 4816347996381592373L;

        private ShortComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                short s2;
                short s1 = (Short)r1;
                return s1 == (s2 = ((Short)r2).shortValue()) ? 0 : (s1 < s2 ? -1 : 1);
            }
            if (r1 == null && r2 != null) {
                short s2 = (Short)r2;
                return 0 < s2 ? -1 : 1;
            }
            if (r1 != null && r2 == null) {
                short s1 = (Short)r1;
                return s1 < 0 ? -1 : 1;
            }
            return 0;
        }
    }

    private static class TimestampComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -1307150815524702537L;

        private TimestampComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                Timestamp t1 = (Timestamp)r1;
                Timestamp t2 = (Timestamp)r2;
                return t1.compareTo(t2);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class StringComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 2646282697658311223L;

        private StringComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                String s1 = (String)r1;
                String s2 = (String)r2;
                return s1.compareTo(s2);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class BigDecimalComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1935143297506831500L;

        private BigDecimalComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                BigDecimal b1 = (BigDecimal)r1;
                BigDecimal b2 = (BigDecimal)r2;
                return b1.compareTo(b2);
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            if (r1 != null && r2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class IntegerComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 5667463144686630897L;

        private IntegerComparator() {
        }

        @Override
        public int compare(Object r1, Object r2) {
            if (r1 != null && r2 != null) {
                int r;
                int l = (Integer)r1;
                return l == (r = ((Integer)r2).intValue()) ? 0 : (l < r ? -1 : 1);
            }
            if (r1 == null && r2 != null) {
                int r = (Integer)r2;
                return 0 < r ? -1 : 1;
            }
            if (r1 != null && r2 == null) {
                int l = (Integer)r1;
                return l < 0 ? -1 : 1;
            }
            return 0;
        }
    }

    public static class BothNullComparator
    implements Comparator<Object>,
    Serializable {
        @Override
        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

