/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.newImp.PlainAbstractTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTResultSet
extends PlainAbstractTResultSet {
    private static final Log log = LogFactory.getLog(BaseTResultSet.class);
    private int fetchSize;
    private int fetchDirection = 1000;
    protected int limitTo = -1;
    protected int limitFrom = 0;

    public BaseTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor);
    }

    public BaseTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor, boolean init) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor, init);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.actualResultSets.size() == 1) {
            return ((ResultSet)this.actualResultSets.get(0)).next();
        }
        if (this.limitTo == 0) {
            return false;
        }
        return this.internNext();
    }

    protected abstract boolean internNext() throws SQLException;

    public int getLimitTo() {
        return this.limitTo;
    }

    public void setLimitTo(int limitTo) {
        this.limitTo = limitTo;
    }

    public void setLimitFrom(int limitFrom) {
        this.limitFrom = limitFrom;
    }

    public int getLimitFrom() {
        return this.limitFrom;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke getFetchDirection");
        }
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke setFetchDirection");
        }
        this.checkClosed();
        if (direction != 1000) {
            throw new SQLException("only support fetch direction FETCH_FORWARD");
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke getFetchSize");
        }
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke setFetchSize");
        }
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException("fetch size must greater than or equal 0");
        }
        this.fetchSize = rows;
    }

    public static class CompareTypeUnsupported
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CompareTypeUnsupported(String message) {
            super(message);
        }
    }
}

