/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.helper.ComparatorRealizer;
import com.taobao.tddl.client.jdbc.resultset.newImp.BaseTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DistinctTResultSet
extends BaseTResultSet {
    private List<String> distinctColumns;
    private List<List<Object>> result;
    private int maxSize;
    private Map<String, Comparator<Object>> compMap;
    private int rsIndex;

    public DistinctTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor);
        this.result = new ArrayList<List<Object>>(this.maxSize);
        this.maxSize = 100000;
        this.compMap = null;
        this.rsIndex = 0;
    }

    public DistinctTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor, boolean init) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor, init);
        this.result = new ArrayList<List<Object>>(this.maxSize);
        this.maxSize = 100000;
        this.compMap = null;
        this.rsIndex = 0;
    }

    @Override
    protected boolean internNext() throws SQLException {
        ResultSet rs;
        this.currentResultSet = rs = (ResultSet)this.actualResultSets.get(this.rsIndex);
        if (rs.next()) {
            if (null == this.compMap) {
                this.compMap = new HashMap<String, Comparator<Object>>();
                for (String distinctColumn : this.distinctColumns) {
                    Object obj = rs.getObject(distinctColumn);
                    Class<?> sortType = obj.getClass();
                    this.compMap.put(distinctColumn, ComparatorRealizer.getObjectComparator(sortType));
                }
            }
            boolean inPreSearch = true;
            ArrayList<Object> record = new ArrayList<Object>(this.distinctColumns.size());
            for (int i = 0; i < this.distinctColumns.size(); ++i) {
                Object obj = rs.getObject(this.distinctColumns.get(i));
                if (!this.contains(i, this.distinctColumns.get(i), obj)) {
                    inPreSearch = false;
                }
                record.add(obj);
            }
            if (!inPreSearch) {
                if (this.result.size() >= this.maxSize) {
                    throw new SQLException("[DISTINCT]\u67e5\u8be2\u51fa\u7684\u6570\u636e\u6761\u6570\u591a\u4e8e\u9650\u5236\u503c" + this.maxSize + ",\u67e5\u8be2\u5931\u8d25!");
                }
                this.result.add(record);
                return true;
            }
            return this.internNext();
        }
        ++this.rsIndex;
        if (this.actualResultSets.size() < this.rsIndex + 1) {
            return false;
        }
        return this.internNext();
    }

    private boolean contains(int index, String distinctColumn, Object obj) {
        Comparator<Object> comp = this.compMap.get(distinctColumn);
        for (List<Object> re : this.result) {
            if (comp.compare(re.get(index), obj) != 0) continue;
            return true;
        }
        return false;
    }

    public void setDistinctColumn(List<String> distinctColumns) {
        this.distinctColumns = distinctColumns;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.result = new ArrayList<List<Object>>(this.maxSize);
    }
}

