/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.newImp.PlainAbstractTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Set;

public abstract class OnceNextTResultSet
extends PlainAbstractTResultSet {
    private int cursor;
    protected Object value;
    protected boolean isNull;

    public OnceNextTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor);
    }

    public OnceNextTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor, List<ResultSet> testResultSet, Set<Statement> testStatement) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor, false);
        this.actualResultSets = testResultSet;
        this.actualStatements = testStatement;
    }

    protected abstract ResultSet reducer() throws SQLException;

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.cursor > 0) {
            return false;
        }
        this.reducer();
        ++this.cursor;
        return true;
    }

    protected void checkCursor() throws SQLException {
        if (this.cursor != 1) {
            throw new SQLException("cursor should not be " + this.cursor);
        }
    }

    protected void checkIndex(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkCursor();
        if (columnIndex < 1) {
            throw new SQLException("Column Index out of range, " + columnIndex + " < 1");
        }
        if (columnIndex > 1) {
            throw new SQLException("Column Index out of range, " + columnIndex + " > 1");
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkCursor();
        if (!columnName.equals(this.getMetaData().getColumnName(1))) {
            throw new SQLException("Column '" + columnName + "' not found");
        }
        return 1;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((ResultSet)this.actualResultSets.get(0)).getMetaData();
    }

    @Override
    protected void checkRSIsClosedOrNull() throws SQLException {
        throw new UnsupportedOperationException("current resultset does not support current Operation!");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return (BigDecimal)this.value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).byteValueExact();
        }
        return Byte.parseByte(String.valueOf(this.value));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.value == null) {
            return 0.0;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).doubleValue();
        }
        return Double.parseDouble(String.valueOf(this.value));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.value == null) {
            return 0.0f;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).floatValue();
        }
        return Float.parseFloat(String.valueOf(this.value));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).intValueExact();
        }
        return Integer.parseInt(String.valueOf(this.value));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.value == null) {
            return 0L;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).longValueExact();
        }
        return Long.parseLong(String.valueOf(this.value));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.value;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).shortValueExact();
        }
        return Short.parseShort(String.valueOf(this.value));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.isNull;
    }
}

