/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.OrderByColumn;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.helper.ComparatorRealizer;
import com.taobao.tddl.client.jdbc.resultset.newImp.BaseTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class OrderByTResultSet
extends BaseTResultSet {
    private int needNext = -1;
    private boolean inited;
    private OrderByColumn[] orderByColumns;
    private int[] sortIndexes;
    private SortedSet<Integer> order;
    private Comparator<Integer> setComparator;
    private List<Comparator<Object>> sortFieldComparators;

    public OrderByTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor);
    }

    public OrderByTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor, boolean init) throws SQLException {
        super(tStatementImp, connectionManager, executionPlan, realSqlExecutor, init);
    }

    @Override
    protected boolean internNext() throws SQLException {
        if (!this.inited) {
            this.inited = true;
            this.reduce();
        }
        try {
            if (this.needNext != -1 && ((ResultSet)this.actualResultSets.get(this.needNext)).next()) {
                this.order.add(this.needNext);
            }
            if (this.order.isEmpty()) {
                return false;
            }
            Integer first = this.order.first();
            this.currentResultSet = (ResultSet)this.actualResultSets.get(first);
            this.order.remove(first);
            this.needNext = first;
            --this.limitTo;
        }
        catch (RuntimeException exp) {
            Throwable cause = exp.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            if (cause instanceof BaseTResultSet.CompareTypeUnsupported) {
                SQLException sqlException = new SQLException(cause.toString());
                sqlException.setStackTrace(cause.getStackTrace());
                throw sqlException;
            }
            throw exp;
        }
        return true;
    }

    protected ResultSet reduce() throws SQLException {
        if (this.actualResultSets.size() == 0) {
            throw new RuntimeException("This should not happen!!");
        }
        if (this.actualResultSets.size() == 1) {
            return (ResultSet)this.actualResultSets.get(0);
        }
        this.initSort();
        this.skipLimitFrom();
        return null;
    }

    protected void initSort() throws SQLException {
        int i;
        this.sortIndexes = new int[this.orderByColumns.length];
        for (i = 0; i < this.sortIndexes.length; ++i) {
            this.sortIndexes[i] = -1;
        }
        this.sortFieldComparators = new ArrayList<Comparator<Object>>(this.orderByColumns.length);
        for (i = 0; i < this.orderByColumns.length; ++i) {
            this.sortFieldComparators.add(null);
        }
        this.setComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer left, Integer right) {
                ResultSet resultSet1 = (ResultSet)OrderByTResultSet.this.actualResultSets.get(left);
                ResultSet resultSet2 = (ResultSet)OrderByTResultSet.this.actualResultSets.get(right);
                for (int indexOfOrderByColumn = 0; indexOfOrderByColumn < OrderByTResultSet.this.orderByColumns.length; ++indexOfOrderByColumn) {
                    int ret;
                    try {
                        if (OrderByTResultSet.this.sortIndexes[indexOfOrderByColumn] == -1) {
                            ((OrderByTResultSet)OrderByTResultSet.this).sortIndexes[indexOfOrderByColumn] = ((ResultSet)OrderByTResultSet.this.actualResultSets.get(0)).findColumn(OrderByTResultSet.this.orderByColumns[indexOfOrderByColumn].getColumnName());
                        }
                        int sortIndex = OrderByTResultSet.this.sortIndexes[indexOfOrderByColumn];
                        Comparator<Object> sortFieldComparator = (Comparator<Object>)OrderByTResultSet.this.sortFieldComparators.get(indexOfOrderByColumn);
                        if (sortFieldComparator == null || sortFieldComparator instanceof ComparatorRealizer.BothNullComparator) {
                            Object o1 = resultSet1.getObject(sortIndex);
                            if (null == o1) {
                                o1 = resultSet2.getObject(sortIndex);
                            }
                            if (null == o1) {
                                sortFieldComparator = ComparatorRealizer.getBothNullComparator();
                            } else {
                                Class<?> sortType = o1.getClass();
                                sortFieldComparator = ComparatorRealizer.getObjectComparator(sortType);
                            }
                            if (null == sortFieldComparator) {
                                throw new RuntimeException(new BaseTResultSet.CompareTypeUnsupported("unsupported compare type!"));
                            }
                            OrderByTResultSet.this.sortFieldComparators.set(indexOfOrderByColumn, sortFieldComparator);
                        }
                        ret = sortFieldComparator.compare(resultSet1.getObject(sortIndex), resultSet2.getObject(sortIndex));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    if (ret == 0 && resultSet1 != resultSet2) continue;
                    if (OrderByTResultSet.this.orderByColumns[indexOfOrderByColumn].isAsc()) {
                        return ret;
                    }
                    return -ret;
                }
                return System.identityHashCode(resultSet1) < System.identityHashCode(resultSet2) ? -1 : 1;
            }
        };
        try {
            this.order = new TreeSet<Integer>(this.setComparator);
            for (i = 0; i < this.actualResultSets.size(); ++i) {
                if (!((ResultSet)this.actualResultSets.get(i)).next()) continue;
                this.order.add(i);
            }
        }
        catch (RuntimeException exp) {
            Throwable cause = exp.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            if (cause instanceof BaseTResultSet.CompareTypeUnsupported) {
                SQLException sqlException = new SQLException(cause.toString());
                sqlException.setStackTrace(cause.getStackTrace());
                throw sqlException;
            }
            throw exp;
        }
    }

    protected void skipLimitFrom() throws SQLException {
        for (int i = 0; i < this.limitFrom; ++i) {
            this.next();
        }
    }

    public void setOrderByColumns(OrderByColumn[] orderByColumns) {
        this.orderByColumns = orderByColumns;
    }
}

