/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.newImp.ProxyTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import com.taobao.tddl.client.util.ExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlainAbstractTResultSet
extends ProxyTResultSet {
    private long startQueryTime = 0L;
    protected boolean enableProfileRealDBAndTables;
    protected final ExecutionPlan executionPlan;
    protected List<ResultSet> actualResultSets;
    protected Set<Statement> actualStatements;
    protected final TStatementImp tStatementImp;
    protected final RealSqlExecutor realSqlExecutor;
    private static final Log log = LogFactory.getLog(PlainAbstractTResultSet.class);

    public PlainAbstractTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor) throws SQLException {
        this(tStatementImp, connectionManager, executionPlan, realSqlExecutor, true);
        super.setResultSetProperty(tStatementImp);
    }

    public PlainAbstractTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor, boolean init) throws SQLException {
        super(connectionManager);
        this.tStatementImp = tStatementImp;
        this.realSqlExecutor = realSqlExecutor;
        this.executionPlan = executionPlan;
        if (init) {
            this.init(connectionManager, executionPlan);
        }
    }

    protected void init(ConnectionManager connectionManager, ExecutionPlan context) throws SQLException {
        this.startQueryTime = System.currentTimeMillis();
        this.checkClosed();
        Map<String, List<RealSqlContext>> sqlMap = context.getSqlMap();
        int tableSize = 0;
        for (List<RealSqlContext> l : sqlMap.values()) {
            tableSize += l.size();
        }
        List<SQLException> exceptions = new LinkedList<SQLException>();
        this.actualResultSets = new ArrayList<ResultSet>(tableSize);
        this.actualStatements = new HashSet<Statement>(tableSize);
        boolean needBreak = false;
        block3: for (Map.Entry<String, List<RealSqlContext>> dbEntry : sqlMap.entrySet()) {
            if (needBreak) break;
            List<RealSqlContext> sqlList = dbEntry.getValue();
            for (int i = 0; i < sqlList.size(); ++i) {
                QueryReturn qr = null;
                try {
                    qr = this.realSqlExecutor.query();
                }
                catch (SQLException e) {
                    exceptions.add(e);
                    continue block3;
                }
                if (qr != null) {
                    if (null == qr.getExceptions()) {
                        this.actualResultSets.add(qr.getResultset());
                        this.actualStatements.add(qr.getStatement());
                        continue;
                    }
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, qr.getExceptions());
                    continue;
                }
                needBreak = true;
                continue block3;
            }
        }
        int databaseSize = sqlMap.size();
        this.profileNumberOfDBAndTablesOnly(context.getVirtualTableName().toString(), databaseSize, tableSize, context.getOriginalSql());
        ExceptionUtils.throwSQLException(exceptions, context.getOriginalSql(), context.getOriginalArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInternal() throws SQLException {
        List<SQLException> exceptions = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke close");
        }
        if (this.closed) {
            return;
        }
        this.realSqlExecutor.clearQueryResource();
        long elapsedTime = System.currentTimeMillis() - this.startQueryTime;
        this.profileDuringTime(exceptions, this.executionPlan.getVirtualTableName().toString(), this.executionPlan.getOriginalSql(), elapsedTime);
        try {
            for (ResultSet rs : this.actualResultSets) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
                }
            }
            for (Statement stmt : this.actualStatements) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
                }
            }
        }
        finally {
            this.closed = true;
            this.actualStatements.clear();
            this.actualResultSets.clear();
        }
        for (String key : this.executionPlan.getSqlMap().keySet()) {
            exceptions = this.tryCloseConnection(exceptions, key);
        }
        ExceptionUtils.throwSQLException(exceptions, "sql exception during close resources", (List<Object>)Collections.EMPTY_LIST);
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("No operations allowed after resultset closed.");
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.tStatementImp;
    }

    public List<ResultSet> getActualResultSets() {
        return this.actualResultSets;
    }

    public void setActualResultSets(List<ResultSet> actualResultSets) {
        this.actualResultSets = actualResultSets;
    }
}

