/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TPreparedStatementImp;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.newImp.ProxyTResultSet;
import com.taobao.tddl.client.util.ExceptionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ShallowTResultSetWrapper
extends ProxyTResultSet
implements ResultSet {
    private long startQueryTime = System.currentTimeMillis();
    private final boolean isPreparedStatement;
    private Statement statement;
    private ResultSet resultSet;
    private TStatementImp tStatementImp;
    private ExecutionPlan executionPlan;

    public ShallowTResultSetWrapper(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan) throws SQLException {
        super(connectionManager);
        Map<String, List<RealSqlContext>> sqlMap = executionPlan.getSqlMap();
        this.isPreparedStatement = tStatementImp instanceof TPreparedStatementImp;
        this.tStatementImp = tStatementImp;
        this.executionPlan = executionPlan;
        super.setResultSetProperty(tStatementImp);
        boolean firstElement = true;
        for (Map.Entry<String, List<RealSqlContext>> dbEntry : sqlMap.entrySet()) {
            String dbSelectorId = dbEntry.getKey();
            Connection connection = connectionManager.getConnection(dbSelectorId, executionPlan.isGoSlave());
            List<RealSqlContext> sqlList = dbEntry.getValue();
            for (RealSqlContext sql : sqlList) {
                long start = System.currentTimeMillis();
                if (!this.isPreparedStatement) {
                    this.executeQueryIntervalST(connection, sql, tStatementImp);
                } else {
                    this.executeQueryIntervalPST(connection, sql, tStatementImp);
                }
                long during = System.currentTimeMillis() - start;
                this.profileRealDatabaseAndTables(dbSelectorId, sql, during);
                if (firstElement) {
                    firstElement = false;
                    continue;
                }
                throw new SQLException("only one table execution was allowed on ShallowTRS! ");
            }
        }
    }

    private void executeQueryIntervalST(Connection connection, RealSqlContext sql, TStatementImp statementImp) throws SQLException {
        this.statement = this.createStatementInternal(connection);
        this.statement.setQueryTimeout(this.getQueryTimeout());
        this.statement.setFetchSize(this.getFetchSize());
        this.statement.setMaxRows(this.getMaxRows());
        this.currentResultSet = this.resultSet = this.statement.executeQuery(sql.getSql());
    }

    private void executeQueryIntervalPST(Connection connection, RealSqlContext sql, TStatementImp statementImp) throws SQLException {
        PreparedStatement stmt = this.prepareStatementInternal(connection, sql.getSql());
        stmt.setQueryTimeout(this.getQueryTimeout());
        stmt.setFetchSize(this.getFetchSize());
        stmt.setMaxRows(this.getMaxRows());
        this.setParameters(stmt, sql.getArgument());
        this.statement = stmt;
        this.currentResultSet = this.resultSet = stmt.executeQuery();
    }

    public void checkSize(Map<String, List<RealSqlContext>> sqlMap) throws SQLException {
        if (sqlMap.size() != 1) {
            throw new SQLException("should not be here , ONLY ONE ds allowed!");
        }
    }

    public void checkRSIsNull() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("exception on execution query,result set is already closed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInternal() throws SQLException {
        this.checkRSIsNull();
        List<SQLException> exceptions = null;
        if (this.closed) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - this.startQueryTime;
        this.profileDuringTime(exceptions, this.executionPlan.getVirtualTableName().toString(), this.executionPlan.getOriginalSql(), elapsedTime);
        try {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
        }
        finally {
            this.closed = true;
        }
        for (String key : this.executionPlan.getSqlMap().keySet()) {
            exceptions = this.tryCloseConnection(exceptions, key);
        }
        ExceptionUtils.throwSQLException(exceptions, "sql exception during close resources", Collections.<Object>emptyList());
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkRSIsNull();
        return this.tStatementImp;
    }
}

