/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.resultset.newImp;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.resultset.newImp.ProxyTResultSet;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import com.taobao.tddl.client.util.ExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTResultSet
extends ProxyTResultSet {
    private static final Log log = LogFactory.getLog(SimpleTResultSet.class);
    protected Statement statement;
    protected ResultSet resultSet;
    protected String currentDBIndex = null;
    protected int fetchSize = -1;
    protected int tableIndex = 0;
    protected final TStatementImp tStatementImp;
    protected final ExecutionPlan executionPlan;
    protected final RealSqlExecutor realSqlExecutor;
    protected boolean inited = false;
    protected int limitTo = -1;
    protected int limitFrom = 0;
    private final long startQueryTime;
    private boolean hasMoreResourcesOnInit = false;

    public SimpleTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor) throws SQLException {
        this(tStatementImp, connectionManager, executionPlan, realSqlExecutor, true);
    }

    public SimpleTResultSet(TStatementImp tStatementImp, ConnectionManager connectionManager, ExecutionPlan executionPlan, RealSqlExecutor realSqlExecutor, boolean init) throws SQLException {
        super(connectionManager);
        this.tStatementImp = tStatementImp;
        super.setResultSetProperty(tStatementImp);
        this.executionPlan = executionPlan;
        this.realSqlExecutor = realSqlExecutor;
        this.startQueryTime = System.currentTimeMillis();
        if (init) {
            this.hasMoreResourcesOnInit = this.superReload();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.limitTo == 0) {
            return false;
        }
        if (!this.inited) {
            this.inited = true;
            if (!this.hasMoreResourcesOnInit) {
                throw new SQLException("\u7ed3\u679c\u96c6\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u6709\u7a7a\u5e93\u7a7a\u8868\u6216query\u5f02\u5e38\u5bfc\u81f4\uff0c\u4e0d\u5e94\u8be5\u8d70\u5230\u8fd9\u91cc");
            }
            Map<String, List<RealSqlContext>> map = this.executionPlan.getSqlMap();
            if (map.size() == 0) {
                throw new SQLException("should not be here");
            }
            int tableSize = map.values().iterator().next().size();
            if (tableSize != 1 || map.size() != 1) {
                for (int i = 0; i < this.limitFrom; ++i) {
                    if (this.next()) continue;
                    return false;
                }
            }
        }
        do {
            if (this.resultSet == null) {
                return false;
            }
            if (!this.resultSet.next()) continue;
            --this.limitTo;
            return true;
        } while (this.superReload());
        return false;
    }

    protected boolean superReload() throws SQLException {
        List<SQLException> sqlExceptions = new LinkedList<SQLException>();
        this.closeAndClearResources(sqlExceptions);
        QueryReturn qr = this.realSqlExecutor.query();
        if (null == qr) {
            return false;
        }
        if (null == qr.getExceptions()) {
            this.statement = qr.getStatement();
            this.resultSet = qr.getResultset();
            this.currentDBIndex = qr.getCurrentDBIndex();
            this.currentResultSet = this.resultSet;
            return true;
        }
        sqlExceptions = ExceptionUtils.appendToExceptionList(sqlExceptions, qr.getExceptions());
        this.writeLogOrThrowSQLException("TDDL print sqlException while retry :", sqlExceptions);
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        log.debug((Object)"invoke getFetchDirection");
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        log.debug((Object)"invoke setFetchDirection");
        this.checkClosed();
        if (direction != 1000) {
            throw new SQLException("only support fetch direction FETCH_FORWARD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SQLException> closeAndClearResources(List<SQLException> exceptions) {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
            finally {
                this.statement = null;
            }
        }
        return exceptions;
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("No operations allowed after result set closed.");
        }
    }

    protected void checkPoint() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("\u7ed3\u679c\u96c6\u4e3a\u7a7a\u6216\u5df2\u7ecf\u53d6\u5c3d");
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke setFetchSize");
        }
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException("fetch size must greater than or equal 0");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke getFetchSize");
        }
        this.checkClosed();
        return this.fetchSize;
    }

    public int getLimitTo() {
        return this.limitTo;
    }

    public void setLimitTo(int limitTo) {
        this.limitTo = limitTo;
    }

    public int getLimitFrom() {
        return this.limitFrom;
    }

    public void setLimitFrom(int limitFrom) {
        this.limitFrom = limitFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInternal() throws SQLException {
        List<SQLException> exceptions = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke close");
        }
        if (this.closed) {
            return;
        }
        this.realSqlExecutor.clearQueryResource();
        this.closed = true;
        long elapsedTime = System.currentTimeMillis() - this.startQueryTime;
        this.profileDuringTime(exceptions, this.executionPlan.getVirtualTableName().toString(), this.executionPlan.getOriginalSql(), elapsedTime);
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
        }
        finally {
            this.resultSet = null;
        }
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
        }
        finally {
            this.statement = null;
        }
        if (this.currentDBIndex != null) {
            exceptions = this.tryCloseConnection(exceptions, this.currentDBIndex);
        }
        for (String key : this.executionPlan.getSqlMap().keySet()) {
            exceptions = this.tryCloseConnection(exceptions, key);
        }
        this.writeLogOrThrowSQLException("sql exception during close resources", exceptions);
    }

    private void writeLogOrThrowSQLException(String message, List<SQLException> sqlExceptions) throws SQLException {
        ExceptionUtils.throwSQLException(sqlExceptions, this.executionPlan.getOriginalSql(), this.executionPlan.getOriginalArgs());
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.tStatementImp;
    }
}

