/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.PreparedStatementExecutorCommon;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TPreparedStatementImp;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.UpdateReturn;
import com.taobao.tddl.client.util.ExceptionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RealSqlExecutorCommon
extends PreparedStatementExecutorCommon {
    private static final Log logger = LogFactory.getLog(RealSqlExecutorCommon.class);
    private int resultSetType = -1;
    private int resultSetConcurrency = -1;
    private int resultSetHoldability = -1;
    private int queryTimeout;
    private int fetchSize;
    private int maxRows;
    private int autoGeneratedKeys = -1;
    private int[] columnIndexes;
    private String[] columnNames;

    public RealSqlExecutorCommon(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    protected void checkThreadState() throws SQLException {
        if (Thread.currentThread().isInterrupted()) {
            throw new SQLException("current thread is interrupted!");
        }
    }

    protected boolean isPreparedStatement(TStatementImp tStatement) {
        return tStatement instanceof TPreparedStatementImp;
    }

    protected QueryReturn executeQueryIntervalST(Connection connection, RealSqlContext sql) throws SQLException {
        QueryReturn qr = new QueryReturn();
        Statement stmt = this.createStatementInternal(connection);
        stmt.setQueryTimeout(this.queryTimeout);
        stmt.setFetchSize(this.fetchSize);
        stmt.setMaxRows(this.maxRows);
        ResultSet resultset = stmt.executeQuery(sql.getSql());
        qr.setResultset(resultset);
        qr.setStatement(stmt);
        return qr;
    }

    protected QueryReturn executeQueryIntervalPST(Connection connection, RealSqlContext sql) throws SQLException {
        QueryReturn qr = new QueryReturn();
        PreparedStatement stmt = this.prepareStatementInternal(connection, sql.getSql());
        stmt.setQueryTimeout(this.queryTimeout);
        stmt.setFetchSize(this.fetchSize);
        stmt.setMaxRows(this.maxRows);
        this.setParameters(stmt, sql.getArgument());
        ResultSet resultset = stmt.executeQuery();
        qr.setResultset(resultset);
        qr.setStatement(stmt);
        return qr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateReturn executeUpdateIntervalST(ExecutionPlan executionPlan, Map.Entry<String, List<RealSqlContext>> dbEntry) {
        String dbSelectorId = dbEntry.getKey();
        long start = 0L;
        RealSqlContext targetSqloutput = null;
        int affectedRows = 0;
        List<SQLException> exceptions = new LinkedList<SQLException>();
        try {
            this.checkThreadState();
            Connection conn = this.connectionManager.getConnection(dbSelectorId, executionPlan.isGoSlave());
            Statement stmt = this.createStatementInternal(conn);
            try {
                stmt.setQueryTimeout(this.queryTimeout);
                stmt.setFetchSize(this.fetchSize);
                stmt.setMaxRows(this.maxRows);
                for (RealSqlContext targetSql : dbEntry.getValue()) {
                    this.checkThreadState();
                    start = System.currentTimeMillis();
                    targetSqloutput = targetSql;
                    affectedRows = this.executeUpdateAtRealConnection(affectedRows, targetSql, stmt);
                    long during = System.currentTimeMillis() - start;
                    this.profileRealDatabaseAndTables(dbSelectorId, targetSql, during);
                }
            }
            catch (SQLException e) {
                long during = System.currentTimeMillis() - start;
                this.profileRealDatabaseAndTablesWithException(dbSelectorId, targetSqloutput, during);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
        }
        finally {
            exceptions = this.tryCloseConnection(exceptions, dbSelectorId);
        }
        UpdateReturn ur = new UpdateReturn();
        ur.setAffectedRows(affectedRows);
        ur.setExceptions(exceptions);
        return ur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateReturn executeUpdateIntervalPST(ExecutionPlan executionPlan, Map.Entry<String, List<RealSqlContext>> dbEntry) {
        int affectedRows = 0;
        List<SQLException> exceptions = new LinkedList<SQLException>();
        String dbSelectorId = dbEntry.getKey();
        try {
            this.checkThreadState();
            Connection conn = this.connectionManager.getConnection(dbSelectorId, executionPlan.isGoSlave());
            List<RealSqlContext> realSqlContexts = dbEntry.getValue();
            for (RealSqlContext sqlContext : realSqlContexts) {
                this.checkThreadState();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("real execute sql:" + sqlContext.getSql()));
                    logger.debug((Object)("sql args:" + sqlContext.getArgument()));
                }
                long oneTableStart = System.currentTimeMillis();
                PreparedStatement ps = this.prepareStatementInternal(conn, sqlContext.getSql());
                try {
                    ps.setQueryTimeout(this.queryTimeout);
                    ps.setFetchSize(this.fetchSize);
                    ps.setMaxRows(this.maxRows);
                    this.setParameters(ps, sqlContext.getArgument());
                    affectedRows += ps.executeUpdate();
                    long during = System.currentTimeMillis() - oneTableStart;
                    this.profileRealDatabaseAndTables(dbSelectorId, sqlContext, during);
                }
                catch (SQLException e) {
                    long during = System.currentTimeMillis() - oneTableStart;
                    this.profileRealDatabaseAndTablesWithException(dbSelectorId, sqlContext, during);
                    throw e;
                }
                finally {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
        }
        finally {
            exceptions = this.tryCloseConnection(exceptions, dbSelectorId);
        }
        UpdateReturn ur = new UpdateReturn();
        ur.setAffectedRows(affectedRows);
        ur.setExceptions(exceptions);
        return ur;
    }

    protected Statement createStatementInternal(Connection connection) throws SQLException {
        Statement stmt = this.resultSetType != -1 && this.resultSetConcurrency != -1 && this.resultSetHoldability != -1 ? connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability) : (this.resultSetType != -1 && this.resultSetConcurrency != -1 ? connection.createStatement(this.resultSetType, this.resultSetConcurrency) : connection.createStatement());
        return stmt;
    }

    protected PreparedStatement prepareStatementInternal(Connection connection, String targetSql) throws SQLException {
        PreparedStatement ps = this.resultSetType != -1 && this.resultSetConcurrency != -1 && this.resultSetHoldability != -1 ? connection.prepareStatement(targetSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability) : (this.resultSetType != -1 && this.resultSetConcurrency != -1 ? connection.prepareStatement(targetSql, this.resultSetType, this.resultSetConcurrency) : (this.autoGeneratedKeys != -1 ? connection.prepareStatement(targetSql, this.autoGeneratedKeys) : (this.columnIndexes != null ? connection.prepareStatement(targetSql, this.columnIndexes) : (this.columnNames != null ? connection.prepareStatement(targetSql, this.columnNames) : connection.prepareStatement(targetSql)))));
        return ps;
    }

    protected int executeUpdateAtRealConnection(int affectedRows, RealSqlContext targetSql, Statement stmt) throws SQLException {
        affectedRows = this.autoGeneratedKeys == -1 && this.columnIndexes == null && this.columnNames == null ? (affectedRows += stmt.executeUpdate(targetSql.getSql())) : (this.autoGeneratedKeys != -1 ? (affectedRows += stmt.executeUpdate(targetSql.getSql(), this.autoGeneratedKeys)) : (this.columnIndexes != null ? (affectedRows += stmt.executeUpdate(targetSql.getSql(), this.columnIndexes)) : (this.columnNames != null ? (affectedRows += stmt.executeUpdate(targetSql.getSql(), this.columnNames)) : (affectedRows += stmt.executeUpdate(targetSql.getSql())))));
        return affectedRows;
    }

    protected void setSpecialProperty(TStatementImp tStatementImp, ExecutionPlan executionPlan) {
        try {
            this.resultSetConcurrency = tStatementImp.getResultSetConcurrency();
            this.resultSetHoldability = tStatementImp.getResultSetHoldability();
            this.resultSetType = tStatementImp.getResultSetType();
            this.queryTimeout = tStatementImp.getQueryTimeout();
            this.fetchSize = tStatementImp.getFetchSize();
            this.maxRows = tStatementImp.getMaxRows();
        }
        catch (SQLException e) {
            logger.error((Object)"set resultSetType,queryTimeOut,...property error!", (Throwable)e);
        }
        this.autoGeneratedKeys = executionPlan.getAutoGeneratedKeys();
        this.columnIndexes = executionPlan.getColumnIndexes();
        this.columnNames = executionPlan.getColumnNames();
    }
}

