/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor;

import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutor;
import com.taobao.tddl.client.jdbc.sqlexecutor.UpdateReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelDiamondConfigManager;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelRealSqlExecutor;
import com.taobao.tddl.client.jdbc.sqlexecutor.serial.SerialRealSqlExecutor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RealSqlExecutorImp
implements RealSqlExecutor {
    private static final Log logger = LogFactory.getLog(RealSqlExecutorImp.class);
    protected final ParallelRealSqlExecutor parallelExecutor;
    protected final SerialRealSqlExecutor serialExecutor;
    protected final TStatementImp tStatementImp;
    protected final ExecutionPlan executionPlan;
    protected ConcurrentLinkedQueue<UpdateReturn> updateReturnQueue = null;
    protected ConcurrentLinkedQueue<QueryReturn> queryReturnQueue = null;

    public RealSqlExecutorImp(ParallelRealSqlExecutor parallelExecutor, SerialRealSqlExecutor serialExecutor, TStatementImp tStatementImp, ExecutionPlan executionPlan) {
        this.parallelExecutor = parallelExecutor;
        this.serialExecutor = serialExecutor;
        this.tStatementImp = tStatementImp;
        this.executionPlan = executionPlan;
    }

    @Override
    public QueryReturn query() throws SQLException {
        if (null == this.queryReturnQueue) {
            this.queryReturnQueue = new ConcurrentLinkedQueue();
            boolean useParallel = this.useParallel();
            if (useParallel && null != this.parallelExecutor) {
                int dbSize = this.getDbSize(this.executionPlan);
                CountDownLatch cdl = new CountDownLatch(dbSize);
                ArrayList<Future> futures = new ArrayList<Future>(dbSize);
                try {
                    this.parallelExecutor.parallelQuery(this.queryReturnQueue, this.executionPlan, this.tStatementImp, cdl, futures);
                    cdl.await();
                }
                catch (RejectedExecutionException e1) {
                    logger.error((Object)"some task rejected,this query failed!", (Throwable)e1);
                    this.parallelQueryExceptionHandle(futures);
                    throw new SQLException("[RealSqlExecutorImp exception caught]some task rejected,this query failed!");
                }
                catch (InterruptedException e) {
                    logger.error((Object)"parrallel query error!", (Throwable)e);
                    this.parallelQueryExceptionHandle(futures);
                    throw new SQLException("[RealSqlExecutorImp exception caught]parrallel query error!");
                }
                catch (Exception e) {
                    logger.error((Object)"some error happen!", (Throwable)e);
                    this.parallelQueryExceptionHandle(futures);
                    throw new SQLException("[RealSqlExecutorImp exception caught]unknow error happen!");
                }
            }
            if (!useParallel && null != this.serialExecutor) {
                this.serialExecutor.serialQuery(this.queryReturnQueue, this.executionPlan, this.tStatementImp);
            }
        }
        if (null != this.queryReturnQueue && !this.queryReturnQueue.isEmpty()) {
            QueryReturn qr = this.queryReturnQueue.poll();
            return qr;
        }
        return null;
    }

    @Override
    public UpdateReturn update() throws SQLException {
        if (null == this.updateReturnQueue) {
            boolean useParallel = this.useParallel();
            this.updateReturnQueue = new ConcurrentLinkedQueue();
            if (useParallel && null != this.parallelExecutor) {
                int dbSize = this.getDbSize(this.executionPlan);
                CountDownLatch cdl = new CountDownLatch(dbSize);
                ArrayList<Future> futures = new ArrayList<Future>(dbSize);
                try {
                    this.parallelExecutor.parallelUpdate(this.updateReturnQueue, this.executionPlan, this.tStatementImp, cdl, futures);
                    cdl.await();
                }
                catch (RejectedExecutionException e1) {
                    logger.error((Object)"some task rejected,this query failed!", (Throwable)e1);
                    this.parallelUpdateExceptionHandle(futures);
                    throw new SQLException("[RealSqlExecutorImp exception caught]some task rejected,this update failed!");
                }
                catch (InterruptedException e) {
                    logger.error((Object)"parrallel update error!", (Throwable)e);
                    this.parallelUpdateExceptionHandle(futures);
                    throw new SQLException("[RealSqlExecutorImp exception caught]parrallel update error!");
                }
                catch (Exception e) {
                    logger.error((Object)"main thread some error happen!", (Throwable)e);
                    this.parallelUpdateExceptionHandle(futures);
                    throw new SQLException("[RealSqlExecutorImp exception caught]unknow error happen!");
                }
            }
            if (!useParallel && null != this.serialExecutor) {
                this.serialExecutor.serialUpdate(this.updateReturnQueue, this.executionPlan, this.tStatementImp);
            }
        }
        if (null != this.updateReturnQueue && !this.updateReturnQueue.isEmpty()) {
            UpdateReturn ur = this.updateReturnQueue.poll();
            return ur;
        }
        return null;
    }

    protected boolean useParallel() {
        if (!ParallelDiamondConfigManager.isUseParallel()) {
            return false;
        }
        return this.executionPlan.isUseParallel();
    }

    private int getDbSize(ExecutionPlan executionPlan) {
        Map<String, List<RealSqlContext>> sqlMap = executionPlan.getSqlMap();
        return sqlMap.size();
    }

    @Override
    public void clearQueryResource() {
        if (null != this.queryReturnQueue && !this.queryReturnQueue.isEmpty()) {
            QueryReturn qr = null;
            while (null != (qr = this.queryReturnQueue.poll())) {
                if (qr.getResultset() != null) {
                    try {
                        qr.getResultset().close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"resultset close error!", (Throwable)e);
                    }
                }
                if (qr.getStatement() != null) {
                    try {
                        qr.getStatement().close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"statement close error!", (Throwable)e);
                    }
                }
                if (qr.getCurrentDBIndex() == null) continue;
                this.parallelExecutor.tryCloseConnection(qr.getCurrentDBIndex());
            }
        }
    }

    private void parallelQueryExceptionHandle(List<Future> futures) throws SQLException {
        logger.warn((Object)"start to cancel all future!");
        for (Future future : futures) {
            if (null == future) continue;
            future.cancel(true);
        }
        logger.warn((Object)"start to collect query resources!");
        this.clearQueryResource();
    }

    private void parallelUpdateExceptionHandle(List<Future> futures) throws SQLException {
        logger.warn((Object)"start to cancel all future!");
        for (Future future : futures) {
            if (null == future) continue;
            future.cancel(true);
        }
    }
}

