/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor;

import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutorImp;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelRealSqlExecutor;
import com.taobao.tddl.client.jdbc.sqlexecutor.serial.SerialRealSqlExecutor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleRealSqlExecutorImp
extends RealSqlExecutorImp {
    private boolean alwaysUseParallel = false;
    private String needCloseConection = null;
    Map<String, Integer> conWithStatements = null;

    public SimpleRealSqlExecutorImp(ParallelRealSqlExecutor parallelExecutor, SerialRealSqlExecutor serialExecutor, TStatementImp tStatementImp, ExecutionPlan executionPlan) {
        super(parallelExecutor, serialExecutor, tStatementImp, executionPlan);
    }

    @Override
    public QueryReturn query() throws SQLException {
        if (null == this.queryReturnQueue && this.useParallel()) {
            this.alwaysUseParallel = true;
            QueryReturn qr = super.query();
            this.queryConnectionManage(qr);
            return qr;
        }
        if (this.alwaysUseParallel) {
            QueryReturn qr = super.query();
            this.queryConnectionManage(qr);
            return qr;
        }
        if (null == this.queryReturnQueue) {
            this.queryReturnQueue = new ConcurrentLinkedQueue();
        }
        this.serialExecutor.serialQuery(this.queryReturnQueue, this.executionPlan, this.tStatementImp);
        if (this.queryReturnQueue != null && !this.queryReturnQueue.isEmpty()) {
            return (QueryReturn)this.queryReturnQueue.poll();
        }
        return null;
    }

    private void queryConnectionManage(QueryReturn qr) {
        if (null != this.needCloseConection) {
            this.parallelExecutor.tryCloseConnection(this.needCloseConection);
            this.needCloseConection = null;
        }
        if (null != qr) {
            if (null == this.conWithStatements) {
                this.conWithStatements = new HashMap<String, Integer>();
                Map<String, List<RealSqlContext>> map = this.executionPlan.getSqlMap();
                for (Map.Entry<String, List<RealSqlContext>> entry : map.entrySet()) {
                    this.conWithStatements.put(entry.getKey(), entry.getValue().size());
                }
            }
            int remain = this.conWithStatements.get(qr.getCurrentDBIndex()) - 1;
            this.conWithStatements.put(qr.getCurrentDBIndex(), remain);
            if (remain <= 0) {
                this.needCloseConection = qr.getCurrentDBIndex();
            }
        }
    }
}

