/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor.parallel;

import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.io.ByteArrayInputStream;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.NamedThreadFactory;
import com.taobao.tddl.common.config.ConfigDataHandler;
import com.taobao.tddl.common.config.ConfigDataListener;
import com.taobao.tddl.common.config.impl.DefaultConfigDataHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParallelDiamondConfigManager
implements ConfigDataListener {
    private static Log logger = LogFactory.getLog(ParallelDiamondConfigManager.class);
    public static final String USE_PARALLEL_EXECUTE = "useparallelexecute";
    public static final String PARALLEL_THREAD_COUNT = "parallelthreadcount";
    private static MessageFormat PARALLEL_EXECUTOR_FORMAT = new MessageFormat("com.taobao.tddl.jdbc.client.sqlexecutor.{0}");
    private static boolean useParallel = false;
    private static int esThreadCount = 10;
    private static int queueSize = 2;
    private static Map<String, ThreadPoolExecutor> esMap = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    private boolean inited = false;

    public ParallelDiamondConfigManager(String appName) {
        this.init(appName);
    }

    protected void init(String appName) {
        if (this.inited) {
            return;
        }
        DefaultConfigDataHandlerFactory configHandlerFactory = new DefaultConfigDataHandlerFactory();
        ConfigDataHandler dataHandler = configHandlerFactory.getConfigDataHandler(ParallelDiamondConfigManager.getSqlExecutorKey(appName), (ConfigDataListener)this);
        String data = null;
        try {
            data = dataHandler.getData(10000L, "firstCache");
        }
        catch (Exception e) {
            logger.error((Object)"[PARALLEL_EXECUTE]try to get diamond config error.", (Throwable)e);
        }
        if (StringUtil.isBlank((String)data)) {
            logger.warn((Object)"no parallel execute info, set useParallel false");
            this.setUseParallelFalse();
            return;
        }
        logger.warn((Object)("[INIT]recieve parallel execute config,start to init.data:" + data));
        this.configChange(data, true);
        this.inited = true;
        logger.warn((Object)"[INIT]init parallel execute info success!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void configChange(String data, boolean isInit) {
        int threadCount;
        Properties prop = this.parseConfigStr2Prop(data.toLowerCase());
        if (StringUtil.isBlank((String)((String)prop.get(USE_PARALLEL_EXECUTE))) || StringUtil.isBlank((String)((String)prop.get(PARALLEL_THREAD_COUNT)))) {
            logger.warn((Object)"the parallel config useparallelexecute or parallelthreadcount is blank,must be both configed");
            this.setUseParallelFalse();
            return;
        }
        boolean newUseParallel = Boolean.valueOf((String)prop.get(USE_PARALLEL_EXECUTE));
        if (newUseParallel != useParallel) {
            useParallel = newUseParallel;
        }
        if (esThreadCount != (threadCount = Integer.valueOf((String)prop.get(PARALLEL_THREAD_COUNT)).intValue())) {
            esThreadCount = threadCount;
            if (!isInit) {
                Map<String, ThreadPoolExecutor> map = esMap;
                synchronized (map) {
                    for (Map.Entry<String, ThreadPoolExecutor> entry : esMap.entrySet()) {
                        entry.getValue().setCorePoolSize(esThreadCount);
                        entry.getValue().setMaximumPoolSize(esThreadCount * 2);
                    }
                }
            }
        }
    }

    public void onDataRecieved(String dataId, String data) {
        if (null == data) {
            this.setUseParallelFalse();
            logger.warn((Object)"no parallel execute info, set useParallel false");
            return;
        }
        logger.warn((Object)("[RUNNING]recieve parallel execute config,dataId:" + dataId + " start to init data:" + data));
        this.configChange(data, false);
        logger.warn((Object)"[RUNNING]reset parallel execute info success!");
    }

    public static String getSqlExecutorKey(String appName) {
        return PARALLEL_EXECUTOR_FORMAT.format(new Object[]{appName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseConfigStr2Prop(String data) {
        Properties prop = new Properties();
        if (StringUtil.isNotBlank((String)data)) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(data.getBytes());
                prop.load((InputStream)byteArrayInputStream);
            }
            catch (IOException e) {
                logger.error((Object)"[PARALLEL_EXECUTE]parse diamond config error!", (Throwable)e);
            }
            finally {
                byteArrayInputStream.close();
            }
        }
        return prop;
    }

    private void setUseParallelFalse() {
        useParallel = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future submit(String dbIndex, Runnable command) {
        ThreadPoolExecutor es = null;
        if (null != esMap.get(dbIndex)) {
            es = esMap.get(dbIndex);
            return es.submit(command);
        }
        Map<String, ThreadPoolExecutor> map = esMap;
        synchronized (map) {
            if (null == esMap.get(dbIndex)) {
                logger.warn((Object)("init threadpool for " + dbIndex));
                logger.warn((Object)("dbIndex:" + dbIndex + ",parallel threadPool corepool size:" + esThreadCount + ",maxpool size:" + esThreadCount * 2));
                es = new ThreadPoolExecutor(esThreadCount, esThreadCount * 2, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new NamedThreadFactory("TDDL-PARALLEL"), new ThreadPoolExecutor.CallerRunsPolicy());
                esMap.put(dbIndex, es);
            } else {
                es = esMap.get(dbIndex);
            }
        }
        return es.submit(command);
    }

    public static boolean isUseParallel() {
        return useParallel;
    }
}

