/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor.parallel;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutorCommon;
import com.taobao.tddl.client.jdbc.sqlexecutor.UpdateReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.parallel.ParallelDiamondConfigManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParallelRealSqlExecutor
extends RealSqlExecutorCommon {
    private static final Log logger = LogFactory.getLog(ParallelRealSqlExecutor.class);

    public ParallelRealSqlExecutor(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    public void parallelQuery(ConcurrentLinkedQueue<QueryReturn> queryReturnQueue, final ExecutionPlan executionPlan, TStatementImp tStatementImp, final CountDownLatch latch, List<Future> futures) {
        this.setSpecialProperty(tStatementImp, executionPlan);
        final ExecuteCompleteListener<QueryReturn> ec = new ExecuteCompleteListener<QueryReturn>(queryReturnQueue);
        final boolean isPrepareStatement = this.isPreparedStatement(tStatementImp);
        final Thread mainThread = Thread.currentThread();
        Map<String, List<RealSqlContext>> sqlMap = executionPlan.getSqlMap();
        for (final Map.Entry<String, List<RealSqlContext>> dbEntry : sqlMap.entrySet()) {
            Future future = null;
            futures.add(future);
            future = ParallelDiamondConfigManager.submit(dbEntry.getKey(), new Runnable(){

                @Override
                public void run() {
                    block5: {
                        String dbSelectorId = (String)dbEntry.getKey();
                        try {
                            ParallelRealSqlExecutor.this.checkThreadState();
                            Connection connection = ParallelRealSqlExecutor.this.connectionManager.getConnection(dbSelectorId, executionPlan.isGoSlave());
                            List sqlList = (List)dbEntry.getValue();
                            for (RealSqlContext sql : sqlList) {
                                QueryReturn qr = null;
                                ParallelRealSqlExecutor.this.checkThreadState();
                                long start = System.currentTimeMillis();
                                qr = isPrepareStatement ? ParallelRealSqlExecutor.this.executeQueryIntervalPST(connection, sql) : ParallelRealSqlExecutor.this.executeQueryIntervalST(connection, sql);
                                long during = System.currentTimeMillis() - start;
                                ParallelRealSqlExecutor.this.profileRealDatabaseAndTables(dbSelectorId, sql, during);
                                qr.setCurrentDBIndex(dbSelectorId);
                                ec.addResult(qr);
                            }
                        }
                        catch (SQLException e) {
                            logger.error((Object)"Parallel Query SQLException Happen!", (Throwable)e);
                            if (!mainThread.isInterrupted()) {
                                mainThread.interrupt();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"Parallel Query Unknow Exception Happen!", (Throwable)e);
                            if (mainThread.isInterrupted()) break block5;
                            mainThread.interrupt();
                        }
                    }
                    latch.countDown();
                }
            });
        }
    }

    public void tryCloseConnection(String dbIndex) {
        this.tryCloseConnection(null, dbIndex);
    }

    public void parallelUpdate(ConcurrentLinkedQueue<UpdateReturn> updateReturnQueue, final ExecutionPlan executionPlan, TStatementImp tStatementImp, final CountDownLatch latch, List<Future> futures) {
        this.setSpecialProperty(tStatementImp, executionPlan);
        final ExecuteCompleteListener<UpdateReturn> ec = new ExecuteCompleteListener<UpdateReturn>(updateReturnQueue);
        final boolean isPrepareStatement = this.isPreparedStatement(tStatementImp);
        final Thread mainThread = Thread.currentThread();
        Map<String, List<RealSqlContext>> sqlMap = executionPlan.getSqlMap();
        for (final Map.Entry<String, List<RealSqlContext>> dbEntry : sqlMap.entrySet()) {
            Future future = null;
            futures.add(future);
            future = ParallelDiamondConfigManager.submit(dbEntry.getKey(), new Runnable(){

                @Override
                public void run() {
                    UpdateReturn ur = null;
                    ur = isPrepareStatement ? ParallelRealSqlExecutor.this.executeUpdateIntervalPST(executionPlan, dbEntry) : ParallelRealSqlExecutor.this.executeUpdateIntervalST(executionPlan, dbEntry);
                    if (null != ur.getExceptions() && !ur.getExceptions().isEmpty()) {
                        logger.error((Object)"Parallel Update SQLException Happen!");
                        if (!mainThread.isInterrupted()) {
                            mainThread.interrupt();
                        }
                    }
                    ec.addResult(ur);
                    latch.countDown();
                }
            });
        }
    }

    private class ExecuteCompleteListener<T> {
        private ConcurrentLinkedQueue<T> re = null;

        public ExecuteCompleteListener(ConcurrentLinkedQueue<T> re) {
            this.re = re;
        }

        public void addResult(T ele) {
            this.re.add(ele);
        }
    }
}

