/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor.serial;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.RealSqlExecutorCommon;
import com.taobao.tddl.client.jdbc.sqlexecutor.UpdateReturn;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerialRealSqlExecutor
extends RealSqlExecutorCommon {
    private static final Log logger = LogFactory.getLog(SerialRealSqlExecutor.class);

    public SerialRealSqlExecutor(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    public void serialQuery(ConcurrentLinkedQueue<QueryReturn> queryReturnQueue, ExecutionPlan executionPlan, TStatementImp tStatementImp) {
        this.setSpecialProperty(tStatementImp, executionPlan);
        boolean isPrepareStatement = this.isPreparedStatement(tStatementImp);
        Map<String, List<RealSqlContext>> sqlMap = executionPlan.getSqlMap();
        for (Map.Entry<String, List<RealSqlContext>> dbEntry : sqlMap.entrySet()) {
            String dbSelectorId = dbEntry.getKey();
            try {
                Connection connection = this.connectionManager.getConnection(dbSelectorId, executionPlan.isGoSlave());
                List<RealSqlContext> sqlList = dbEntry.getValue();
                for (RealSqlContext sql : sqlList) {
                    QueryReturn qr = null;
                    long start = System.currentTimeMillis();
                    qr = isPrepareStatement ? this.executeQueryIntervalPST(connection, sql) : this.executeQueryIntervalST(connection, sql);
                    long during = System.currentTimeMillis() - start;
                    qr.setCurrentDBIndex(dbSelectorId);
                    queryReturnQueue.add(qr);
                    this.profileRealDatabaseAndTables(dbSelectorId, sql, during);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                QueryReturn qr = new QueryReturn();
                qr.add2ExceptionList(e);
                this.tryCloseConnection(qr.getExceptions(), dbSelectorId);
                queryReturnQueue.add(qr);
                break;
            }
        }
    }

    protected void tryCloseConnection(String dbIndex) {
        this.tryCloseConnection(null, dbIndex);
    }

    public void serialUpdate(ConcurrentLinkedQueue<UpdateReturn> updateReturnQueue, ExecutionPlan executionPlan, TStatementImp tStatementImp) {
        this.setSpecialProperty(tStatementImp, executionPlan);
        boolean isPrepareStatement = this.isPreparedStatement(tStatementImp);
        Map<String, List<RealSqlContext>> sqlMap = executionPlan.getSqlMap();
        for (Map.Entry<String, List<RealSqlContext>> dbEntry : sqlMap.entrySet()) {
            UpdateReturn ur = null;
            ur = isPrepareStatement ? this.executeUpdateIntervalPST(executionPlan, dbEntry) : this.executeUpdateIntervalST(executionPlan, dbEntry);
            updateReturnQueue.add(ur);
        }
    }
}

