/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sqlexecutor.serial;

import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.TStatementImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.sqlexecutor.QueryReturn;
import com.taobao.tddl.client.jdbc.sqlexecutor.serial.SerialRealSqlExecutor;
import com.taobao.tddl.client.util.ExceptionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSerialRealSqlExecutor
extends SerialRealSqlExecutor {
    private static final Log logger = LogFactory.getLog(SimpleSerialRealSqlExecutor.class);
    protected String currentDBIndex = null;
    protected int tableIndex = 0;
    private List<RealSqlContext> sqlContextToBeExecOnCurrentDB;
    protected ExecutionPlan executionPlanIn;
    private List<String> dbIndexList;
    protected Statement statement;
    protected ResultSet resultSet;
    private final Random ran = new Random();
    private boolean isPreparedStatement = false;

    public SimpleSerialRealSqlExecutor(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public void serialQuery(ConcurrentLinkedQueue<QueryReturn> queryReturnQueue, ExecutionPlan executionPlan, TStatementImp tStatementImp) {
        if (null == this.executionPlanIn && null != executionPlan) {
            this.executionPlanIn = executionPlan;
            this.isPreparedStatement = this.isPreparedStatement(tStatementImp);
            this.dbIndexList = new LinkedList<String>(executionPlan.getSqlMap().keySet());
            this.setSpecialProperty(tStatementImp, executionPlan);
        }
        List<SQLException> sqlExceptions = null;
        try {
            if (this.select()) {
                try {
                    Connection con = this.connectionManager.getConnection(this.currentDBIndex, executionPlan.isGoSlave());
                    QueryReturn qr = null;
                    qr = !this.isPreparedStatement ? this.executeQueryIntervalST(con, this.sqlContextToBeExecOnCurrentDB.get(this.tableIndex)) : this.executeQueryIntervalPST(con, this.sqlContextToBeExecOnCurrentDB.get(this.tableIndex));
                    qr.setCurrentDBIndex(this.currentDBIndex);
                    this.resultSet = qr.getResultset();
                    this.statement = qr.getStatement();
                    queryReturnQueue.add(qr);
                    return;
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    sqlExceptions = ExceptionUtils.appendToExceptionList(sqlExceptions, e);
                    sqlExceptions = this.tryCloseConnection(sqlExceptions, this.currentDBIndex);
                    this.closeAndClearResources(sqlExceptions);
                }
            }
            this.writeLogOrThrowSQLException("TDDL print sqlException while retry :", sqlExceptions);
        }
        catch (SQLException e) {
            QueryReturn qr = new QueryReturn();
            qr.setExceptions(sqlExceptions);
            queryReturnQueue.add(qr);
        }
    }

    protected boolean select() throws SQLException {
        List<SQLException> sqlExceptions = null;
        if (this.currentDBIndex == null) {
            if (this.tableIndex != 0) {
                throw new IllegalStateException("tableIndex != 0 should not be here!");
            }
            this.writeLogOrThrowSQLException("TDDL print sqlException while close resources:", sqlExceptions);
            return this.selectDBGroupByRandom();
        }
        ++this.tableIndex;
        if (this.sqlContextToBeExecOnCurrentDB.size() <= this.tableIndex) {
            sqlExceptions = this.tryCloseConnection(sqlExceptions, this.currentDBIndex);
            this.writeLogOrThrowSQLException("TDDL print sqlException while close resources:", sqlExceptions);
            return this.selectDBGroupByRandom();
        }
        this.writeLogOrThrowSQLException("TDDL print sqlException while close resources:", sqlExceptions);
        return true;
    }

    private boolean selectDBGroupByRandom() {
        this.tableIndex = 0;
        int size = this.dbIndexList.size();
        if (size == 0) {
            this.currentDBIndex = null;
            this.sqlContextToBeExecOnCurrentDB = null;
            return false;
        }
        this.currentDBIndex = this.dbIndexList.remove(this.ran.nextInt(size));
        this.sqlContextToBeExecOnCurrentDB = this.executionPlanIn.getSqlMap().get(this.currentDBIndex);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SQLException> closeAndClearResources(List<SQLException> exceptions) {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
            }
            finally {
                this.statement = null;
            }
        }
        return exceptions;
    }

    private void writeLogOrThrowSQLException(String message, List<SQLException> sqlExceptions) throws SQLException {
        ExceptionUtils.throwSQLException(sqlExceptions, this.executionPlanIn.getOriginalSql(), this.executionPlanIn.getOriginalArgs());
    }

    @Override
    protected List<SQLException> tryCloseConnection(List<SQLException> exceptions, String dbSelectorId) {
        try {
            this.connectionManager.tryClose(dbSelectorId);
        }
        catch (SQLException e) {
            exceptions = ExceptionUtils.appendToExceptionList(exceptions, e);
        }
        return exceptions;
    }
}

