/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.pipeline;

import com.taobao.tddl.client.dispatcher.SqlDispatcher;
import com.taobao.tddl.client.pipeline.Pipeline;
import com.taobao.tddl.client.pipeline.PipelineFactory;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.SQLPreParser;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.parser.ParserCache;
import com.taobao.tddl.rule.bean.LogicTable;
import com.taobao.tddl.rule.ruleengine.util.StringUtils;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPipelineFactory
implements PipelineFactory {
    public static final Log logger = LogFactory.getLog(AbstractPipelineFactory.class);
    protected SqlDispatcher defaultDispatcher;
    protected Map<String, SqlDispatcher> dispatcherMap;
    private static final Pattern SELECT_FOR_UPDATE_PATTERN = Pattern.compile("^select\\s+.*\\s+for\\s+update.*$", 2);
    private static final ParserCache globalCache = ParserCache.instance();

    @Override
    public abstract Pipeline getPipeline();

    @Override
    public SqlDispatcher selectSqlDispatcher(String selectKey) throws SQLException {
        if (selectKey == null) {
            return this.defaultDispatcher;
        }
        SqlDispatcher sqlDispatcher = this.dispatcherMap.get(selectKey);
        if (sqlDispatcher == null) {
            throw new IllegalArgumentException("can't find selector by key :" + selectKey);
        }
        return sqlDispatcher;
    }

    @Override
    public void setDefaultDispatcher(SqlDispatcher defaultDispatcher) {
        this.defaultDispatcher = defaultDispatcher;
    }

    @Override
    public void setDispatcherMap(Map<String, SqlDispatcher> dispatcherMap) {
        this.dispatcherMap = dispatcherMap;
    }

    public static SqlType getSqlType(String sql) throws SQLException {
        SqlType sqlType = globalCache.getSqlType(sql);
        if (sqlType == null) {
            String noCommentsSql = sql;
            if (sql.contains("/*")) {
                noCommentsSql = StringUtils.stripComments((String)sql, (String)"'\"", (String)"'\"", (boolean)true, (boolean)false, (boolean)true, (boolean)true).trim();
            }
            if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"select")) {
                sqlType = noCommentsSql.toLowerCase().contains(" for ") && SELECT_FOR_UPDATE_PATTERN.matcher(noCommentsSql).matches() ? SqlType.SELECT_FOR_UPDATE : SqlType.SELECT;
            } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"insert")) {
                sqlType = SqlType.INSERT;
            } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"update")) {
                sqlType = SqlType.UPDATE;
            } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"delete")) {
                sqlType = SqlType.DELETE;
            } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"replace")) {
                sqlType = SqlType.REPLACE;
            } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"truncate")) {
                sqlType = SqlType.TRUNCATE;
            } else {
                throw new SQLException("only select, insert, update, delete, replace,truncate sql is supported");
            }
            sqlType = globalCache.setSqlTypeIfAbsent(sql, sqlType);
        }
        return sqlType;
    }

    @Override
    public DirectlyRouteCondition sqlPreParse(String sql) throws SQLException {
        Map logicTableMap;
        if (null != ThreadLocalMap.get((Object)"ROUTE_CONDITION") || null != ThreadLocalMap.get((Object)"DB_SELECTOR") || null != ThreadLocalMap.get((Object)"RULE_SELECTOR")) {
            return null;
        }
        String firstTable = SQLPreParser.findTableName((String)sql);
        if (null != firstTable && null != (logicTableMap = this.defaultDispatcher.getRoot().getLogicTableMap()).get(firstTable)) {
            return null;
        }
        logger.debug((Object)"no logic table in defaultDispather's logicTableMap,try to produce DirectlyRouteCondition");
        if (null == this.defaultDispatcher.getRoot().getDefaultDBSelectorID()) {
            throw new SQLException("the defaultDispatcher have no defaultDbIndex");
        }
        DirectlyRouteCondition condition = new DirectlyRouteCondition();
        condition.setDBId(this.defaultDispatcher.getRoot().getDefaultDBSelectorID());
        return condition;
    }

    @Override
    public DBType decideDBType(String sql, SqlDispatcher sqlDispatcher) throws SQLException {
        String firstTable = SQLPreParser.findTableName((String)sql);
        if (null != firstTable) {
            Map logicTableMap = sqlDispatcher.getRoot().getLogicTableMap();
            DBType findInLogicTab = null;
            if (null != logicTableMap.get(firstTable)) {
                findInLogicTab = ((LogicTable)logicTableMap.get(firstTable)).getDbType();
            }
            return findInLogicTab;
        }
        return (DBType)sqlDispatcher.getRoot().getDBType();
    }
}

