/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.pipeline;

import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.handler.Handler;
import com.taobao.tddl.client.pipeline.HandlerContext;
import com.taobao.tddl.client.pipeline.Pipeline;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.NullArgumentException;

public class DefaultPipeline
implements Pipeline {
    private Log logger = LogFactory.getLog(DefaultPipeline.class);
    private volatile DefaultHandlerContext head;
    private volatile DefaultHandlerContext tail;
    private final Map<String, DefaultHandlerContext> name2ctx = new HashMap<String, DefaultHandlerContext>(4);

    @Override
    public synchronized void addAfter(String baseName, String name, Handler handler) {
        DefaultHandlerContext ctx = this.getContextOrDie(baseName);
        if (ctx == this.tail) {
            this.addLast(name, handler);
        } else {
            DefaultHandlerContext newCtx;
            this.checkDuplicateName(name);
            ctx.next.prev = newCtx = new DefaultHandlerContext(ctx, ctx.next, name, handler);
            ctx.next = newCtx;
            this.name2ctx.put(name, newCtx);
        }
    }

    @Override
    public synchronized void addBefore(String baseName, String name, Handler handler) {
        DefaultHandlerContext ctx = this.getContextOrDie(baseName);
        if (ctx == this.head) {
            this.addFirst(name, handler);
        } else {
            DefaultHandlerContext newCtx;
            this.checkDuplicateName(name);
            ctx.prev.next = newCtx = new DefaultHandlerContext(ctx.prev, ctx, name, handler);
            ctx.prev = newCtx;
            this.name2ctx.put(name, newCtx);
        }
    }

    @Override
    public synchronized void addFirst(String name, Handler handler) {
        if (this.name2ctx.isEmpty()) {
            this.init(name, handler);
        } else {
            DefaultHandlerContext newHead;
            this.checkDuplicateName(name);
            DefaultHandlerContext oldHead = this.head;
            oldHead.prev = newHead = new DefaultHandlerContext(null, oldHead, name, handler);
            this.head = newHead;
            this.name2ctx.put(name, newHead);
        }
    }

    @Override
    public synchronized void addLast(String name, Handler handler) {
        if (this.name2ctx.isEmpty()) {
            this.init(name, handler);
        } else {
            DefaultHandlerContext newTail;
            this.checkDuplicateName(name);
            DefaultHandlerContext oldTail = this.tail;
            oldTail.next = newTail = new DefaultHandlerContext(oldTail, null, name, handler);
            this.tail = newTail;
            this.name2ctx.put(name, newTail);
        }
    }

    @Override
    public void startFlow(DataBus dataBus) throws SQLException {
        if (this.head == null) {
            this.logger.warn((Object)"The pipeline contains no next handlers");
            return;
        }
        this.head.handleDown(this.head, dataBus);
    }

    @Override
    public synchronized Handler get(String name) {
        DefaultHandlerContext ctx = this.name2ctx.get(name);
        if (ctx == null) {
            return null;
        }
        return ctx.getHandler();
    }

    @Override
    public synchronized HandlerContext getContext(Handler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (this.name2ctx.isEmpty()) {
            return null;
        }
        DefaultHandlerContext ctx = this.head;
        do {
            if (ctx.getHandler() != handler) continue;
            return ctx;
        } while ((ctx = ctx.next) != null);
        return null;
    }

    @Override
    public synchronized HandlerContext getContext(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return this.name2ctx.get(name);
    }

    @Override
    public HandlerContext getContext(Class<? extends Handler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        if (this.name2ctx.isEmpty()) {
            return null;
        }
        DefaultHandlerContext ctx = this.head;
        do {
            if (!handlerType.isAssignableFrom(ctx.getHandler().getClass())) continue;
            return ctx;
        } while ((ctx = ctx.next) != null);
        return null;
    }

    @Override
    public synchronized Handler getFirst() {
        DefaultHandlerContext head = this.head;
        if (head == null) {
            return null;
        }
        return head.getHandler();
    }

    @Override
    public synchronized Handler getLast() {
        DefaultHandlerContext tail = this.tail;
        if (tail == null) {
            return null;
        }
        return tail.getHandler();
    }

    @Override
    public synchronized void remove(Handler handler) {
        this.remove(this.getContextOrDie(handler));
    }

    @Override
    public synchronized Handler remove(String name) {
        return this.remove(this.getContextOrDie(name)).getHandler();
    }

    @Override
    public synchronized <T extends Handler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType)).getHandler();
    }

    @Override
    public synchronized Handler removeFirst() {
        if (this.name2ctx.isEmpty()) {
            throw new NoSuchElementException();
        }
        DefaultHandlerContext oldHead = this.head;
        if (oldHead == null) {
            throw new NoSuchElementException();
        }
        if (oldHead.next == null) {
            this.tail = null;
            this.head = null;
            this.name2ctx.clear();
        } else {
            oldHead.next.prev = null;
            this.head = oldHead.next;
            this.name2ctx.remove(oldHead.getName());
        }
        return oldHead.getHandler();
    }

    @Override
    public Handler removeLast() {
        if (this.name2ctx.isEmpty()) {
            throw new NoSuchElementException();
        }
        DefaultHandlerContext oldTail = this.tail;
        if (oldTail == null) {
            throw new NoSuchElementException();
        }
        if (oldTail.prev == null) {
            this.tail = null;
            this.head = null;
            this.name2ctx.clear();
        } else {
            oldTail.prev.next = null;
            this.tail = oldTail.prev;
            this.name2ctx.remove(oldTail.getName());
        }
        return oldTail.getHandler();
    }

    @Override
    public synchronized void replace(Handler oldHandler, String newName, Handler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler);
    }

    @Override
    public Handler replace(String oldName, String newName, Handler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler);
    }

    @Override
    public <T extends Handler> T replace(Class<T> oldHandlerType, String newName, Handler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler);
    }

    private void init(String name, Handler handler) {
        DefaultHandlerContext ctx;
        this.head = this.tail = (ctx = new DefaultHandlerContext(null, null, name, handler));
        this.name2ctx.clear();
        this.name2ctx.put(name, ctx);
    }

    private DefaultHandlerContext getContextOrDie(String name) {
        DefaultHandlerContext ctx = (DefaultHandlerContext)this.getContext(name);
        if (ctx == null) {
            throw new NoSuchElementException("\u4e0d\u5b58\u5728\u5982\u4e0b\u4e0a\u4e0b\u6587\u8282\u70b9\uff1a" + name);
        }
        return ctx;
    }

    private void checkDuplicateName(String name) {
        if (this.name2ctx.containsKey(name)) {
            throw new IllegalArgumentException("\u5904\u7406\u5668\u4e0a\u4e0b\u6587\u91cd\u540d\uff0c\u91cd\u540d\u7684\u662f\uff1a" + name);
        }
    }

    private DefaultHandlerContext getContextOrDie(Handler handler) {
        DefaultHandlerContext ctx = (DefaultHandlerContext)this.getContext(handler);
        if (ctx == null) {
            throw new NoSuchElementException("\u4e0d\u5b58\u5728\u5982\u4e0b\u4e0a\u4e0b\u6587\u8282\u70b9\uff1a" + handler.getClass().getName());
        }
        return ctx;
    }

    private DefaultHandlerContext getContextOrDie(Class<? extends Handler> handlerType) {
        DefaultHandlerContext ctx = (DefaultHandlerContext)this.getContext(handlerType);
        if (ctx == null) {
            throw new NoSuchElementException("\u4e0d\u5b58\u5728\u5982\u4e0b\u4e0a\u4e0b\u6587\u8282\u70b9\uff1a" + handlerType.getName());
        }
        return ctx;
    }

    DefaultHandlerContext getActualFlowContext(DefaultHandlerContext ctx) {
        if (ctx == null) {
            return null;
        }
        DefaultHandlerContext realCtx = ctx;
        realCtx = realCtx.next;
        if (realCtx == null) {
            return null;
        }
        return realCtx;
    }

    private DefaultHandlerContext remove(DefaultHandlerContext ctx) {
        if (this.head == this.tail) {
            this.tail = null;
            this.head = null;
            this.name2ctx.clear();
        } else if (ctx == this.head) {
            this.removeFirst();
        } else if (ctx == this.tail) {
            this.removeLast();
        } else {
            DefaultHandlerContext next;
            DefaultHandlerContext prev = ctx.prev;
            prev.next = next = ctx.next;
            next.prev = prev;
            this.name2ctx.remove(ctx.getName());
        }
        return ctx;
    }

    private Handler replace(DefaultHandlerContext ctx, String newName, Handler newHandler) {
        if (ctx == this.head) {
            this.removeFirst();
            this.addFirst(newName, newHandler);
        } else if (ctx == this.tail) {
            this.removeLast();
            this.addLast(newName, newHandler);
        } else {
            DefaultHandlerContext newCtx;
            boolean sameName = ctx.getName().equals(newName);
            if (!sameName) {
                this.checkDuplicateName(newName);
            }
            DefaultHandlerContext prev = ctx.prev;
            DefaultHandlerContext next = ctx.next;
            prev.next = newCtx = new DefaultHandlerContext(prev, next, newName, newHandler);
            next.prev = newCtx;
            if (!sameName) {
                this.name2ctx.remove(ctx.getName());
                this.name2ctx.put(newName, newCtx);
            }
        }
        return ctx.getHandler();
    }

    public class DefaultHandlerContext
    implements HandlerContext {
        volatile DefaultHandlerContext next;
        volatile DefaultHandlerContext prev;
        private final String name;
        private final Handler handler;

        DefaultHandlerContext(DefaultHandlerContext prev, DefaultHandlerContext next, String name, Handler handler) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            this.handler = handler;
            this.name = name;
            this.prev = prev;
            this.next = next;
        }

        @Override
        public void flowNext(DataBus dataBus) throws SQLException {
            DefaultHandlerContext realNext = DefaultPipeline.this.getActualFlowContext(this);
            if (realNext == null) {
                return;
            }
            this.handleDown(realNext, dataBus);
        }

        public void handleDown(DefaultHandlerContext realNext, DataBus dataBus) throws SQLException {
            realNext.getHandler().handleDown(dataBus);
            realNext.flowNext(dataBus);
        }

        @Override
        public Handler getHandler() {
            return this.handler;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Pipeline getPipeLine() {
            return DefaultPipeline.this;
        }
    }
}

