/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.pipeline;

import com.taobao.tddl.client.dispatcher.SqlDispatcher;
import com.taobao.tddl.client.handler.executionplan.BatchTargetSqlHandler;
import com.taobao.tddl.client.handler.executionplan.ExecutionPlanHandler;
import com.taobao.tddl.client.handler.executionplan.SqlDirectDispatchHandler;
import com.taobao.tddl.client.handler.rulematch.RuleLeRouteMatchHandler;
import com.taobao.tddl.client.handler.sqlparse.RouteConditionHandler;
import com.taobao.tddl.client.handler.sqlparse.SqlParseHandler;
import com.taobao.tddl.client.handler.validate.SqlDispatchHandler;
import com.taobao.tddl.client.pipeline.AbstractPipelineFactory;
import com.taobao.tddl.client.pipeline.DefaultPipeline;
import com.taobao.tddl.client.pipeline.Pipeline;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.SQLPreParser;
import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.rule.le.TddlRuleInner;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import java.sql.SQLException;
import java.util.Map;

public class RuleLePipelineFactory
extends AbstractPipelineFactory {
    private Pipeline defaultPipeline = new DefaultPipeline();

    private RuleLePipelineFactory() {
    }

    public RuleLePipelineFactory(TddlRuleInner tddlRule) {
        this.defaultPipeline.addLast("RouteConditionHandler", new RouteConditionHandler());
        this.defaultPipeline.addLast("SqlParseHandler", new SqlParseHandler());
        this.defaultPipeline.addLast("RuleLeRouteMatchHandler", new RuleLeRouteMatchHandler(tddlRule));
        this.defaultPipeline.addLast("SqlDirectDispatchHandler", new SqlDirectDispatchHandler());
        this.defaultPipeline.addLast("SqlDispatchHandler", new SqlDispatchHandler());
        this.defaultPipeline.addLast("ExecutionPlanHandler", new ExecutionPlanHandler());
        this.defaultPipeline.addLast("BatchTargetSqlHandler", new BatchTargetSqlHandler());
    }

    @Override
    public Pipeline getPipeline() {
        return this.defaultPipeline;
    }

    @Override
    public DirectlyRouteCondition sqlPreParse(String sql) throws SQLException {
        Map vtabMap;
        if (null != ThreadLocalMap.get((Object)"ROUTE_CONDITION") || null != ThreadLocalMap.get((Object)"DB_SELECTOR") || null != ThreadLocalMap.get((Object)"RULE_SELECTOR")) {
            return null;
        }
        String firstTable = SQLPreParser.findTableName((String)sql);
        if (null != firstTable && null != (vtabMap = this.defaultDispatcher.getVtabroot().getVirtualTableMap()).get(firstTable)) {
            return null;
        }
        logger.debug((Object)"no logic table in defaultDispather's logicTableMap,try to produce DirectlyRouteCondition");
        DirectlyRouteCondition condition = new DirectlyRouteCondition();
        Map dbIndexMap = this.defaultDispatcher.getVtabroot().getDbIndexMap();
        if (dbIndexMap != null && dbIndexMap.get(firstTable) != null) {
            condition.setDBId((String)dbIndexMap.get(firstTable));
            return condition;
        }
        String defaultDbIndex = this.defaultDispatcher.getVtabroot().getDefaultDbIndex();
        if (defaultDbIndex == null) {
            throw new SQLException("the defaultDispatcher have no dbIndexMap and defaultDbIndex");
        }
        condition.setDBId(defaultDbIndex);
        return condition;
    }

    @Override
    public DBType decideDBType(String sql, SqlDispatcher sqlDispatcher) throws SQLException {
        String firstTable = SQLPreParser.findTableName((String)sql);
        if (null != firstTable) {
            Map vtabMap = sqlDispatcher.getVtabroot().getVirtualTableMap();
            DBType findInLogicTab = null;
            if (null != vtabMap.get(firstTable)) {
                findInLogicTab = ((VirtualTable)vtabMap.get(firstTable)).getDbType();
            }
            return findInLogicTab;
        }
        return sqlDispatcher.getVtabroot().getDbTypeEnumObj();
    }
}

