/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.pipeline.bootstrap;

import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineContextDataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.databus.StartInfo;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.dispatcher.SqlDispatcher;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.client.jdbc.ConnectionManager;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.pipeline.Pipeline;
import com.taobao.tddl.client.pipeline.PipelineFactory;
import com.taobao.tddl.client.pipeline.bootstrap.Bootstrap;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.jdbc.ParameterContext;
import com.taobao.tddl.common.jdbc.ParameterMethod;
import com.taobao.tddl.util.HintParser;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.SimpleCondition;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PipelineBootstrap
implements Bootstrap {
    protected PipelineFactory pipelineFactory;
    protected ConnectionManager connectionManager;

    public PipelineBootstrap(ConnectionManager connectionManager, PipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
        this.connectionManager = connectionManager;
    }

    @Override
    public ExecutionPlan bootstrap(StartInfo startInfo) throws SQLException {
        DataBus dataBus = null;
        RouteCondition rcFromHint = HintParser.convertHint2RouteCondition(startInfo);
        if (rcFromHint == null) {
            DirectlyRouteCondition condition = this.pipelineFactory.sqlPreParse(startInfo.getSql());
            dataBus = null == condition ? this.bootstrap0(startInfo) : this.bootstrap0Direct(startInfo, condition);
        } else {
            HintParser.removeTddlHintAndParameter(startInfo);
            dataBus = this.bootstrap0(startInfo, rcFromHint);
        }
        return this.getExecutionPlan(dataBus);
    }

    @Override
    public void bootstrapForBatch(StartInfo startInfo, boolean needRowCopy, Map<String, List<String>> targetSqls, String selectKey) throws SQLException {
        this.bootstrap0ForBatch(startInfo, selectKey, false, targetSqls, null);
    }

    @Override
    public void bootstrapForPrepareBatch(StartInfo startInfo, boolean needRowCopy, Map<String, Map<String, List<List<ParameterContext>>>> targetSqls, String selectKey) throws SQLException {
        this.bootstrap0ForBatch(startInfo, selectKey, true, null, targetSqls);
    }

    @Override
    public DispatcherResult bootstrapForGetDBAndTabs(RouteCondition rc, SqlDispatcher sqlDispatcher) throws SQLException {
        DataBus dataBus = this.bootstrap0ForGetDBAndTabs(rc, null, null, sqlDispatcher);
        return this.getDispatcherResult(dataBus);
    }

    @Override
    public DispatcherResult bootstrapForGetDBAndTabs(String sql, List<Object> args, SqlDispatcher sqlDispatcher) throws SQLException {
        DataBus dataBus = this.bootstrap0ForGetDBAndTabs(null, sql, args, sqlDispatcher);
        return this.getDispatcherResult(dataBus);
    }

    private DispatcherResult getDispatcherResult(DataBus dataBus) {
        PipelineRuntimeInfo runtime = (PipelineRuntimeInfo)dataBus.getPluginContext("PipelineRuntimeInfo");
        return runtime.getMetaData();
    }

    private ExecutionPlan getExecutionPlan(DataBus dataBus) {
        PipelineRuntimeInfo runtime = (PipelineRuntimeInfo)dataBus.getPluginContext("PipelineRuntimeInfo");
        return runtime.getExecutionPlan();
    }

    private DataBus bootstrap0ForGetDBAndTabs(RouteCondition rc, String sql, List<Object> args, SqlDispatcher sqlDispatcher) throws SQLException {
        StartInfo startInfo = new StartInfo();
        AbstractHandler.FlowType flowType = null;
        if (null != rc) {
            flowType = AbstractHandler.FlowType.DBANDTAB_RC;
            startInfo.setRc(rc);
        } else {
            flowType = AbstractHandler.FlowType.DBANDTAB_SQL;
        }
        PipelineContextDataBus dataBus = new PipelineContextDataBus();
        PipelineRuntimeInfo runtime = new PipelineRuntimeInfo();
        dataBus.registerPluginContext("PipelineRuntimeInfo", runtime);
        startInfo.setSql(sql);
        startInfo.setDbType(this.pipelineFactory.decideDBType(sql, sqlDispatcher));
        startInfo.setSqlArgs(args);
        runtime.setFlowType(flowType);
        runtime.setStartInfo(startInfo);
        runtime.setSqlDispatcher(sqlDispatcher);
        Pipeline pipeline = this.pipelineFactory.getPipeline();
        pipeline.startFlow(dataBus);
        return dataBus;
    }

    private DataBus bootstrap0ForBatch(StartInfo startInfo, String selectKey, boolean isPreparedBatch, Map<String, List<String>> targetSqls, Map<String, Map<String, List<List<ParameterContext>>>> prePareTargetSqls) throws SQLException {
        SimpleCondition rc = (SimpleCondition)this.getRouteContiongFromThreadLocal("ROUTE_CONDITION");
        DirectlyRouteCondition condition = this.pipelineFactory.sqlPreParse(startInfo.getSql());
        AbstractHandler.FlowType flowType = null;
        if (rc != null) {
            List<Object> params = this.getSqlParameters(startInfo.getSqlParam());
            Map<String, Integer> paramIndexs = rc.getParametersIndexForBatch();
            for (Map.Entry<String, Integer> index : paramIndexs.entrySet()) {
                rc.put(index.getKey(), (Comparable)params.get(index.getValue()));
            }
            flowType = AbstractHandler.FlowType.BATCH_NOSQLPARSER;
        } else {
            flowType = condition != null ? AbstractHandler.FlowType.BATCH_DIRECT : AbstractHandler.FlowType.BATCH;
        }
        DataBus dataBus = this.getPluginDataBus(startInfo, this.connectionManager.getAutoCommit(), flowType, selectKey, null, condition);
        PipelineRuntimeInfo runtime = (PipelineRuntimeInfo)dataBus.getPluginContext("PipelineRuntimeInfo");
        runtime.getStartInfo().setParameterBatch(isPreparedBatch);
        runtime.getStartInfo().setTargetSqls(prePareTargetSqls);
        runtime.getStartInfo().setRc(rc);
        runtime.getStartInfo().setTargetSqlsNoParameter(targetSqls);
        Pipeline pipeline = this.pipelineFactory.getPipeline();
        pipeline.startFlow(dataBus);
        return dataBus;
    }

    private List<Object> getSqlParameters(Map<Integer, ParameterContext> sqlParam) {
        if (sqlParam != null) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (ParameterContext context : sqlParam.values()) {
                if (context.getParameterMethod() != ParameterMethod.setNull1 && context.getParameterMethod() != ParameterMethod.setNull2) {
                    parameters.add(context.getArgs()[1]);
                    continue;
                }
                parameters.add(null);
            }
            return parameters;
        }
        return Collections.emptyList();
    }

    private DataBus bootstrap0(StartInfo startInfo) throws SQLException {
        return this.bootstrap0(startInfo, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataBus bootstrap0(StartInfo startInfo, RouteCondition fromHintRc) throws SQLException {
        AbstractHandler.FlowType flowType;
        RouteCondition rc = null;
        DirectlyRouteCondition ruleCondition = null;
        DirectlyRouteCondition directlyRouteCondition = null;
        if (null == fromHintRc) {
            rc = this.getRouteContiongFromThreadLocal("ROUTE_CONDITION");
            ruleCondition = (DirectlyRouteCondition)this.getRouteContiongFromThreadLocal("RULE_SELECTOR");
            directlyRouteCondition = (DirectlyRouteCondition)this.getRouteContiongFromThreadLocal("DB_SELECTOR");
        } else if (fromHintRc instanceof DirectlyRouteCondition) {
            directlyRouteCondition = (DirectlyRouteCondition)fromHintRc;
        } else {
            rc = fromHintRc;
        }
        String ruleId = null;
        if (directlyRouteCondition != null) {
            String dbRuleId = directlyRouteCondition.getDbRuleID();
            if (!this.connectionManager.containDBIndex(dbRuleId)) throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u6267\u884c\u5e93: " + dbRuleId);
            flowType = AbstractHandler.FlowType.DIRECT;
        } else if (ruleCondition != null) {
            ruleId = ruleCondition.getDbRuleID();
            flowType = rc != null ? AbstractHandler.FlowType.NOSQLPARSE : AbstractHandler.FlowType.DEFAULT;
        } else {
            flowType = null != rc ? AbstractHandler.FlowType.NOSQLPARSE : AbstractHandler.FlowType.DEFAULT;
        }
        DataBus dataBus = this.getPluginDataBus(startInfo, this.connectionManager.getAutoCommit(), flowType, ruleId, rc, directlyRouteCondition);
        Pipeline pipeline = this.pipelineFactory.getPipeline();
        pipeline.startFlow(dataBus);
        return dataBus;
    }

    private DataBus bootstrap0Direct(StartInfo startInfo, DirectlyRouteCondition condition) throws SQLException {
        AbstractHandler.FlowType flowType = null;
        if (condition != null) {
            String dbRuleId = condition.getDbRuleID();
            if (this.connectionManager.containDBIndex(dbRuleId)) {
                flowType = AbstractHandler.FlowType.DIRECT;
            } else {
                throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u6267\u884c\u5e93: " + dbRuleId);
            }
        }
        DataBus dataBus = this.getPluginDataBus(startInfo, this.connectionManager.getAutoCommit(), flowType, null, null, condition);
        Pipeline pipeline = this.pipelineFactory.getPipeline();
        pipeline.startFlow(dataBus);
        return dataBus;
    }

    protected DataBus getPluginDataBus(StartInfo startInfo, boolean autoCommit, AbstractHandler.FlowType flowType, String selectKey, RouteCondition rc, DirectlyRouteCondition directlyRouteCondition) throws SQLException {
        PipelineContextDataBus dataBus = new PipelineContextDataBus();
        PipelineRuntimeInfo runtime = new PipelineRuntimeInfo();
        dataBus.registerPluginContext("PipelineRuntimeInfo", runtime);
        if (startInfo == null) {
            startInfo = new StartInfo();
        }
        startInfo.setDbType(this.pipelineFactory.decideDBType(startInfo.getSql(), this.pipelineFactory.selectSqlDispatcher(selectKey)));
        startInfo.setAutoCommit(autoCommit);
        startInfo.setRc(rc);
        startInfo.setDirectlyRouteCondition(directlyRouteCondition);
        runtime.setStartInfo(startInfo);
        runtime.setFlowType(flowType);
        runtime.setSqlDispatcher(this.pipelineFactory.selectSqlDispatcher(selectKey));
        return dataBus;
    }

    protected RouteCondition getRouteContiongFromThreadLocal(String key) {
        RouteCondition.ROUTE_TYPE routeType;
        RouteCondition rc = (RouteCondition)ThreadLocalMap.get((Object)key);
        if (rc != null && RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE.equals((Object)(routeType = rc.getRouteType()))) {
            ThreadLocalMap.put((Object)key, null);
        }
        return rc;
    }
}

