/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.sequence.impl;

import com.taobao.tddl.client.sequence.RoutedSequence;
import com.taobao.tddl.client.sequence.Sequence;
import com.taobao.tddl.client.sequence.exception.SequenceException;
import com.taobao.tddl.common.sequence.Config;
import org.dom4j.DocumentException;

public class DefaultRoutedSequence<DatabaseRouteType, TableRouteType>
implements RoutedSequence<DatabaseRouteType, TableRouteType> {
    private static final long[] pow10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private Config config;
    private long mulDatabase;
    private long mulRoute;
    private int routeSize;
    private Config.Route databaseRoute;
    private Config.Route tableRoute;
    private Config.Route.Expression<DatabaseRouteType> databaseExpression;
    private Config.Route.Expression<TableRouteType> tableExpression;
    private Sequence sequence;

    public DefaultRoutedSequence(String path, String id, Sequence sequence) throws SequenceException {
        try {
            this.config = new Config.Factory(path).newInstance(id);
        }
        catch (DocumentException e) {
            throw new SequenceException((Throwable)e);
        }
        catch (Config.ConfigException e) {
            throw new SequenceException((Throwable)e);
        }
        this.databaseRoute = this.config.getDatabaseRoute();
        if (this.databaseRoute != null) {
            this.databaseExpression = this.databaseRoute.getExpression();
            this.routeSize += this.databaseRoute.getSize();
        }
        this.tableRoute = this.config.getTableRoute();
        if (this.tableRoute != null) {
            this.tableExpression = this.tableRoute.getExpression();
            this.routeSize += this.tableRoute.getSize();
            this.mulDatabase = pow10[this.tableRoute.getSize()];
        }
        if (this.routeSize != 0) {
            this.mulRoute = !this.config.isPositionRight() ? pow10[19 - this.routeSize] : pow10[this.routeSize];
        }
        this.setSequence(sequence);
    }

    public DefaultRoutedSequence(String path, String id) throws SequenceException {
        this(path, id, null);
    }

    public long nextValue(DatabaseRouteType databaseRoute, TableRouteType tableRoute) throws SequenceException {
        int tmp;
        int routeBits = 0;
        if (this.databaseExpression != null) {
            tmp = this.databaseExpression.execute(databaseRoute);
            if ((long)tmp >= pow10[this.config.getDatabaseRoute().getSize()]) {
                throw new SequenceException("Overflow");
            }
            routeBits = tmp;
        }
        if (this.tableExpression != null) {
            if (routeBits != 0) {
                routeBits = (int)((long)routeBits * this.mulDatabase);
            }
            if ((long)(tmp = this.tableExpression.execute(tableRoute)) >= pow10[this.config.getTableRoute().getSize()]) {
                throw new SequenceException("Overflow");
            }
            routeBits += tmp;
        }
        long nextId = this.sequence.nextValue();
        if (this.routeSize != 0) {
            nextId = this.config.isPositionRight() ? nextId * this.mulRoute + (long)routeBits : (nextId += (long)routeBits * this.mulRoute);
        }
        return nextId;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }
}

