/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.util;

import com.taobao.tddl.common.jdbc.ParameterContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionUtils {
    public static StackTraceElement split = new StackTraceElement("------- one sql exceptions-----", "", "", 0);
    public static final String SQL_EXECUTION_ERROR_CONTEXT_LOG = "SQL_EXECUTION_ERROR_CONTEXT_LOG";
    private static final String SQL_EXECUTION_ERROR_CONTEXT_MESSAGE = "SQLException ,context is ";
    private static final Log log = LogFactory.getLog((String)"SQL_EXECUTION_ERROR_CONTEXT_LOG");

    public static void throwSQLException(List<SQLException> exceptions, String sql, List<Object> args) throws SQLException {
        if (exceptions != null && !exceptions.isEmpty()) {
            SQLException first = exceptions.get(0);
            if (sql != null) {
                log.info((Object)("TDDL SQL EXECUTE ERROR REPORTER:" + ExceptionUtils.getErrorContext(sql, args, SQL_EXECUTION_ERROR_CONTEXT_MESSAGE)), (Throwable)first);
            }
            int n = exceptions.size();
            for (int i = 1; i < n; ++i) {
                if (sql == null) continue;
                log.info((Object)("layer:" + n + "TDDL SQL EXECUTE ERROR REPORTER :" + ExceptionUtils.getErrorContext(sql, args, SQL_EXECUTION_ERROR_CONTEXT_MESSAGE)), (Throwable)exceptions.get(i));
            }
            throw ExceptionUtils.mergeException(exceptions);
        }
    }

    public static List<SQLException> appendToExceptionList(List<SQLException> list, SQLException sqlException) {
        if (list == null) {
            list = new LinkedList<SQLException>();
        }
        list.add(sqlException);
        return list;
    }

    public static List<SQLException> appendToExceptionList(List<SQLException> to, List<SQLException> from) {
        if (to == null) {
            to = new LinkedList<SQLException>();
        }
        if (null != from) {
            for (SQLException e : from) {
                to.add(e);
            }
        }
        return to;
    }

    public static SQLException mergeException(List<SQLException> exceptions) {
        SQLException first = exceptions.get(0);
        ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>(30 * exceptions.size());
        boolean hasSplit = false;
        for (StackTraceElement ste : first.getStackTrace()) {
            stes.add(ste);
            if (ste != split) continue;
            hasSplit = true;
        }
        if (!hasSplit) {
            stes.add(split);
        }
        SQLException current = first;
        int n = exceptions.size();
        for (int i = 1; i < n; ++i) {
            current = exceptions.get(i);
            hasSplit = false;
            for (StackTraceElement ste : current.getStackTrace()) {
                stes.add(ste);
                if (ste != split) continue;
                hasSplit = true;
            }
            if (hasSplit) continue;
            stes.add(split);
        }
        first.setStackTrace(stes.toArray(new StackTraceElement[stes.size()]));
        return first;
    }

    public static void throwSQLException(SQLException exception, String sql, List<Object> args) throws SQLException {
        if (sql != null) {
            log.info((Object)("TDDL SQL EXECUTE ERROR REPORTER:" + ExceptionUtils.getErrorContext(sql, args, SQL_EXECUTION_ERROR_CONTEXT_MESSAGE) + "nest Exceptions is " + exception.getMessage()), (Throwable)exception);
        }
        throw exception;
    }

    public static String getErrorContext(String sql, List<Object> arguments, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(sql).append("|||arguments:");
        ExceptionUtils.printArgument(arguments, sb);
        return sb.toString();
    }

    private static void printArgument(List<Object> parameters, StringBuilder sb) {
        int i = 0;
        if (parameters != null) {
            for (Object param : parameters) {
                sb.append("[index:").append(i).append("|parameter:").append(param).append("|typeclass:").append(param == null ? null : param.getClass().getName()).append("]");
                ++i;
            }
        } else {
            sb.append("[empty]");
        }
    }

    public static void throwSQLException(List<SQLException> exceptions, String sql, Map<Integer, ParameterContext> parameter) throws SQLException {
        if (exceptions != null && !exceptions.isEmpty()) {
            throw ExceptionUtils.mergeException(exceptions);
        }
    }

    public static void throwSQLException(SQLException exception, String sql, Map<Integer, ParameterContext> parameter) throws SQLException {
        if (sql != null) {
            log.info((Object)("TDDL SQL EXECUTE ERROR REPORTER:" + ExceptionUtils.getErrorContext(sql, parameter, SQL_EXECUTION_ERROR_CONTEXT_MESSAGE) + "nest Exceptions is " + exception.getMessage()), (Throwable)exception);
        }
        throw exception;
    }

    public static String getErrorContext(String sql, Map<Integer, ParameterContext> parameter, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(sql).append("|||arguments:");
        ExceptionUtils.printArgument(parameter, sb);
        return sb.toString();
    }

    private static void printArgument(Map<Integer, ParameterContext> parameter, StringBuilder sb) {
        int i = 0;
        if (parameter != null) {
            for (Map.Entry<Integer, ParameterContext> param : parameter.entrySet()) {
                sb.append("[index:").append(i).append("|parameter:").append(param).append("|typeclass:").append(param == null ? null : param.getClass().getName()).append("]");
                ++i;
            }
        } else {
            sb.append("[empty]");
        }
    }

    public static void printSQLExceptionToErrorLog(Log logger, String message, List<SQLException> sqlExceptions) {
        if (sqlExceptions != null && !sqlExceptions.isEmpty()) {
            for (SQLException sqlException : sqlExceptions) {
                logger.error((Object)message, (Throwable)sqlException);
            }
            sqlExceptions.clear();
        }
    }
}

