/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.util;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.util.TStringUtil;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeAND;
import com.taobao.tddl.interact.sqljep.ComparativeBaseList;
import com.taobao.tddl.interact.sqljep.ComparativeOR;
import com.taobao.tddl.util.HintParser;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.AdvanceCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.AdvancedDirectlyRouteCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.SimpleCondition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DBProxyThreadLocalHepler {
    private static final int INTEGER_TYPE = 1;
    private static final int BOOLEAN_TYPE = 2;
    private static final int ROUTE_CONDITION_TYPE = 3;
    private static final int ADVANCED_DIRECTLY_CLASS_TYPE = 1;
    private static final int DIRECTLY_CLASS_TYPE = 2;
    private static final int ADVANCE_CONDITION_CLASS_TYPE = 3;
    private static final int SIMPLE_CONDITION_CLASS_TYPE = 4;
    private static final int ROUTE_TYPE_FLUSH_ON_CLOSECONNECTION = 1;
    private static final int ROUTE_TYPE_FLUSH_ON_EXECUTE = 2;
    private static final String CONNECTION = "connection";
    private static final String EXECUTE = "execute";

    public static Map<String, String> dumpThreadLocal2StrMap() {
        ThreadLocalKey[] keyEnums = ThreadLocalKey.values();
        HashMap<String, String> threadLocals = new HashMap<String, String>(keyEnums.length);
        for (ThreadLocalKey keyEnum : keyEnums) {
            RouteCondition routeCondition;
            String threadLocalKey = keyEnum.getKey();
            String strData = DBProxyThreadLocalHepler.encodeThreadLocal(threadLocalKey);
            if (!StringUtil.isNotBlank((String)strData)) continue;
            threadLocals.put(threadLocalKey, strData);
            Object object = ThreadLocalMap.get((Object)threadLocalKey);
            if (!(object instanceof RouteCondition) || RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE != (routeCondition = (RouteCondition)object).getRouteType()) continue;
            ThreadLocalMap.put((Object)threadLocalKey, null);
        }
        return threadLocals;
    }

    public static void cleanOnCloseConnectionThreadLocal() {
        ThreadLocalKey[] keyEnums;
        for (ThreadLocalKey keyEnum : keyEnums = ThreadLocalKey.values()) {
            String threadLocalKey = keyEnum.getKey();
            Object object = ThreadLocalMap.get((Object)threadLocalKey);
            if (null == object) continue;
            if (object instanceof RouteCondition) {
                RouteCondition routeCondition = (RouteCondition)object;
                if (RouteCondition.ROUTE_TYPE.FLUSH_ON_CLOSECONNECTION != routeCondition.getRouteType()) continue;
                ThreadLocalMap.put((Object)threadLocalKey, null);
                continue;
            }
            ThreadLocalMap.put((Object)threadLocalKey, null);
        }
    }

    public static void setThreadLocal(String key, Object value) {
        ThreadLocalMap.put((Object)key, (Object)value);
    }

    public static String encodeThreadLocal(String key) {
        String strValue = null;
        ThreadLocalKey enumKey = ThreadLocalKey.getThreadLocalKey(key);
        Object objValue = ThreadLocalMap.get((Object)key);
        if (null == enumKey || null == objValue) {
            return strValue;
        }
        switch (enumKey.getType()) {
            case 1: {
                strValue = Integer.toString((Integer)objValue);
                break;
            }
            case 2: {
                strValue = Boolean.toString((Boolean)objValue);
                break;
            }
            case 3: {
                strValue = DBProxyThreadLocalHepler.encodeRouteCondition(objValue);
            }
        }
        return strValue;
    }

    public static Object decodeThreadLocal(String key, String strData) {
        Object object = null;
        ThreadLocalKey enumKey = ThreadLocalKey.getThreadLocalKey(key);
        if (null == enumKey || StringUtil.isBlank((String)strData)) {
            return object;
        }
        switch (enumKey.getType()) {
            case 1: {
                object = Integer.valueOf(strData);
                break;
            }
            case 2: {
                object = Boolean.valueOf(strData);
                break;
            }
            case 3: {
                object = DBProxyThreadLocalHepler.decodeRouteCondition(strData);
            }
        }
        return object;
    }

    private static String encodeRouteCondition(Object routeCondition) {
        String strCondition;
        block23: {
            strCondition = null;
            JSONObject jsonObject = new JSONObject();
            try {
                if (routeCondition instanceof DirectlyRouteCondition) {
                    DirectlyRouteCondition directlyRouteCondition = (DirectlyRouteCondition)routeCondition;
                    jsonObject.put("dbId", (Object)directlyRouteCondition.getDbRuleID());
                    if (RouteCondition.ROUTE_TYPE.FLUSH_ON_CLOSECONNECTION.toString().equals(directlyRouteCondition.getRouteType().toString())) {
                        jsonObject.put("routeType", 1);
                    } else if (RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE.toString().equals(directlyRouteCondition.getRouteType().toString())) {
                        jsonObject.put("routeType", 2);
                    }
                    jsonObject.put("virtualTableName", (Object)directlyRouteCondition.getVirtualTableName());
                    if (routeCondition.getClass() == DirectlyRouteCondition.class) {
                        jsonObject.put("classType", 2);
                        Set<String> tableSet = directlyRouteCondition.getTables();
                        if (null != tableSet && !tableSet.isEmpty()) {
                            JSONArray jsonTables = new JSONArray();
                            for (String table : tableSet) {
                                jsonTables.put((Object)table);
                            }
                            jsonObject.put("tables", (Object)jsonTables);
                        }
                    } else if (routeCondition.getClass() == AdvancedDirectlyRouteCondition.class) {
                        jsonObject.put("classType", 1);
                        AdvancedDirectlyRouteCondition advancedDirectlyRouteCondition = (AdvancedDirectlyRouteCondition)routeCondition;
                        Map<String, List<Map<String, String>>> shardTableMap = advancedDirectlyRouteCondition.getShardTableMap();
                        JSONObject jsonShardTableMap = new JSONObject();
                        for (Map.Entry<String, List<Map<String, String>>> entry : shardTableMap.entrySet()) {
                            jsonShardTableMap.put(entry.getKey(), (Collection)entry.getValue());
                        }
                        jsonObject.put("shardTableMap", (Object)jsonShardTableMap);
                    } else {
                        throw new RuntimeException("encodeRouteCondition Error not support RouteCondition type: " + routeCondition.getClass().getName());
                    }
                    strCondition = jsonObject.toString();
                    break block23;
                }
                if (routeCondition instanceof SimpleCondition) {
                    SimpleCondition simpleCondition = (SimpleCondition)routeCondition;
                    if (RouteCondition.ROUTE_TYPE.FLUSH_ON_CLOSECONNECTION.toString().equals(simpleCondition.getRouteType().toString())) {
                        jsonObject.put("routeType", 1);
                    } else if (RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE.toString().equals(simpleCondition.getRouteType().toString())) {
                        jsonObject.put("routeType", 2);
                    }
                    jsonObject.put("virtualTableName", (Object)simpleCondition.getVirtualTableName());
                    Map<String, Comparative> parameters = simpleCondition.getParameters();
                    if (null != parameters && !parameters.isEmpty()) {
                        JSONObject jsonParameters = new JSONObject();
                        for (Map.Entry<String, Comparative> entry : parameters.entrySet()) {
                            String encdeComparativeStr;
                            String paramKey = entry.getKey();
                            Comparative praramValue = entry.getValue();
                            if (!StringUtil.isNotBlank((String)paramKey) || null == praramValue || !StringUtil.isNotBlank((String)(encdeComparativeStr = DBProxyThreadLocalHepler.encodeComparative(praramValue)))) continue;
                            jsonParameters.put(paramKey, (Object)encdeComparativeStr);
                        }
                        jsonObject.put("parameters", (Object)jsonParameters);
                    }
                    if (routeCondition.getClass() == SimpleCondition.class) {
                        jsonObject.put("classType", 4);
                    } else if (routeCondition.getClass() == AdvanceCondition.class) {
                        jsonObject.put("classType", 3);
                    } else {
                        throw new RuntimeException("encodeRouteCondition Error not support RouteCondition type: " + routeCondition.getClass().getName());
                    }
                    strCondition = jsonObject.toString();
                    break block23;
                }
                throw new RuntimeException("encodeRouteCondition Error not support RouteCondition type: " + routeCondition.getClass().getName());
            }
            catch (JSONException e) {
                throw new RuntimeException("encodeRouteCondition Error !", e);
            }
        }
        return strCondition;
    }

    private static String encodeComparative(Comparative comparative) {
        StringBuilder sb = new StringBuilder();
        if (comparative instanceof ComparativeBaseList) {
            ComparativeBaseList comparativeBaseList = (ComparativeBaseList)comparative;
            List comparativeList = comparativeBaseList.getList();
            if (null != comparativeList && !comparativeList.isEmpty()) {
                if (comparativeBaseList instanceof ComparativeAND) {
                    sb.append("and").append("~");
                } else if (comparativeBaseList instanceof ComparativeOR) {
                    sb.append("or").append("~");
                } else {
                    throw new RuntimeException("encodeComparative not support ComparativeBaseList!");
                }
                for (Comparative comp : comparativeList) {
                    if (comp instanceof ComparativeBaseList) {
                        throw new RuntimeException("encodeComparative not support second ComparativeBaseList!");
                    }
                    String strValue = DBProxyThreadLocalHepler.encodeComparativeValue(comp);
                    if (null == strValue) continue;
                    sb.append(strValue).append(",");
                }
                String strData = sb.toString();
                if (StringUtil.isNotBlank((String)strData) && strData.lastIndexOf(",") != -1) {
                    return StringUtil.substringBeforeLast((String)strData, (String)",");
                }
            }
        } else {
            String strValue = DBProxyThreadLocalHepler.encodeComparativeValue(comparative);
            if (null != strValue) {
                sb.append(strValue);
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static String encodeComparativeValue(Comparative comp) {
        StringBuilder sb = new StringBuilder();
        Comparable compValue = comp.getValue();
        if (null != compValue) {
            if (compValue instanceof Integer) {
                sb.append(comp.getComparison()).append(";").append("i:").append((Integer)compValue);
            } else if (compValue instanceof Long) {
                sb.append(comp.getComparison()).append(";").append("l:").append((Long)compValue);
            } else if (compValue instanceof String) {
                sb.append(comp.getComparison()).append(";").append("s:").append((String)((Object)compValue));
            } else if (compValue instanceof Date) {
                sb.append(comp.getComparison()).append(";").append("d:").append(((Date)compValue).getTime());
            } else {
                throw new RuntimeException("encodeComparative not support ComparativeValue!");
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static RouteCondition decodeRouteCondition(String strData) {
        RouteCondition routeCondition = null;
        try {
            JSONObject jsonObject = new JSONObject(strData);
            int classType = jsonObject.getInt("classType");
            if (classType == 2 || classType == 1) {
                routeCondition = DBProxyThreadLocalHepler.decodeNoComparativeRouteCondition(jsonObject);
            } else if (classType == 4 || classType == 3) {
                routeCondition = DBProxyThreadLocalHepler.decodeComparativeRouteCondition(jsonObject);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("decodeRouteCondition Error !", e);
        }
        return routeCondition;
    }

    private static RouteCondition decodeComparativeRouteCondition(JSONObject jsonObject) throws JSONException {
        int classType = jsonObject.getInt("classType");
        SimpleCondition comparativeCondition = null;
        if (classType == 4) {
            comparativeCondition = new SimpleCondition();
        } else if (classType == 3) {
            comparativeCondition = new AdvanceCondition();
        } else {
            throw new RuntimeException("not Sport RouteCondition Type Error ! classType: " + classType);
        }
        DBProxyThreadLocalHepler.decodeVirtualTableName(comparativeCondition, jsonObject);
        DBProxyThreadLocalHepler.decodeRouteType(comparativeCondition, jsonObject);
        DBProxyThreadLocalHepler.decodeParameter(comparativeCondition, jsonObject);
        return comparativeCondition;
    }

    public static RouteCondition decodeComparativeRouteCondition4Outer(JSONObject jsonObject) throws JSONException {
        SimpleCondition comparativeCondition = new SimpleCondition();
        DBProxyThreadLocalHepler.decodeParameterForOuter(comparativeCondition, jsonObject);
        DBProxyThreadLocalHepler.decodeVirtualTableName(comparativeCondition, jsonObject);
        DBProxyThreadLocalHepler.decodeSpecifyInfo(comparativeCondition, jsonObject);
        return comparativeCondition;
    }

    private static void decodeSpecifyInfo(SimpleCondition condition, JSONObject jsonObject) throws JSONException {
        Integer max;
        Integer skip;
        if (DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, "skip") && (skip = Integer.valueOf(jsonObject.getString("skip"))) != null) {
            condition.setSkip(skip);
        }
        if (DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, "max") && (max = Integer.valueOf(jsonObject.getString("max"))) != null) {
            condition.setMax(max);
        }
    }

    private static void decodeParameter(SimpleCondition condition, JSONObject jsonObject) throws JSONException {
        JSONObject jsonParameters;
        if (DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, "parameters") && null != (jsonParameters = jsonObject.getJSONObject("parameters")) && jsonParameters.length() != 0) {
            Iterator keys = jsonParameters.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = jsonParameters.getString(key);
                if (!StringUtil.isNotBlank((String)value)) continue;
                if (StringUtil.contains((String)value, (String)"~")) {
                    String[] compValues;
                    String compStr = StringUtil.substringAfter((String)value, (String)"~");
                    String opStr = StringUtil.substringBefore((String)value, (String)"~");
                    if (!StringUtil.isNotBlank((String)compStr) || !StringUtil.isNotBlank((String)opStr)) continue;
                    ComparativeOR comparativeBaseList = null;
                    if ("or".endsWith(opStr)) {
                        comparativeBaseList = new ComparativeOR();
                    } else if ("and".endsWith(opStr)) {
                        comparativeBaseList = new ComparativeAND();
                    } else {
                        throw new RuntimeException("decodeComparative not support ComparativeBaseList key: " + key + " str:" + value);
                    }
                    for (String compValue : compValues = StringUtil.split((String)compStr, (String)",")) {
                        Comparative comparative = DBProxyThreadLocalHepler.decodeComparative(compValue);
                        if (null == comparative) continue;
                        comparativeBaseList.addComparative(comparative);
                    }
                    condition.put(key, (Comparable<?>)comparativeBaseList);
                    continue;
                }
                Comparative comparative = DBProxyThreadLocalHepler.decodeComparative(value);
                if (null == comparative) continue;
                condition.put(key, (Comparable<?>)comparative);
            }
        }
    }

    public static void decodeParameterForOuter(SimpleCondition condition, JSONObject jsonObject) throws JSONException {
        String parametersString = DBProxyThreadLocalHepler.jsonContainsKeyAndValueNotBlank(jsonObject, "parameters");
        if (parametersString == null) {
            throw new RuntimeException("hint contains no property 'parameters'.");
        }
        JSONArray jsonParameters = new JSONArray(parametersString);
        if (jsonParameters.length() != 0) {
            for (int i = 0; i < jsonParameters.length(); ++i) {
                String value = jsonParameters.getString(i).toLowerCase();
                if (!StringUtil.isNotBlank((String)value)) continue;
                boolean containsAnd = StringUtil.contains((String)value, (String)" and ");
                boolean containsOr = StringUtil.contains((String)value, (String)" or ");
                if (containsAnd || containsOr) {
                    String op;
                    ComparativeOR comparativeBaseList = null;
                    if (containsOr) {
                        comparativeBaseList = new ComparativeOR();
                        op = " or ";
                    } else if (containsAnd) {
                        comparativeBaseList = new ComparativeAND();
                        op = " and ";
                    } else {
                        throw new RuntimeException("decodeComparative not support ComparativeBaseList value:" + value);
                    }
                    String[] compValues = TStringUtil.twoPartSplit((String)value, (String)op);
                    String key = null;
                    for (String compValue : compValues) {
                        Comparative comparative = DBProxyThreadLocalHepler.decodeComparativeForOuter(compValue);
                        if (null != comparative) {
                            comparativeBaseList.addComparative(comparative);
                        }
                        String temp = DBProxyThreadLocalHepler.getComparativeKey(compValue).trim();
                        if (null == key) {
                            key = temp;
                            continue;
                        }
                        if (temp.equals(key)) continue;
                        throw new RuntimeException("decodeComparative not support ComparativeBaseList value:" + value);
                    }
                    condition.put(key, (Comparable<?>)comparativeBaseList);
                    continue;
                }
                String key = DBProxyThreadLocalHepler.getComparativeKey(value);
                Comparative comparative = DBProxyThreadLocalHepler.decodeComparativeForOuter(value);
                if (null == comparative) continue;
                condition.put(key, (Comparable<?>)comparative);
            }
        }
    }

    public static String getComparativeKey(String compValue) {
        int value = Comparative.getComparisonByCompleteString((String)compValue);
        String splitor = Comparative.getComparisonName((int)value);
        int index = compValue.indexOf(splitor);
        return StringUtil.substring((String)compValue, (int)0, (int)index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Comparative decodeComparative(String compValue) {
        Comparative comparative = null;
        String strFuction = StringUtil.substringBefore((String)compValue, (String)";");
        String[] data = StringUtil.split((String)StringUtil.substringAfter((String)compValue, (String)";"), (String)":");
        if (!StringUtil.isNumeric((String)strFuction)) throw new RuntimeException("decodeComparative Error datsStr: " + compValue);
        if (null == data) throw new RuntimeException("decodeComparative Error datsStr: " + compValue);
        if (data.length != 2) throw new RuntimeException("decodeComparative Error datsStr: " + compValue);
        int fuction = Integer.valueOf(StringUtil.substringBefore((String)compValue, (String)";"));
        String dataType = data[0];
        String dataValue = data[1];
        if ("i".equals(dataType)) {
            return new Comparative(fuction, (Comparable)Integer.valueOf(dataValue));
        }
        if ("l".equals(dataType)) {
            return new Comparative(fuction, (Comparable)Long.valueOf(dataValue));
        }
        if ("s".equals(dataType)) {
            return new Comparative(fuction, (Comparable)((Object)dataValue));
        }
        if (!"d".equals(dataType)) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
        return new Comparative(fuction, (Comparable)new Date(Long.valueOf(dataValue)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Comparative decodeComparativeForOuter(String compValue) {
        Comparative comparative = null;
        int value = Comparative.getComparisonByCompleteString((String)compValue);
        String splitor = Comparative.getComparisonName((int)value);
        int size = splitor.length();
        int index = compValue.indexOf(splitor);
        String[] valueAndType = StringUtil.split((String)StringUtil.substring((String)compValue, (int)(index + size)), (String)";");
        if (null == valueAndType) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
        if (valueAndType.length != 2) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
        if ("i".equals(valueAndType[1].trim())) {
            return new Comparative(value, (Comparable)Integer.valueOf(valueAndType[0]));
        }
        if ("l".equals(valueAndType[1].trim())) {
            return new Comparative(value, (Comparable)Long.valueOf(valueAndType[0]));
        }
        if ("s".equals(valueAndType[1].trim())) {
            return new Comparative(value, (Comparable)((Object)valueAndType[0]));
        }
        if ("d".equals(valueAndType[1].trim())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return new Comparative(value, (Comparable)sdf.parse(valueAndType[0]));
            }
            catch (ParseException e) {
                throw new RuntimeException("only support 'yyyy-MM-dd',now date string is:" + valueAndType[0]);
            }
        }
        if ("int".equals(valueAndType[1].trim())) {
            return new Comparative(value, (Comparable)Integer.valueOf(valueAndType[0]));
        }
        if ("long".equals(valueAndType[1].trim())) {
            return new Comparative(value, (Comparable)Long.valueOf(valueAndType[0]));
        }
        if ("string".equals(valueAndType[1].trim())) {
            return new Comparative(value, (Comparable)((Object)valueAndType[0]));
        }
        if (!"date".equals(valueAndType[1].trim())) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return new Comparative(value, (Comparable)sdf.parse(valueAndType[0]));
        }
        catch (ParseException e) {
            throw new RuntimeException("only support 'yyyy-MM-dd',now date string is:" + valueAndType[0]);
        }
    }

    private static RouteCondition decodeNoComparativeRouteCondition(JSONObject jsonObject) throws JSONException {
        DirectlyRouteCondition directlyRouteCondition = null;
        int classType = jsonObject.getInt("classType");
        if (2 == classType) {
            directlyRouteCondition = new DirectlyRouteCondition();
            if (DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, "tables")) {
                directlyRouteCondition = DBProxyThreadLocalHepler.generateDirectlyRouteCondition(jsonObject);
            }
        } else if (1 == classType) {
            AdvancedDirectlyRouteCondition advancedDirectlyRouteCondition = new AdvancedDirectlyRouteCondition();
            if (DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, "shardTableMap")) {
                advancedDirectlyRouteCondition = DBProxyThreadLocalHepler.generateAdvancedDirectlyRouteCondition(jsonObject);
            }
            directlyRouteCondition = advancedDirectlyRouteCondition;
        } else {
            throw new RuntimeException("not Sport RouteCondition Type Error ! classType: " + classType);
        }
        DBProxyThreadLocalHepler.decodeDbId(directlyRouteCondition, jsonObject);
        DBProxyThreadLocalHepler.decodeVirtualTableName(directlyRouteCondition, jsonObject);
        DBProxyThreadLocalHepler.decodeRouteType(directlyRouteCondition, jsonObject);
        DirectlyRouteCondition routeCondition = directlyRouteCondition;
        return routeCondition;
    }

    public static RouteCondition decodeNoComparativeRouteCondition4Outer(JSONObject jsonObject, HintParser.RouteMethod type) throws JSONException {
        DirectlyRouteCondition directlyRouteCondition = null;
        if (type.equals((Object)HintParser.RouteMethod.executeByDB)) {
            directlyRouteCondition = new DirectlyRouteCondition();
            DBProxyThreadLocalHepler.decodeDbId(directlyRouteCondition, jsonObject);
        } else if (type.equals((Object)HintParser.RouteMethod.executeByDBAndTab)) {
            directlyRouteCondition = DBProxyThreadLocalHepler.generateDirectlyRouteCondition(jsonObject);
            DBProxyThreadLocalHepler.decodeDbId(directlyRouteCondition, jsonObject);
            DBProxyThreadLocalHepler.decodeVirtualTableName(directlyRouteCondition, jsonObject);
        } else if (type.equals((Object)HintParser.RouteMethod.executeByDBAndMutiReplace)) {
            directlyRouteCondition = DBProxyThreadLocalHepler.generateAdvancedDirectlyRouteCondition(jsonObject);
        }
        return directlyRouteCondition;
    }

    private static DirectlyRouteCondition generateDirectlyRouteCondition(JSONObject jsonObject) throws JSONException {
        DirectlyRouteCondition directlyRouteCondition = new DirectlyRouteCondition();
        String tableString = DBProxyThreadLocalHepler.jsonContainsKeyAndValueNotBlank(jsonObject, "tables");
        if (tableString == null) {
            throw new RuntimeException("hint contains no property 'tables'.");
        }
        JSONArray jsonTables = new JSONArray(tableString);
        if (jsonTables.length() > 0) {
            HashSet<String> tables = new HashSet<String>(jsonTables.length());
            for (int i = 0; i < jsonTables.length(); ++i) {
                tables.add(jsonTables.getString(i));
            }
            directlyRouteCondition.setTables(tables);
        }
        return directlyRouteCondition;
    }

    private static AdvancedDirectlyRouteCondition generateAdvancedDirectlyRouteCondition(JSONObject jsonObject) throws JSONException {
        String tableMapString = DBProxyThreadLocalHepler.jsonContainsKeyAndValueNotBlank(jsonObject, "shardTableMap");
        if (tableMapString == null) {
            throw new RuntimeException("hint contains no property 'shardTableMap'.");
        }
        AdvancedDirectlyRouteCondition advancedDirectlyRouteCondition = new AdvancedDirectlyRouteCondition();
        JSONObject jsonShardTableMap = new JSONObject(tableMapString);
        if (jsonShardTableMap.length() > 0) {
            Iterator shardTableMapKeys = jsonShardTableMap.keys();
            HashMap<String, List<Map<String, String>>> shardTableMap = new HashMap<String, List<Map<String, String>>>(jsonShardTableMap.length());
            while (shardTableMapKeys.hasNext()) {
                String key = (String)shardTableMapKeys.next();
                JSONArray jsonTableList = jsonShardTableMap.getJSONArray(key);
                if (null == jsonTableList || jsonTableList.length() <= 0) continue;
                ArrayList tableMapList = new ArrayList(jsonTableList.length());
                for (int i = 0; i < jsonTableList.length(); ++i) {
                    String jsonTabStr = jsonTableList.getString(i);
                    if (!StringUtil.isNotBlank((String)jsonTabStr)) continue;
                    JSONObject jsonTableMap = new JSONObject(jsonTabStr);
                    HashMap<String, String> tableMap = new HashMap<String, String>(jsonTableMap.length());
                    Iterator tableMapKey = jsonTableMap.keys();
                    while (tableMapKey.hasNext()) {
                        String tableKey = (String)tableMapKey.next();
                        String tableValue = jsonTableMap.getString(tableKey);
                        if (!StringUtil.isNotBlank((String)tableValue)) continue;
                        tableMap.put(tableKey, tableValue);
                    }
                    tableMapList.add(tableMap);
                }
                shardTableMap.put(key, tableMapList);
            }
            advancedDirectlyRouteCondition.setShardTableMap(shardTableMap);
        }
        return advancedDirectlyRouteCondition;
    }

    private static void decodeDbId(DirectlyRouteCondition condition, JSONObject jsonObject) throws JSONException {
        String dbId = DBProxyThreadLocalHepler.jsonContainsKeyAndValueNotBlank(jsonObject, "dbId");
        if (dbId == null) {
            throw new RuntimeException("hint contains no property 'dbId'.");
        }
        condition.setDBId(dbId);
    }

    private static void decodeVirtualTableName(RouteCondition condition, JSONObject jsonObject) throws JSONException {
        String virtualTableName = DBProxyThreadLocalHepler.jsonContainsKeyAndValueNotBlank(jsonObject, "virtualTableName");
        if (virtualTableName == null) {
            throw new RuntimeException("hint contains no property 'virtualTableName'.");
        }
        condition.setVirtualTableName(virtualTableName);
    }

    private static void decodeRouteType(RouteCondition condition, JSONObject jsonObject) throws JSONException {
        if (DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, "routeType")) {
            int routeType = jsonObject.getInt("routeType");
            if (routeType == 1) {
                condition.setRouteType(RouteCondition.ROUTE_TYPE.FLUSH_ON_CLOSECONNECTION);
            } else if (routeType == 2) {
                condition.setRouteType(RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
            }
        }
    }

    private static String jsonContainsKeyAndValueNotBlank(JSONObject jsonObject, String key) throws JSONException {
        if (!DBProxyThreadLocalHepler.jsonContainsKey(jsonObject, key)) {
            return null;
        }
        String value = jsonObject.getString(key);
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    private static boolean jsonContainsKey(JSONObject jsonObject, String key) {
        boolean res = false;
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String itKey = (String)it.next();
            if (!StringUtil.equals((String)itKey, (String)key)) continue;
            res = true;
            break;
        }
        return res;
    }

    private static enum ThreadLocalKey {
        DATASOURCE_INDEX("DATASOURCE_INDEX", 1),
        PARALLEL_EXECUTE("PARALLEL_EXECUTE", 2),
        IS_EXIST_QUITE("IS_EXIST_QUITE", 2),
        DB_SELECTOR("DB_SELECTOR", 3),
        ROUTE_CONDITION("ROUTE_CONDITION", 3),
        RULE_SELECTOR("RULE_SELECTOR", 3);

        private String key;
        private int type;

        private ThreadLocalKey(String key, int type) {
            this.key = key;
            this.type = type;
        }

        public static ThreadLocalKey getThreadLocalKey(String key) {
            ThreadLocalKey[] ThreadLocalKeys;
            ThreadLocalKey enumKey = null;
            for (ThreadLocalKey threadLocalKey : ThreadLocalKeys = ThreadLocalKey.values()) {
                if (!threadLocalKey.getKey().equals(key)) continue;
                enumKey = threadLocalKey;
                break;
            }
            return enumKey;
        }

        public String getKey() {
            return this.key;
        }

        public int getType() {
            return this.type;
        }
    }
}

