/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.util;

import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeAND;
import com.taobao.tddl.interact.sqljep.ComparativeOR;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.AdvanceCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.AdvancedDirectlyRouteCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.SimpleCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteHelper {
    public static final int EQ = 3;
    public static final int GT = 1;
    public static final int LT = 7;
    public static final int GTE = 2;
    public static final int LTE = 8;

    public static void executeByDBAndTab(String dbIndex, String logicTable, RouteCondition.ROUTE_TYPE routeType, String ... tables) {
        DirectlyRouteCondition condition = new DirectlyRouteCondition();
        if (tables == null) {
            throw new IllegalArgumentException("tables is null");
        }
        for (String table : tables) {
            condition.addATable(table);
        }
        condition.setVirtualTableName(logicTable);
        condition.setDBId(dbIndex);
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"DB_SELECTOR", (Object)condition);
    }

    public static void executeByDBAndTab(String dbIndex, String logicTable, String ... table) {
        RouteHelper.executeByDBAndTab(dbIndex, logicTable, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE, table);
    }

    public static void executeByDBAndTab(String dbIndex, Map<String, String> tableMap) {
        RouteHelper.executeByDBAndTab(dbIndex, tableMap, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void executeByDBAndTab(String dbIndex, Map<String, String> tableMap, RouteCondition.ROUTE_TYPE routeType) {
        AdvancedDirectlyRouteCondition condition = new AdvancedDirectlyRouteCondition();
        condition.setDBId(dbIndex);
        HashMap<String, List<Map<String, String>>> directlyShardTableMap = new HashMap<String, List<Map<String, String>>>(2);
        ArrayList<Map<String, String>> tables2BReplaced = new ArrayList<Map<String, String>>(1);
        tables2BReplaced.add(tableMap);
        directlyShardTableMap.put(dbIndex, tables2BReplaced);
        condition.setShardTableMap(directlyShardTableMap);
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"DB_SELECTOR", (Object)condition);
    }

    public static void executeByDBAndTab(String dbIndex, List<Map<String, String>> tableMap, RouteCondition.ROUTE_TYPE routeType) {
        AdvancedDirectlyRouteCondition condition = new AdvancedDirectlyRouteCondition();
        condition.setDBId(dbIndex);
        HashMap<String, List<Map<String, String>>> directlyShardTableMap = new HashMap<String, List<Map<String, String>>>(2);
        directlyShardTableMap.put(dbIndex, tableMap);
        condition.setShardTableMap(directlyShardTableMap);
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"DB_SELECTOR", (Object)condition);
    }

    public static void executeByDBAndTab(String dbIndex, List<Map<String, String>> tableMap) {
        RouteHelper.executeByDBAndTab(dbIndex, tableMap, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void executeByDBAndTab(Map<String, List<Map<String, String>>> tableMap, RouteCondition.ROUTE_TYPE routeType) {
        AdvancedDirectlyRouteCondition condition = new AdvancedDirectlyRouteCondition();
        condition.setShardTableMap(tableMap);
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"DB_SELECTOR", (Object)condition);
    }

    public static void executeByDBAndTab(Map<String, List<Map<String, String>>> tableMap) {
        RouteHelper.executeByDBAndTab(tableMap, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void executeByDB(String dbIndex, RouteCondition.ROUTE_TYPE routeType) {
        DirectlyRouteCondition condition = new DirectlyRouteCondition();
        condition.setDBId(dbIndex);
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"DB_SELECTOR", (Object)condition);
    }

    public static void executeByDB(String dbIndex) {
        RouteHelper.executeByDB(dbIndex, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void selectKey(String selector) {
        RouteHelper.executeByRule(selector, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void executeByRule(String ruleKey, RouteCondition.ROUTE_TYPE routeType) {
        DirectlyRouteCondition condition = new DirectlyRouteCondition();
        condition.setDBId(ruleKey);
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"RULE_SELECTOR", (Object)condition);
    }

    public static void selectKey(String selector, RouteCondition.ROUTE_TYPE routeType) {
        RouteHelper.executeByRule(selector, routeType);
    }

    public static void executeByCondition(String logicTable, String key, Comparable<?> comp) {
        RouteHelper.executeByCondition(logicTable, key, comp, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void executeByCondition(String logicTable, String key, Comparable<?> comp, RouteCondition.ROUTE_TYPE routeType) {
        SimpleCondition simpleCondition = new SimpleCondition();
        simpleCondition.setVirtualTableName(logicTable);
        simpleCondition.put(key, comp);
        simpleCondition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"ROUTE_CONDITION", (Object)simpleCondition);
    }

    public static void executeWithParallel(boolean useParallel) {
        ThreadLocalMap.put((Object)"PARALLEL_EXECUTE", (Object)useParallel);
    }

    public static void executeByCondition(String logicTable, String key, Comparable<?> comp, String ruleSelector) {
        RouteHelper.executeByCondition(logicTable, key, comp);
        RouteHelper.selectKey(ruleSelector);
    }

    public static void executeByCondition(String logicTable, String key, Comparable<?> comp, String ruleSelector, RouteCondition.ROUTE_TYPE routeType) {
        RouteHelper.executeByCondition(logicTable, key, comp, routeType);
        RouteHelper.selectKey(ruleSelector, routeType);
    }

    public static void executeByAdvancedCondition(String logicTable, Map<String, Comparable<?>> param, RouteCondition.ROUTE_TYPE routeType) {
        AdvanceCondition condition = new AdvanceCondition();
        condition.setVirtualTableName(logicTable);
        for (Map.Entry<String, Comparable<?>> entry : param.entrySet()) {
            condition.put(entry.getKey(), entry.getValue());
        }
        condition.setRouteType(routeType);
        ThreadLocalMap.put((Object)"ROUTE_CONDITION", (Object)condition);
    }

    public static void executeByAdvancedCondition(String logicTable, Map<String, Comparable<?>> param) {
        RouteHelper.executeByAdvancedCondition(logicTable, param, RouteCondition.ROUTE_TYPE.FLUSH_ON_EXECUTE);
    }

    public static void executeByAdvancedCondition(String logicTable, Map<String, Comparable<?>> param, String ruleSelector) {
        RouteHelper.executeByAdvancedCondition(logicTable, param);
        RouteHelper.selectKey(ruleSelector);
    }

    public static void executeByAdvancedCondition(String logicTable, Map<String, Comparable<?>> param, String ruleSelector, RouteCondition.ROUTE_TYPE routeType) {
        RouteHelper.executeByAdvancedCondition(logicTable, param, routeType);
        RouteHelper.selectKey(ruleSelector, routeType);
    }

    public static Comparative or(Comparative parent, Comparative target) {
        if (parent == null) {
            ComparativeOR or = new ComparativeOR();
            or.addComparative(target);
            return or;
        }
        if (parent instanceof ComparativeOR) {
            ((ComparativeOR)parent).addComparative(target);
            return parent;
        }
        ComparativeOR or = new ComparativeOR();
        or.addComparative(parent);
        or.addComparative(target);
        return or;
    }

    public static Comparative and(Comparative parent, Comparative target) {
        if (parent == null) {
            ComparativeAND and = new ComparativeAND();
            and.addComparative(target);
            return and;
        }
        if (parent instanceof ComparativeAND) {
            ComparativeAND and = (ComparativeAND)parent;
            if (and.getList().size() == 1) {
                and.addComparative(target);
                return and;
            }
            ComparativeAND andNew = new ComparativeAND();
            andNew.addComparative((Comparative)and);
            andNew.addComparative(target);
            return andNew;
        }
        ComparativeAND and = new ComparativeAND();
        and.addComparative(parent);
        and.addComparative(target);
        return and;
    }
}

