/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sorter;

import com.taobao.tddl.client.jdbc.sorter.ExceptionSorter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class MySQLExceptionSorter
implements ExceptionSorter,
Serializable {
    private static final long serialVersionUID = 2375890129763721017L;
    private static List<ExceptionSorter> externalExceptionSorters;

    @Override
    public boolean isExceptionFatal(SQLException e) {
        int loopCount = 20;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            SQLException sqlException;
            if (!(cause instanceof SQLException) || !this.isExceptionFatal0(sqlException = cause)) continue;
            return true;
        }
        return false;
    }

    private boolean isExceptionFatal0(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState != null && sqlState.startsWith("08")) {
            return true;
        }
        switch (e.getErrorCode()) {
            case 1004: 
            case 1005: 
            case 1015: 
            case 1021: 
            case 1037: 
            case 1038: 
            case 1040: 
            case 1041: 
            case 1042: 
            case 1043: 
            case 1045: 
            case 1047: 
            case 1081: 
            case 1129: 
            case 1130: {
                return true;
            }
        }
        String error_text = e.getMessage();
        if ("no datasource!".equals(error_text) || "no alive datasource".equals(error_text)) {
            return true;
        }
        if (externalExceptionSorters != null) {
            for (ExceptionSorter externalSorter : externalExceptionSorters) {
                if (!externalSorter.isExceptionFatal(e)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addExceptionSorter(ExceptionSorter sorter) {
        if (externalExceptionSorters == null) {
            externalExceptionSorters = new LinkedList<ExceptionSorter>();
        }
        externalExceptionSorters.add(sorter);
    }
}

