/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc.sorter;

import com.taobao.tddl.client.jdbc.sorter.ExceptionSorter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class OracleExceptionSorter
implements ExceptionSorter,
Serializable {
    private static final long serialVersionUID = 573723525408205079L;
    private static List<ExceptionSorter> externalExceptionSorters;

    @Override
    public boolean isExceptionFatal(SQLException e) {
        int loopCount = 20;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            SQLException sqlException;
            if (!(cause instanceof SQLException) || !this.isExceptionFatal0(sqlException = cause)) continue;
            return true;
        }
        return false;
    }

    public boolean isExceptionFatal0(SQLException e) {
        int error_code = Math.abs(e.getErrorCode());
        if (error_code == 28 || error_code == 600 || error_code == 1012 || error_code == 1014 || error_code == 1033 || error_code == 1034 || error_code == 1035 || error_code == 1089 || error_code == 1090 || error_code == 1092 || error_code == 1094 || error_code == 2396 || error_code == 3106 || error_code == 3111 || error_code == 3113 || error_code == 3114 || error_code >= 12100 && error_code <= 12299 || error_code == 17002 || error_code == 17008) {
            return true;
        }
        if (e.getMessage() == null) {
            return false;
        }
        String error_text = e.getMessage().toUpperCase();
        if ((error_code < 20000 || error_code >= 21000) && ("NO DATASOURCE!".equals(error_text) || "NO ALIVE DATASOURCE".equals(error_text) || error_text.indexOf("SOCKET") > -1 || error_text.indexOf("CONNECTION HAS ALREADY BEEN CLOSED") > -1 || error_text.indexOf("BROKEN PIPE") > -1 || error_text.indexOf("TNS") > -1 && error_text.indexOf("ORA-") > -1)) {
            return true;
        }
        if (externalExceptionSorters != null) {
            for (ExceptionSorter externalSorter : externalExceptionSorters) {
                if (!externalSorter.isExceptionFatal(e)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addExceptionSorter(ExceptionSorter sorter) {
        if (externalExceptionSorters == null) {
            externalExceptionSorters = new LinkedList<ExceptionSorter>();
        }
        externalExceptionSorters.add(sorter);
    }
}

