/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadLocalMap {
    private static final Log log = LogFactory.getLog(ThreadLocalMap.class);
    protected static final ThreadLocal<Map<Object, Object>> threadContext = new MapThreadLocal();

    private ThreadLocalMap() {
    }

    public static void put(Object key, Object value) {
        ThreadLocalMap.getContextMap().put(key, value);
    }

    public static Object remove(Object key) {
        return ThreadLocalMap.getContextMap().remove(key);
    }

    public static Object get(Object key) {
        return ThreadLocalMap.getContextMap().get(key);
    }

    public static boolean containsKey(Object key) {
        return ThreadLocalMap.getContextMap().containsKey(key);
    }

    protected static Map<Object, Object> getContextMap() {
        return threadContext.get();
    }

    public static void reset() {
        ThreadLocalMap.getContextMap().clear();
    }

    private static class MapThreadLocal
    extends ThreadLocal<Map<Object, Object>> {
        private MapThreadLocal() {
        }

        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>(){
                private static final long serialVersionUID = 3637958959138295593L;

                @Override
                public Object put(Object key, Object value) {
                    if (log.isDebugEnabled()) {
                        if (this.containsKey(key)) {
                            log.debug((Object)("Overwritten attribute to thread context: " + key + " = " + value));
                        } else {
                            log.debug((Object)("Added attribute to thread context: " + key + " = " + value));
                        }
                    }
                    return super.put(key, value);
                }
            };
        }
    }
}

