/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import com.alibaba.common.lang.io.ByteArrayInputStream;
import com.taobao.tddl.common.config.ConfigDataHandler;
import com.taobao.tddl.common.config.ConfigDataHandlerFactory;
import com.taobao.tddl.common.config.ConfigDataListener;
import com.taobao.tddl.common.config.impl.DefaultConfigDataHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigServerHelper {
    private static final Log log = LogFactory.getLog(ConfigServerHelper.class);
    public static final int SUBSCRIBE_REGISTER_WAIT_TIME = 30000;
    public static final String DATA_ID_PREFIX = "com.taobao.tddl.v1_";
    public static final String DATA_ID_TDDL_SHARD_RULE = "com.taobao.tddl.v1_{0}_shardrule";
    public static final String DATA_ID_REPLICATION_SWITCH = "com.taobao.tddl.v1_{0}_replication.switch";
    public static final String DATA_ID_DBINFO_DBROLE = "com.taobao.dbinfo.dbrole.v1";
    public static final String DATA_ID_DB_GROUP_KEYS = "com.taobao.tddl.v1_{0}_dbgroups";
    public static final String DATA_ID_REPLICATION = "com.taobao.tddl.v1_{0}_replication";
    public static final String DATA_ID_SYNCLOG_DBSET = "com.taobao.tddl.v1_{0}_synclog.dbset";
    public static final String DATA_ID_SYNCLOG_DBWEIGHT = "com.taobao.tddl.v1_{0}_synclog.dbweight";
    public static final String DATA_ID_APP_DBWEIGHT = "com.taobao.tddl.v1_{0}.dbweight";
    public static final String DATA_ID_GLOBAL_DBINFO = "com.taobao.tddl.v1_{0}.global.dbinfo";
    public static final String DATA_ID_TDDL_CLIENT_CONFIG = "com.taobao.tddl.v1_{0}_tddlconfig";
    private static volatile ConfigDataHandlerFactory cdhf;
    private static final long DIAMOND_FIRST_DATA_TIMEOUT = 15000L;

    public static Object subscribeShardRuleConfig(String appName, DataListener listener) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_TDDL_SHARD_RULE).format(new Object[]{appName});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeAppDbWeight(String appName, DataListener listener) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_APP_DBWEIGHT).format(new Object[]{appName});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeReplicationConfig(String appName, DataListener listener) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_REPLICATION).format(new Object[]{appName});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeReplicationSwitch(String appName, DataListener listener) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_REPLICATION_SWITCH).format(new Object[]{appName});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeSyncLogDbConfig(String syncServerID, DataListener listener) {
        if (syncServerID == null || syncServerID.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u8865\u507f\u670d\u52a1\u5668ID\uff1asyncServerID");
        }
        String dataId = new MessageFormat(DATA_ID_SYNCLOG_DBSET).format(new Object[]{syncServerID});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeSyncLogDbWeight(String syncServerID, DataListener listener) {
        if (syncServerID == null || syncServerID.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u8865\u507f\u670d\u52a1\u5668ID\uff1asyncServerID");
        }
        String dataId = new MessageFormat(DATA_ID_SYNCLOG_DBWEIGHT).format(new Object[]{syncServerID});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeTDDLConfig(String appName, DataListener listener) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_TDDL_CLIENT_CONFIG).format(new Object[]{appName});
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    private static String getCallerClassName() {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        return stes[stes.length - 1].getClassName();
    }

    public static Object subscribeDbInofDbRoleDb(DataListener listener) {
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), DATA_ID_DBINFO_DBROLE, listener);
    }

    public static Object subscribePersistentData(String dataId, DataListener listener) {
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribeData(String dataId, DataListener listener) {
        return ConfigServerHelper.subscribePersistentData(ConfigServerHelper.getCallerClassName(), dataId, listener);
    }

    public static Object subscribePersistentData(String subscriberName, String dataId, final DataListener listener) {
        cdhf = new DefaultConfigDataHandlerFactory();
        ConfigDataHandler matrixHandler = cdhf.getConfigDataHandler(dataId, null);
        String datas = matrixHandler.getData(15000L, "firstCache");
        log.warn((Object)(dataId + "'s firstData=" + datas));
        if (datas != null) {
            try {
                listener.onDataReceiveAtRegister(datas);
            }
            catch (Throwable t) {
                log.error((Object)("onDataReceiveAtRegister\u629b\u51fa\u5f02\u5e38\uff0cdataId:" + dataId), t);
            }
        }
        matrixHandler.addListener(new ConfigDataListener(){

            @Override
            public void onDataRecieved(String dataId, String data) {
                log.info((Object)("recieve data,data id:" + dataId + " data:" + data));
                listener.onDataReceive(data);
            }
        }, null);
        return datas;
    }

    public static Properties parseProperties(Object data, String msg) {
        Properties p;
        if (data == null) {
            log.warn((Object)(msg + "data == null"));
            return null;
        }
        if (data instanceof Properties) {
            p = (Properties)data;
        } else if (data instanceof String) {
            p = new Properties();
            try {
                p.load((InputStream)new ByteArrayInputStream(((String)data).getBytes()));
            }
            catch (IOException e) {
                log.error((Object)(msg + "\u65e0\u6cd5\u89e3\u6790\u63a8\u9001\u7684\u914d\u7f6e\uff1a" + data), (Throwable)e);
                return null;
            }
        } else {
            log.warn((Object)(msg + "\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b" + data));
            return null;
        }
        return p;
    }

    public static void publish(String dataId, Serializable data) {
        ConfigServerHelper.publish(dataId, data, null);
    }

    public static void publish(String dataId, Serializable data, String group) {
    }

    public static String getDBGroupsConfig(String appName) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_DB_GROUP_KEYS).format(new Object[]{appName});
        return dataId;
    }

    public static String getShardRuleConfig(String appName) {
        if (appName == null || appName.length() == 0) {
            throw new IllegalStateException("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u540d\u79f0appName");
        }
        String dataId = new MessageFormat(DATA_ID_TDDL_SHARD_RULE).format(new Object[]{appName});
        return dataId;
    }

    public static abstract class AbstractDataListener
    implements DataListener {
        @Override
        public void onDataReceiveAtRegister(Object data) {
            this.onDataReceive(data);
        }
    }

    public static interface DataListener {
        public void onDataReceiveAtRegister(Object var1);

        public void onDataReceive(Object var1);
    }

    public static enum TDDLConfigKey {
        statKeyRecordType,
        statKeyLeftCutLen,
        statKeyRightCutLen,
        statKeyExcludes,
        StatRealDbInWrapperDs,
        StatChannelMask,
        statDumpInterval,
        statCacheSize,
        statAtomSql,
        statKeyIncludes,
        SmoothValveProperties,
        CountPunisherProperties,
        sqlExecTimeOutMilli,
        atomSqlSamplingRate;

    }
}

