/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import com.taobao.tddl.common.ConfigServerHelper;
import com.taobao.tddl.common.util.StringXmlApplicationContext;
import groovy.lang.GroovyClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.codehaus.groovy.control.CompilationFailedException;

public class DynamicLog {
    private static final Log log = LogFactory.getLog(DynamicLog.class);
    private static final Map<String, DynamicLog> multiInstance = new HashMap<String, DynamicLog>();
    private String appName;
    private final Map<String, LogBuilder> buryPoints = new HashMap<String, LogBuilder>(0);
    private static final String buryPointsDataId = "com.taobao.tddl.v1_{0}_buryPoints";
    private ConfigServerHelper.DataListener listener = new ConfigServerHelper.AbstractDataListener(){

        @Override
        public void onDataReceive(Object data) {
            if (data != null) {
                DynamicLog.this.updateBuryPoints((String)data);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicLog getInstance(String appName) {
        DynamicLog instance = multiInstance.get(appName);
        if (instance == null) {
            Map<String, DynamicLog> map = multiInstance;
            synchronized (map) {
                instance = multiInstance.get(appName);
                if (instance == null) {
                    instance = new DynamicLog(appName);
                    multiInstance.put(appName, instance);
                }
            }
        }
        return instance;
    }

    public DynamicLog(String appName) {
        this.appName = appName;
        this.init();
    }

    public String build(String key, Object[] args) {
        return this.build(key, args, null);
    }

    public String build(String key, Object[] args, String defaultLog) {
        try {
            LogBuilder builer = this.buryPoints.get(key);
            if (builer == null) {
                return defaultLog;
            }
            return builer.build(args);
        }
        catch (Exception e) {
            log.error((Object)("LogBuilder.build() failed for key:" + key), (Throwable)e);
            return e.getMessage();
        }
    }

    private void init() {
        if (this.appName == null || "".equals(this.appName)) {
            log.warn((Object)"\u4e0d\u6307\u5b9aappName\u5219\u4e0d\u8ba2\u9605");
            return;
        }
        String dataId = new MessageFormat(buryPointsDataId).format(new Object[]{this.appName});
        Object first = ConfigServerHelper.subscribePersistentData(dataId, this.listener);
        if (first == null) {
            log.warn((Object)(dataId + "'s first data is null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuryPoints(String springXml) {
        StringXmlApplicationContext ctx = null;
        try {
            ctx = new StringXmlApplicationContext(springXml);
            Map scripts = ctx.getBeansOfType(String.class);
            for (Map.Entry e : scripts.entrySet()) {
                this.buryPoints.put((String)e.getKey(), DynamicLog.createBuilder((String)e.getValue()));
                log.warn((Object)("Set LogBuilder for buryPoint " + (String)e.getKey() + ":" + (String)e.getValue()));
            }
        }
        catch (Exception e) {
            log.error((Object)("Set LogBuilder failed. springXml=" + springXml), (Throwable)e);
        }
        finally {
            if (ctx != null) {
                ctx.destroy();
                ctx = null;
            }
        }
    }

    private static LogBuilder createBuilder(String script) {
        Class c_groovy;
        GroovyClassLoader loader = new GroovyClassLoader(DynamicLog.class.getClassLoader());
        String groovyScript = DynamicLog.completeGroovy(script);
        try {
            c_groovy = loader.parseClass(groovyScript);
        }
        catch (CompilationFailedException e) {
            throw new IllegalArgumentException(groovyScript, e);
        }
        try {
            return (LogBuilder)c_groovy.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("\u5b9e\u4f8b\u5316\u89c4\u5219\u5bf9\u8c61\u5931\u8d25", t);
        }
    }

    private static String completeGroovy(String script) {
        StringBuffer sb = new StringBuffer();
        sb.append("public class GroovyLogBuilder implements com.taobao.tddl.common.DynamicLog.LogBuilder{");
        sb.append("public String build(Object[] args){");
        sb.append(script);
        sb.append("}}");
        return sb.toString();
    }

    public void info(String key, Object[] args, String defaultLog, Log log) {
        String content = this.build(key, args, defaultLog);
        if (content != null && !"".equals(content)) {
            log.info((Object)content);
        }
    }

    public void debug(String key, Object[] args, String defaultLog, Log log) {
        String content = this.build(key, args, defaultLog);
        if (content != null && !"".equals(content)) {
            log.debug((Object)content);
        }
    }

    public void warn(String key, Object[] args, String defaultLog, Log log) {
        String content = this.build(key, args, defaultLog);
        if (content != null && !"".equals(content)) {
            log.warn((Object)content);
        }
    }

    public void info(String key, Object[] args, String defaultLog, Logger log) {
        String content = this.build(key, args, defaultLog);
        if (content != null && !"".equals(content)) {
            log.info((Object)content);
        }
    }

    public void debug(String key, Object[] args, String defaultLog, Logger log) {
        String content = this.build(key, args, defaultLog);
        if (content != null && !"".equals(content)) {
            log.debug((Object)content);
        }
    }

    public void warn(String key, Object[] args, String defaultLog, Logger log) {
        String content = this.build(key, args, defaultLog);
        if (content != null && !"".equals(content)) {
            log.warn((Object)content);
        }
    }

    public static interface LogBuilder {
        public String build(Object[] var1);
    }
}

