/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public final class GlobalCache {
    protected static final GlobalCache instance = new GlobalCache(4096);
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final ConcurrentHashMap<CacheRef, CacheRef> map;

    public static final GlobalCache getInstnace() {
        return instance;
    }

    public static final Object cache(Object obj) {
        Object old = instance.putIfAbsent(obj);
        return old != null ? old : obj;
    }

    public static final Object cacheIfAbsent(Object obj) {
        return instance.putIfAbsent(obj);
    }

    public static final boolean cached(Object obj) {
        return instance.contains(obj);
    }

    public static final void clean() {
        instance.clear();
    }

    public GlobalCache(int cacheCapacity) {
        this.map = new ConcurrentHashMap(cacheCapacity, 0.75f, 32);
    }

    private final void expungeCacheRef() {
        Reference<Object> cache;
        while ((cache = this.queue.poll()) != null) {
            this.map.remove((CacheRef)cache);
        }
    }

    public final Object putIfAbsent(Object obj) {
        CacheRef cacheRef = new CacheRef(obj, this.queue);
        while (true) {
            CacheRef oldRef;
            if ((oldRef = this.map.putIfAbsent(cacheRef, cacheRef)) == null) {
                this.expungeCacheRef();
                return null;
            }
            Object old = oldRef.get();
            if (old != null) {
                return old;
            }
            this.map.remove(oldRef);
        }
    }

    public final boolean contains(Object obj) {
        CacheRef cacheRef = new CacheRef(obj, this.queue);
        CacheRef oldRef = this.map.get(cacheRef);
        return oldRef != null && oldRef.get() != null;
    }

    public final Object get(Object obj) {
        CacheRef cacheRef = new CacheRef(obj, this.queue);
        CacheRef oldRef = this.map.get(cacheRef);
        return oldRef != null ? oldRef.get() : null;
    }

    public final Object remove(Object obj) {
        this.expungeCacheRef();
        CacheRef cacheRef = new CacheRef(obj, this.queue);
        CacheRef oldRef = this.map.remove(cacheRef);
        return oldRef != null ? oldRef.get() : null;
    }

    public final void clear() {
        this.map.clear();
    }

    protected static final class CacheRef
    extends WeakReference<Object> {
        final int hashCode;

        public CacheRef(Object obj, ReferenceQueue<Object> queue) {
            super(obj, queue);
            this.hashCode = obj.hashCode();
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object obj) {
            Object self;
            if (this == obj) {
                return true;
            }
            if (obj instanceof CacheRef) {
                obj = ((CacheRef)obj).get();
            }
            if ((self = this.get()) == obj) {
                return true;
            }
            if (self == null || obj == null) {
                return false;
            }
            return self.equals(obj);
        }
    }
}

