/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import com.taobao.tddl.common.monitor.DailyMaxRollingFileAppender;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggerInit {
    public static final Logger TDDL_LOG = Logger.getLogger((String)"TDDL_LOG");
    public static final Logger TDDL_SQL_LOG = Logger.getLogger((String)"TDDL_SQL_LOG");
    public static final Logger TDDL_MD5_TO_SQL_MAPPING = Logger.getLogger((String)"TDDL_MD5_TO_SQL_MAPPING");
    public static final Logger TDDL_Nagios_LOG = Logger.getLogger((String)"TDDL_Nagios_LOG");
    public static final Logger TDDL_Atom_Statistic_LOG = Logger.getLogger((String)"TDDL_Atom_Statistic_LOG");
    public static final Logger TDDL_Matrix_Statistic_LOG = Logger.getLogger((String)"TDDL_Matrix_Statistic_LOG");
    public static final Logger TDDL_Conn_Statistic_LOG = Logger.getLogger((String)"TDDL_Conn_Statistic_LOG");
    public static final Logger TDDL_Statistic_LOG = Logger.getLogger((String)"TDDL_Statistic_LOG");
    public static final Logger TDDL_Snapshot_LOG = Logger.getLogger((String)"TDDL_Snapshot_LOG");
    public static final Logger logger = TDDL_LOG;
    private static volatile boolean initOK = false;

    private static String getLogPath() {
        String path;
        File dir;
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith(File.separator)) {
            userHome = userHome + File.separator;
        }
        if (!(dir = new File(path = userHome + "logs" + File.separator + "tddl" + File.separator)).exists()) {
            dir.mkdirs();
        }
        return path;
    }

    private static Appender buildAppender(String name, String fileName, String pattern) {
        DailyRollingFileAppender appender = new DailyRollingFileAppender();
        appender.setName(name);
        appender.setAppend(true);
        appender.setEncoding("GBK");
        appender.setLayout((Layout)new PatternLayout(pattern));
        appender.setFile(new File(LoggerInit.getLogPath(), fileName).getAbsolutePath());
        appender.activateOptions();
        return appender;
    }

    private static Appender buildDailyMaxRollingAppender(String name, String fileName, String pattern, int maxBackupIndex) {
        DailyMaxRollingFileAppender appender = new DailyMaxRollingFileAppender();
        appender.setName(name);
        appender.setAppend(true);
        appender.setEncoding("GBK");
        appender.setLayout((Layout)new PatternLayout(pattern));
        appender.setDatePattern("'.'yyyy-MM-dd-HH");
        appender.setMaxBackupIndex(maxBackupIndex);
        appender.setFile(new File(LoggerInit.getLogPath(), fileName).getAbsolutePath());
        appender.activateOptions();
        return appender;
    }

    public static synchronized void initTddlLog() {
        if (initOK) {
            return;
        }
        initOK = true;
        Appender tddlAppender = LoggerInit.buildAppender("TDDL_Appender", "tddl.log", "%d %p [%c{10}] - %m%n");
        Appender md5sqlAppender = LoggerInit.buildAppender("TDDL_MD5_TO_SQL_Appender", "tddl.md5sql.log", "%d %p [%c{10}] - %m%n");
        Appender nagiosAppender = LoggerInit.buildAppender("TDDL_Nagios_Appender", "Nagios.log", "%m%n");
        Appender atomStatisticAppender = LoggerInit.buildDailyMaxRollingAppender("TDDL_Atom_Statistic_Appender", "tddl-atom-statistic.log", "%m", 6);
        Appender matrixStatisticAppender = LoggerInit.buildDailyMaxRollingAppender("TDDL_Matrix_Statistic_Appender", "tddl-matrix-statistic.log", "%m", 12);
        Appender connStatisticAppender = LoggerInit.buildDailyMaxRollingAppender("TDDL_Conn_Statistic_Appender", "tddl-conn-statistic.log", "%m", 6);
        Appender statisticAppender = LoggerInit.buildAppender("TDDL_Statistic_Appender", "tddl-statistic.log", "%m");
        Appender snapshotAppender = LoggerInit.buildAppender("TDDL_Snapshot_Appender", "tddl-snapshot.log", "%m");
        TDDL_LOG.setAdditivity(false);
        TDDL_LOG.removeAllAppenders();
        TDDL_LOG.addAppender(tddlAppender);
        TDDL_LOG.setLevel(Level.WARN);
        TDDL_MD5_TO_SQL_MAPPING.setAdditivity(false);
        TDDL_MD5_TO_SQL_MAPPING.removeAllAppenders();
        TDDL_MD5_TO_SQL_MAPPING.addAppender(md5sqlAppender);
        TDDL_MD5_TO_SQL_MAPPING.setLevel(Level.DEBUG);
        TDDL_Nagios_LOG.setAdditivity(false);
        TDDL_Nagios_LOG.removeAllAppenders();
        TDDL_Nagios_LOG.addAppender(nagiosAppender);
        TDDL_Nagios_LOG.setLevel(Level.INFO);
        TDDL_Atom_Statistic_LOG.setAdditivity(false);
        TDDL_Atom_Statistic_LOG.removeAllAppenders();
        TDDL_Atom_Statistic_LOG.addAppender(atomStatisticAppender);
        TDDL_Atom_Statistic_LOG.setLevel(Level.INFO);
        TDDL_Matrix_Statistic_LOG.setAdditivity(false);
        TDDL_Matrix_Statistic_LOG.removeAllAppenders();
        TDDL_Matrix_Statistic_LOG.addAppender(matrixStatisticAppender);
        TDDL_Matrix_Statistic_LOG.setLevel(Level.INFO);
        TDDL_Conn_Statistic_LOG.setAdditivity(false);
        TDDL_Conn_Statistic_LOG.removeAllAppenders();
        TDDL_Conn_Statistic_LOG.addAppender(connStatisticAppender);
        TDDL_Conn_Statistic_LOG.setLevel(Level.INFO);
        TDDL_Statistic_LOG.setAdditivity(false);
        TDDL_Statistic_LOG.removeAllAppenders();
        TDDL_Statistic_LOG.addAppender(statisticAppender);
        TDDL_Statistic_LOG.setLevel(Level.INFO);
        TDDL_Snapshot_LOG.setAdditivity(false);
        TDDL_Snapshot_LOG.removeAllAppenders();
        TDDL_Snapshot_LOG.addAppender(snapshotAppender);
        TDDL_Snapshot_LOG.setLevel(Level.INFO);
    }

    public static void initTddlLogByFile() {
        if (initOK) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(LoggerInit.class.getClassLoader());
        DOMConfigurator.configure((URL)LoggerInit.class.getClassLoader().getResource("tddl-log4j.xml"));
        String logPath = LoggerInit.getLogPath();
        Enumeration e = Logger.getLogger((String)"only_for_get_all_appender").getAllAppenders();
        while (e.hasMoreElements()) {
            Appender appender = (Appender)e.nextElement();
            if (!FileAppender.class.isInstance(appender)) continue;
            FileAppender logFileAppender = (FileAppender)appender;
            File deleteFile = new File(logFileAppender.getFile());
            File logFile = new File(logPath, logFileAppender.getFile());
            logFileAppender.setFile(logFile.getAbsolutePath());
            logFileAppender.activateOptions();
            if (deleteFile.exists()) {
                deleteFile.delete();
            }
            logger.warn((Object)("\u6210\u529f\u6539\u53d8" + deleteFile.getName() + "\u7684\u8f93\u51fa\u8def\u5f84\u5230:" + logFile.getAbsolutePath()));
        }
        Thread.currentThread().setContextClassLoader(loader);
        initOK = true;
    }

    static {
        LoggerInit.initTddlLog();
    }
}

