/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantLock;

public class MD5Maker {
    private static MD5Maker md5Maker = new MD5Maker();
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static MessageDigest mHasher;
    private ReentrantLock opLock = new ReentrantLock();

    public MD5Maker() {
        try {
            mHasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("should not be here,cant find md5 instance?", e);
        }
    }

    public static MD5Maker getInstance() {
        return md5Maker;
    }

    public String bytes2string(byte[] bt) {
        int l = bt.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & bt[i]) >>> 4];
            out[j++] = digits[0xF & bt[i]];
        }
        return new String(out);
    }

    public byte[] getMD5bytes(String str) {
        this.opLock.lock();
        try {
            byte[] bt = mHasher.digest(str.getBytes("UTF-8"));
            if (null == bt || bt.length != 16) {
                throw new IllegalArgumentException("md5 need");
            }
            byte[] byArray = bt;
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported utf-8 encoding", e);
        }
        finally {
            this.opLock.unlock();
        }
    }

    public String getMD5(String str) {
        return this.bytes2string(this.getMD5bytes(str));
    }
}

