/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import com.alibaba.common.lang.StringUtil;
import com.taobao.monitor.MonitorLog;
import com.taobao.tddl.common.ConfigServerHelper;
import com.taobao.tddl.common.GlobalCache;
import com.taobao.tddl.common.LoggerInit;
import com.taobao.tddl.common.MD5Maker;
import com.taobao.tddl.common.PositiveAtomicCounter;
import com.taobao.tddl.common.StatMonitor;
import com.taobao.tddl.common.monitor.SnapshotValuesOutputCallBack;
import com.taobao.tddl.common.monitor.stat.AbstractStatLogWriter;
import com.taobao.tddl.common.monitor.stat.BufferedLogWriter;
import com.taobao.tddl.common.monitor.stat.Log4jLogWriter;
import com.taobao.tddl.common.monitor.stat.MinMaxAvgLogWriter;
import com.taobao.tddl.common.monitor.stat.SoftRefLogWriter;
import com.taobao.tddl.common.util.BoundedConcurrentHashMap;
import com.taobao.tddl.common.util.TStringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

public class Monitor {
    public static final String KEY1 = "TDDL";
    public static final String KEY2_SYNC = "Sync";
    public static final String KEY2_SYNC_CONTEXT_SQL = "SyncServerContextSql";
    public static final String KEY3_BatchUpdateSyncLog = "BatchUpdateSyncLog";
    public static final String KEY3_BatchDeleteSyncLog = "BatchDeleteSyncLog";
    public static final String KEY3_SyncLogFetched = "SyncLogFetched";
    public static final String KEY3_ReplicationTasksAccepted = "ReplicationTasksAccepted";
    public static final String KEY3_UpdateSlaveRow_dup_all = "UpdateSlaveRow_dup_all";
    public static final String KEY3_PARSE_SQL = "PARSE_SQL_SUCCESS";
    public static final String KEY3_TAIR_HIT_RATING = "TAIR_HIT_RATING";
    public static final String KEY3_GET_DB_AND_TABLES = "GET_DB_ANDTABLES_SUCCESS";
    public static final String KEY3_EXECUTE_A_SQL_SUCCESS = "EXECUTE_A_SQL_SUCCESS";
    public static final String KEY3_EXECUTE_A_SQL_SUCCESS_DBTAB = "EXECUTE_A_SQL_SUCCESS_DBTAB";
    public static final String KEY3_EXECUTE_A_SQL_TIMEOUT = "EXECUTE_A_SQL_TIMEOUT";
    public static final String KEY3_EXECUTE_A_SQL_TIMEOUT_DBTAB = "EXECUTE_A_SQL_TIMEOUT_DBTAB";
    public static final String KEY3_EXECUTE_A_SQL_EXCEPTION = "EXECUTE_A_SQL_WITH_EXCEPTION";
    public static final String KEY3_EXECUTE_A_SQL_EXCEPTION_DBTAB = "EXECUTE_A_SQL_WITH_EXCEPTION_DBTAB";
    public static final String KEY2_REPLICATION_SQL = "TDDL_REPLICATION_SQL|";
    public static final String KEY3_COPY_2_SLAVE_SUCCESS = "COPY_2_SLAVE_SUCCESS";
    public static final String KEY3_COPY_2_SLAVE_SUCCESS_TIME_CONSUMING_IN_THREADPOOL = "COPY_2_SLAVE_SUCCESS_TIME_CONSUMING_IN_THREADPOOL";
    public static final String KEY3_COPY_2_SLAVE_TIMEOUT = "COPY_2_SLAVE_TIMEOUT";
    public static final String KEY3_COPY_2_SLAVE_TIMEOUT_TIME_CONSUMING_IN_THREADPOOL = "COPY_2_SLAVE_TIMEOUT_TIME_CONSUMING_IN_THREADPOOL";
    public static final String KEY3_COPY_2_SLAVE_EXCEPTION = "COPY_2_SLAVE_EXCEPTION";
    public static final String KEY3_COPY_2_SLAVE_EXCEPTION_TIME_CONSUMING_IN_THREADPOOL = "COPY_2_SLAVE_EXCEPTION_TIME_CONSUMING_IN_THREADPOOL";
    public static final String KEY3_SYNC_VIA_CENTER_SUCCESS = "SYNC_VIA_CENTER_SUCCESS";
    public static final String KEY3_SYNC_VIA_CENTER_TIMEOUT = "SYNC_VIA_CENTER_TIMEOUT";
    public static final String KEY3_SYNC_VIA_CENTER_TIMEOUT_TIME_IN_QUEUE = "SYNC_VIA_CENTER_TIMEOUT_TIME_IN_QUEUE";
    public static final String KEY3_SYNC_VIA_CENTER_NO_RESPONSE = "SYNC_VIA_CENTER_NO_RESPONSE";
    public static final String KEY3_CONN_NUMBER = "CONN_NUM";
    public static final String KEY3_CONN_BLOCKING = "CONN_BLOCKING";
    private static final BufferedLogWriter bufferedStatLogWriter = new BufferedLogWriter(1024, 4096, new Log4jLogWriter(LoggerInit.TDDL_Statistic_LOG));
    private static final BufferedLogWriter atomBufferedStatLogWriter = new BufferedLogWriter(2048, 131072, new Log4jLogWriter(LoggerInit.TDDL_Atom_Statistic_LOG));
    private static final BufferedLogWriter matrixBufferedStatLogWriter = new BufferedLogWriter(2048, 131072, new Log4jLogWriter(LoggerInit.TDDL_Matrix_Statistic_LOG));
    private static final SoftRefLogWriter connRefStatLogWriter = new SoftRefLogWriter(false, new MinMaxAvgLogWriter(", ", LoggerInit.TDDL_Conn_Statistic_LOG));
    public static final String KEY3_WRITE_LOG_SUCCESS = "WRITE_LOG_SUCCESS";
    public static final String KEY3_WRITE_LOG_EXCEPTION = "WRITE_LOG_EXCEPTION";
    private static final Log logger = LogFactory.getLog(Monitor.class);
    private static final Logger log = LoggerInit.TDDL_MD5_TO_SQL_MAPPING;
    private static final BoundedConcurrentHashMap<String, String> sqlToMD5Map = new BoundedConcurrentHashMap();
    private static MD5Maker md5Maker = MD5Maker.getInstance();
    public static volatile String APPNAME = "TDDL";
    private static volatile RECORD_TYPE recordType = RECORD_TYPE.RECORD_SQL;
    private static volatile int left = 0;
    private static volatile int right = 0;
    private static volatile String[] excludsKeys = null;
    private static volatile String[] includeKeys = null;
    public static volatile Boolean isStatRealDbInWrapperDs = null;
    public static volatile boolean isStatAtomSql = true;
    public static volatile int sqlTimeout = 500;
    public static volatile int atomSamplingRate = 100;
    public static volatile int statChannelMask = 7;
    public static volatile int dumpInterval = -1;
    public static volatile int cacheSize = -1;
    private static final Set<GlobalConfigListener> globalConfigListeners;
    private static final ConfigServerHelper.DataListener tddlConfigListener;
    public static final StatMonitor statMonitor;
    private static final PositiveAtomicCounter pc;

    private static void init() {
        LoggerInit.initTddlLog();
        if (KEY1.equals(APPNAME)) {
            logger.warn((Object)"\u4e0d\u6307\u5b9aTDDL\u4ee5\u5916\u7684appName\u5219\u4e0d\u8ba2\u9605");
            return;
        }
        Object firstFetchedConfigs = ConfigServerHelper.subscribeTDDLConfig(APPNAME, tddlConfigListener);
        if (firstFetchedConfigs == null) {
            logger.warn((Object)"No tddlconfig received, use default");
        }
    }

    public static void addGlobalConfigListener(GlobalConfigListener listener) {
        globalConfigListeners.add(listener);
    }

    public static void removeGlobalConfigListener(GlobalConfigListener listener) {
        globalConfigListeners.remove(listener);
    }

    private static void addMonitor(String key1, String key2, String key3, long value1, long value2) {
        if (KEY3_WRITE_LOG_SUCCESS.equals(key3)) {
            statMonitor.addStat(key1, "", "INSERT_LOGDB_FAIL_RATE", 0L);
            statMonitor.addStat(key1, "", "INSERT_LOGDB_TIME_AVG", value1);
        } else if (KEY3_WRITE_LOG_EXCEPTION.equals(key3)) {
            statMonitor.addStat(key1, "", "INSERT_LOGDB_FAIL_RATE", 1L);
        } else if (KEY3_COPY_2_SLAVE_SUCCESS.equals(key3)) {
            statMonitor.addStat(key1, "", "REPLICATION_FAIL_RATE", 0L);
            statMonitor.addStat(key1, "", "REPLICATION_TIME_AVG", value1);
        } else if (KEY3_WRITE_LOG_EXCEPTION.equals(key3)) {
            statMonitor.addStat(key1, "", "REPLICATION_FAIL_RATE", 1L);
        }
    }

    public static String buildTableKey1(String virtualTableName) {
        if (virtualTableName != null) {
            return (String)GlobalCache.cache(virtualTableName);
        }
        return "null";
    }

    public static String buildExecuteSqlKey2(String sql) {
        if (sql == null) {
            return "null";
        }
        switch (recordType) {
            case RECORD_SQL: {
                String s = TStringUtil.fillTabWithSpace(sql);
                if (left > 0) {
                    s = StringUtil.left((String)s, (int)left);
                }
                if (right > 0) {
                    s = StringUtil.right((String)s, (int)right);
                }
                return (String)GlobalCache.cache(s);
            }
            case MD5: {
                String md5;
                String s1 = TStringUtil.fillTabWithSpace(sql);
                if (left > 0) {
                    s1 = StringUtil.left((String)s1, (int)left);
                }
                if (right > 0) {
                    s1 = StringUtil.right((String)s1, (int)right);
                }
                if ((md5 = sqlToMD5Map.get(s1 = (String)GlobalCache.cache(s1))) != null) {
                    return md5;
                }
                String sqlmd5 = md5Maker.getMD5(s1);
                StringBuilder sb = new StringBuilder();
                sb.append("[md5]").append(sqlmd5).append(" [sql]").append(s1);
                log.warn((Object)sb.toString());
                sqlmd5 = (String)GlobalCache.cache(sqlmd5);
                sqlToMD5Map.put(s1, sqlmd5);
                return sqlmd5;
            }
            case NONE: {
                return "";
            }
        }
        throw new IllegalArgumentException("\u4e0d\u7b26\u5408\u8981\u6c42\u7684\u8bb0\u5f55log\u7c7b\u578b! " + (Object)((Object)recordType));
    }

    public static String buildExecuteDBAndTableKey1(String realDSKey, String realTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY1).append("|").append(realDSKey).append("|").append(realTable);
        return (String)GlobalCache.cache(sb.toString());
    }

    public static String buildReplicationSqlKey2(String sql) {
        return Monitor.buildExecuteSqlKey2(sql);
    }

    public static void add(String key1, String key2, String key3, long value1, long value2) {
        if (Monitor.isExclude(key1, key2, key3)) {
            return;
        }
        if ((statChannelMask & 4) == 4) {
            MonitorLog.addStat((String)key1, (String)"", (String)key3, (long)value1, (long)value2);
        }
        if ((statChannelMask & 2) == 2) {
            bufferedStatLogWriter.stat(key2, key1, key3, value2, value1);
        }
        if ((statChannelMask & 1) == 1) {
            Monitor.addMonitor(key1, key2, key3, value1, value2);
        }
    }

    public static void atomSqlAdd(String key1, String key2, String key3, String key4, String key5, String key6, long value1, long value2) {
        atomBufferedStatLogWriter.write(new Object[]{key2, key1, key3}, new Object[]{key2, key1, key4, key5, key6, key3}, value2, value1);
    }

    public static void matrixSqlAdd(String key1, String key2, String key3, long value1, long value2) {
        matrixBufferedStatLogWriter.stat(key2, key1, key3, value2, value1);
    }

    public static AbstractStatLogWriter.LogCounter connStat(String obj1, String obj2, String obj3) {
        Object[] objs = new Object[]{obj1, obj2, obj3};
        return connRefStatLogWriter.getCounter(objs, objs);
    }

    public static boolean isSamplingRecord() {
        int ra = pc.incrementAndGet() % 100;
        return ra < atomSamplingRate;
    }

    private static boolean isExclude(String key1, String key2, String key3) {
        if (excludsKeys == null || excludsKeys.length == 0) {
            return false;
        }
        for (String exclude : excludsKeys) {
            if (key1.indexOf(exclude) == -1 && key2.indexOf(exclude) == -1 && key3.indexOf(exclude) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isInclude(String sql) {
        if (includeKeys != null && includeKeys.length != 0) {
            boolean discard = true;
            for (String whiteItem : includeKeys) {
                if (sql.indexOf(whiteItem) == -1) continue;
                discard = false;
                break;
            }
            if (discard) {
                return false;
            }
        }
        return true;
    }

    public static void setAppName(String appname) {
        if (appname != null) {
            APPNAME = appname;
            Monitor.init();
        }
    }

    public static synchronized void addSnapshotValuesCallbask(SnapshotValuesOutputCallBack callbackList) {
        statMonitor.addSnapshotValuesCallbask(callbackList);
    }

    public static synchronized void removeSnapshotValuesCallback(SnapshotValuesOutputCallBack callbackList) {
        statMonitor.removeSnapshotValuesCallback(callbackList);
    }

    static /* synthetic */ String[] access$402(String[] x0) {
        excludsKeys = x0;
        return x0;
    }

    static /* synthetic */ String[] access$502(String[] x0) {
        includeKeys = x0;
        return x0;
    }

    static {
        Monitor.init();
        globalConfigListeners = new HashSet<GlobalConfigListener>(0);
        tddlConfigListener = new ConfigServerHelper.AbstractDataListener(){

            @Override
            public void onDataReceive(Object data) {
                Properties p = ConfigServerHelper.parseProperties(data, "[tddlConfigListener]");
                if (p == null) {
                    logger.warn((Object)"Empty tddlconfig");
                    return;
                }
                try {
                    block16: for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String key = ((String)entry.getKey()).trim();
                        String value = ((String)entry.getValue()).trim();
                        switch (ConfigServerHelper.TDDLConfigKey.valueOf(key)) {
                            case statKeyRecordType: {
                                RECORD_TYPE old = recordType;
                                recordType = RECORD_TYPE.valueOf(value);
                                logger.warn((Object)("statKeyRecordType switch from [" + (Object)((Object)old) + "] to [" + (Object)((Object)recordType) + "]"));
                                continue block16;
                            }
                            case statKeyLeftCutLen: {
                                int old = left;
                                left = Integer.valueOf(value);
                                logger.warn((Object)("statKeyLeftCutLen switch from [" + old + "] to [" + left + "]"));
                                continue block16;
                            }
                            case statKeyRightCutLen: {
                                int old = right;
                                right = Integer.valueOf(value);
                                logger.warn((Object)("statKeyRightCutLen switch from [" + old + "] to [" + right + "]"));
                                continue block16;
                            }
                            case statKeyExcludes: {
                                Object[] old = excludsKeys;
                                Monitor.access$402(value.split(","));
                                logger.warn((Object)("statKeyExcludes switch from " + Arrays.toString(old) + " to [" + value + "]"));
                                continue block16;
                            }
                            case statKeyIncludes: {
                                Object[] old = includeKeys;
                                Monitor.access$502(value.split(","));
                                logger.warn((Object)("statKeyIncludes switch from " + Arrays.toString(old) + " to [" + value + "]"));
                                continue block16;
                            }
                            case StatRealDbInWrapperDs: {
                                boolean old = isStatRealDbInWrapperDs;
                                isStatRealDbInWrapperDs = Boolean.valueOf(value);
                                logger.warn((Object)("StatRealDbInWrapperDs switch from [" + old + "] to [" + value + "]"));
                                continue block16;
                            }
                            case StatChannelMask: {
                                int old = statChannelMask;
                                statChannelMask = Integer.valueOf(value);
                                logger.warn((Object)("statChannelMask switch from [" + old + "] to [" + value + "]"));
                                continue block16;
                            }
                            case statDumpInterval: {
                                int old = dumpInterval;
                                dumpInterval = Integer.valueOf(value);
                                statMonitor.setFlushInterval(dumpInterval);
                                bufferedStatLogWriter.setFlushInterval(dumpInterval);
                                logger.warn((Object)("statDumpInterval switch from [" + old + "] to [" + value + "]"));
                                continue block16;
                            }
                            case statCacheSize: {
                                int old = cacheSize;
                                cacheSize = Integer.valueOf(value);
                                statMonitor.setMaxKeySize(cacheSize);
                                bufferedStatLogWriter.setMaxKeySize(cacheSize);
                                logger.warn((Object)("statCacheSize switch from [" + old + "] to [" + value + "]"));
                                continue block16;
                            }
                            case statAtomSql: {
                                boolean old = isStatAtomSql;
                                isStatAtomSql = Boolean.parseBoolean(value);
                                logger.warn((Object)("isStatAtomSql switch from [" + old + "] to [" + value + "]"));
                                continue block16;
                            }
                            case sqlExecTimeOutMilli: {
                                int old = sqlTimeout;
                                sqlTimeout = Integer.valueOf(value);
                                logger.warn((Object)("sqlTimeout switch from [" + old + "] to [" + value + "]"));
                                continue block16;
                            }
                            case atomSqlSamplingRate: {
                                int old = atomSamplingRate;
                                if (old > 0) {
                                    int rate = 0;
                                    rate = Integer.valueOf(value) % 100 == 0 ? 100 : Integer.valueOf(value) % 100;
                                    atomSamplingRate = rate;
                                    logger.warn((Object)("atomSqlSamplingRate switch from [" + old + "] to [" + atomSamplingRate + "]"));
                                    break;
                                }
                                logger.warn((Object)("atomSqlSamplingRate will not change,because the value got is nagetive!old value is:" + old));
                            }
                        }
                        logger.warn((Object)("Not cared TDDLConfigKey:" + key));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"[tddlConfigListener.onDataReceive]", (Throwable)e);
                }
                for (GlobalConfigListener listener : globalConfigListeners) {
                    listener.onConfigReceive(p);
                }
            }
        };
        statMonitor = StatMonitor.getInstance();
        pc = new PositiveAtomicCounter();
    }

    public static interface GlobalConfigListener {
        public void onConfigReceive(Properties var1);
    }

    public static enum RECORD_TYPE {
        RECORD_SQL,
        MD5,
        NONE;

    }
}

