/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.common.LoggerInit;
import com.taobao.tddl.common.StatMonitorMBean;
import com.taobao.tddl.common.monitor.SnapshotValuesOutputCallBack;
import com.taobao.tddl.common.monitor.stat.AbstractStatLogWriter;
import com.taobao.tddl.common.monitor.stat.BufferedLogWriter;
import com.taobao.tddl.common.monitor.stat.Log4jLogWriter;
import com.taobao.tddl.common.monitor.stat.NagiosLogWriter;
import com.taobao.tddl.common.monitor.stat.StatLogWriter;
import com.taobao.tddl.common.util.NagiosUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatMonitor
extends BufferedLogWriter
implements StatMonitorMBean {
    private static final Log logger = LogFactory.getLog(StatMonitor.class);
    private static final StatMonitor instance = new StatMonitor();
    private volatile ConcurrentHashMap<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> lastStatMap;
    private volatile long lastResetTime = System.currentTimeMillis();
    private volatile long duration = 0L;
    private List<SnapshotValuesOutputCallBack> snapshotValueCallBack = new LinkedList<SnapshotValuesOutputCallBack>();
    private final StatLogWriter Nagios_Log_Writer = new StatLogWriter(){

        @Override
        public void write(Object[] keys, Object[] fields, long ... values) {
            if (values.length < 2) {
                throw new IllegalArgumentException("At least given 2 values");
            }
            fields = Arrays.copyOf(fields == null ? keys : fields, 3);
            long count = values[0];
            long value = values[1];
            String averageValueStr = "invalid";
            if (count != 0L) {
                double averageValue = (double)value / (double)count;
                averageValueStr = String.valueOf(averageValue);
            }
            NagiosUtils.addNagiosLog(StringUtil.join((Object[])fields, (String)"|"), count + "|" + value + "|" + averageValueStr);
        }
    };
    private final StatLogWriter TDDL_Log_Writer = new Log4jLogWriter(LoggerInit.TDDL_Snapshot_LOG){

        @Override
        protected StringBuffer format(StringBuffer buf, Object[] fields, Date time, long ... values) {
            for (long value : values) {
                buf.append(value).append(this.fieldSeperator);
            }
            for (Object field : fields) {
                buf.append(field).append(this.fieldSeperator);
            }
            return buf.append(df.format(time)).append(this.lineSeperator);
        }
    };

    private StatMonitor() {
        super(300, 1000, 4000, new NagiosLogWriter());
        this.lastStatMap = this.map;
    }

    public static StatMonitor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStat() {
        if (!this.flushing && this.flushLock.tryLock()) {
            try {
                this.lastStatMap = this.map;
                this.map = new ConcurrentHashMap(this.maxKeySize, 0.75f, 32);
                this.duration = System.currentTimeMillis() - this.lastResetTime;
                this.lastResetTime = System.currentTimeMillis();
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    @Override
    protected void insureMaxSize() {
    }

    @Override
    protected void flushAll() {
        try {
            this.lastStatMap = this.map;
            this.duration = System.currentTimeMillis() - this.lastResetTime;
            this.lastResetTime = System.currentTimeMillis();
            super.flushAll();
            this.writeCallBackLog();
        }
        catch (Throwable e) {
            logger.warn((Object)"flushAll", e);
        }
    }

    @Override
    protected void flushLRU() {
    }

    @Override
    public String getStatResult(String key1, String key2, String key3) {
        long duration;
        AbstractStatLogWriter.LogKey logKey = new AbstractStatLogWriter.LogKey(new Object[]{key1, key2, key3});
        AbstractStatLogWriter.LogCounter counter = this.lastStatMap.get(logKey);
        if (counter == null) {
            logger.warn((Object)("getLastStatResult(" + key1 + ", " + key2 + ", " + key3 + ") Invalid"));
            return null;
        }
        long count = counter.getCount();
        long values = counter.getValue();
        String averageValueStr = "invalid";
        String averageCountStr = "invalid";
        if (count != 0L) {
            double averageValue = (double)values / (double)count;
            averageValueStr = String.valueOf(averageValue);
        }
        if ((duration = this.duration) == 0L) {
            duration = System.currentTimeMillis() - this.lastResetTime;
        }
        if (duration != 0L) {
            double averageCount = (double)(count * 1000L) / (double)duration;
            averageCountStr = String.valueOf(averageCount);
        }
        return "count: " + count + ", value: " + values + ", average: " + averageValueStr + ", Count/Duration: " + averageCountStr;
    }

    @Override
    public long getDuration() {
        return this.duration != 0L ? this.duration : System.currentTimeMillis() - this.lastResetTime;
    }

    @Override
    public long getStatDuration() {
        return this.lastResetTime;
    }

    public final boolean addStat(String keyOne, String keyTwo, String keyThree) {
        return this.realTimeStat(keyOne, keyTwo, keyThree, 0L);
    }

    public final boolean addStat(String keyOne, String keyTwo, String keyThree, long value) {
        return this.realTimeStat(keyOne, keyTwo, keyThree, value);
    }

    private final boolean realTimeStat(String key1, String key2, String key3, long value) {
        AbstractStatLogWriter.LogKey logKey = new AbstractStatLogWriter.LogKey(new Object[]{key1, key2, key3});
        if (!this.map.containsKey(logKey) && this.map.size() >= this.maxKeySize) {
            return false;
        }
        long[] values = new long[]{1L, value};
        this.write(logKey.getKeys(), values);
        return true;
    }

    public synchronized void addSnapshotValuesCallbask(SnapshotValuesOutputCallBack callbackList) {
        if (this.snapshotValueCallBack.contains(callbackList)) {
            return;
        }
        this.snapshotValueCallBack.add(callbackList);
    }

    public synchronized void removeSnapshotValuesCallback(SnapshotValuesOutputCallBack callbackList) {
        this.snapshotValueCallBack.remove(callbackList);
    }

    private final void writeCallBackLog() {
        for (SnapshotValuesOutputCallBack callBack : this.snapshotValueCallBack) {
            try {
                callBack.snapshotValues(this.TDDL_Log_Writer);
            }
            catch (Throwable e) {
                logger.warn((Object)"callBack", e);
            }
        }
    }
}

