/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common;

import com.taobao.tddl.common.RuntimeConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeightRandom {
    private static final Log logger = LogFactory.getLog(WeightRandom.class);
    public static final int DEFAULT_WEIGHT_NEW_ADD = 0;
    public static final int DEFAULT_WEIGHT_INIT = 10;
    private Map<String, Integer> cachedWeightConfig;
    private final RuntimeConfigHolder<Weight> weightHolder = new RuntimeConfigHolder();
    private final Random random = new Random();

    public WeightRandom(Map<String, Integer> weightConfigs) {
        this.init(weightConfigs);
    }

    public WeightRandom(String[] keys) {
        HashMap<String, Integer> weightConfigs = new HashMap<String, Integer>(keys.length);
        for (String key : keys) {
            weightConfigs.put(key, 10);
        }
        this.init(weightConfigs);
    }

    private void init(Map<String, Integer> weightConfig) {
        this.cachedWeightConfig = weightConfig;
        String[] weightKeys = weightConfig.keySet().toArray(new String[0]);
        int[] weights = new int[weightConfig.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = weightConfig.get(weightKeys[i]);
        }
        int[] weightAreaEnds = WeightRandom.genAreaEnds(weights);
        this.weightHolder.set(new Weight(weights, weightKeys, weightAreaEnds));
    }

    public void setWeightConfig(Map<String, Integer> weightConfig) {
        this.init(weightConfig);
    }

    public Map<String, Integer> getWeightConfig() {
        return this.cachedWeightConfig;
    }

    private String select(int[] areaEnds, String[] keys) {
        int sum = areaEnds[areaEnds.length - 1];
        if (sum == 0) {
            logger.error((Object)("areaEnds: " + Arrays.toString(areaEnds)));
            return null;
        }
        int rand = this.random.nextInt(sum);
        for (int i = 0; i < areaEnds.length; ++i) {
            if (rand >= areaEnds[i]) continue;
            return keys[i];
        }
        return null;
    }

    public String select(List<String> excludeKeys) {
        Weight w = this.weightHolder.get();
        if (excludeKeys == null || excludeKeys.isEmpty()) {
            return this.select(w.weightAreaEnds, w.weightKeys);
        }
        int[] tempWeights = (int[])w.weightValues.clone();
        for (int k = 0; k < w.weightKeys.length; ++k) {
            if (!excludeKeys.contains(w.weightKeys[k])) continue;
            tempWeights[k] = 0;
        }
        int[] tempAreaEnd = WeightRandom.genAreaEnds(tempWeights);
        return this.select(tempAreaEnd, w.weightKeys);
    }

    public <T extends Throwable> List<T> retry(int times, Tryer<T> tryer) {
        ArrayList<T> exceptions = new ArrayList<T>(0);
        ArrayList<String> excludeKeys = new ArrayList<String>(0);
        for (int i = 0; i < times; ++i) {
            String name = this.select(excludeKeys);
            T e = tryer.tryOne(name);
            if (e == null) {
                return null;
            }
            exceptions.add(e);
            excludeKeys.add(name);
        }
        return exceptions;
    }

    public <T extends Throwable> List<T> retry(Tryer<T> tryer) {
        return this.retry(3, tryer);
    }

    private static int[] genAreaEnds(int[] weights) {
        if (weights == null) {
            return null;
        }
        int[] areaEnds = new int[weights.length];
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            areaEnds[i] = sum += weights[i];
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generate " + Arrays.toString(areaEnds) + " from " + Arrays.toString(weights)));
        }
        if (sum == 0) {
            logger.warn((Object)("generate " + Arrays.toString(areaEnds) + " from " + Arrays.toString(weights)));
        }
        return areaEnds;
    }

    public static interface Tryer<T extends Throwable> {
        public T tryOne(String var1);
    }

    private static class Weight {
        public final String[] weightKeys;
        public final int[] weightValues;
        public final int[] weightAreaEnds;

        public Weight(int[] weights, String[] weightKeys, int[] weightAreaEnds) {
            this.weightKeys = weightKeys;
            this.weightValues = weights;
            this.weightAreaEnds = weightAreaEnds;
        }
    }
}

