/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.config.diamond;

import com.taobao.diamond.manager.DiamondManager;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.diamond.manager.impl.DefaultDiamondManager;
import com.taobao.tddl.common.config.ConfigDataHandler;
import com.taobao.tddl.common.config.ConfigDataListener;
import com.taobao.tddl.common.config.diamond.DiamondConfig;
import com.taobao.tddl.common.util.TDDLMBeanServer;
import com.taobao.tddl.common.util.mbean.TDDLMBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiamondConfigDataHandler
implements ConfigDataHandler {
    private static final Log logger = LogFactory.getLog(DiamondConfigDataHandler.class);
    private DiamondManager diamondManager;
    private String dataId;
    private String mbeanId;
    private TDDLMBean mbean;

    @Override
    public void init(final String dataId, final List<ConfigDataListener> configDataListenerList, final Map<String, Object> config) {
        this.mbean = new TDDLMBean("Diamond Config Info " + System.currentTimeMillis());
        this.mbeanId = dataId + System.currentTimeMillis();
        DiamondConfig.handleConfig(config);
        DefaultDiamondManager.Builder builder = new DefaultDiamondManager.Builder(dataId, new ManagerListener(){

            public void receiveConfigInfo(String data) {
                if (configDataListenerList != null) {
                    for (ConfigDataListener configDataListener : configDataListenerList) {
                        configDataListener.onDataRecieved(dataId, data);
                    }
                    if (data != null) {
                        DiamondConfigDataHandler.this.mbean.setAttribute(dataId, data);
                    } else {
                        DiamondConfigDataHandler.this.mbean.setAttribute(dataId, "");
                    }
                }
            }

            public Executor getExecutor() {
                return (Executor)config.get("executor");
            }
        });
        String group = (String)config.get("group");
        if (null != group) {
            builder.setGroup(group);
        }
        this.diamondManager = builder.build();
        this.dataId = dataId;
        TDDLMBeanServer.registerMBeanWithId(this.mbean, this.mbeanId);
    }

    @Override
    public String getData(long timeout, String strategy) {
        String data = null;
        if (strategy != null && strategy.equals("firstCache")) {
            data = this.diamondManager.getAvailableConfigureInfomation(timeout);
        } else if (strategy != null && strategy.equals("firstServer")) {
            data = this.diamondManager.getConfigureInfomation(timeout);
        }
        if (data != null) {
            this.mbean.setAttribute(this.dataId, data);
        } else {
            this.mbean.setAttribute(this.dataId, "");
        }
        return data;
    }

    @Override
    public void addListener(final ConfigDataListener configDataListener, final Executor executor) {
        if (configDataListener != null) {
            this.diamondManager.setManagerListener(new ManagerListener(){

                public void receiveConfigInfo(String data) {
                    configDataListener.onDataRecieved(DiamondConfigDataHandler.this.dataId, data);
                    if (data != null) {
                        DiamondConfigDataHandler.this.mbean.setAttribute(DiamondConfigDataHandler.this.dataId, data);
                    } else {
                        DiamondConfigDataHandler.this.mbean.setAttribute(DiamondConfigDataHandler.this.dataId, "");
                    }
                }

                public Executor getExecutor() {
                    return executor;
                }
            });
        }
    }

    @Override
    public void addListeners(final List<ConfigDataListener> configDataListenerList, final Executor executor) {
        if (configDataListenerList != null) {
            this.diamondManager.setManagerListener(new ManagerListener(){

                public void receiveConfigInfo(String data) {
                    for (ConfigDataListener configDataListener : configDataListenerList) {
                        try {
                            configDataListener.onDataRecieved(DiamondConfigDataHandler.this.dataId, data);
                        }
                        catch (Exception e) {
                            logger.error((Object)"one of listener failed", (Throwable)e);
                        }
                    }
                    if (data != null) {
                        DiamondConfigDataHandler.this.mbean.setAttribute(DiamondConfigDataHandler.this.dataId, data);
                    } else {
                        DiamondConfigDataHandler.this.mbean.setAttribute(DiamondConfigDataHandler.this.dataId, "");
                    }
                }

                public Executor getExecutor() {
                    return executor;
                }
            });
        }
    }

    @Override
    public void closeUnderManager() {
        this.diamondManager.close();
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }
}

