/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.config.impl;

import com.taobao.tddl.common.config.ConfigDataHandler;
import com.taobao.tddl.common.config.ConfigDataHandlerFactory;
import com.taobao.tddl.common.config.ConfigDataListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfigDataHandlerFactory
implements ConfigDataHandlerFactory {
    private static final Log log = LogFactory.getLog(DefaultConfigDataHandlerFactory.class);
    private static final String HANDLER_CLASS = "config.handler.constructor.name";
    private static final String DEFAULT_HANDLER_CLASS = "com.taobao.tddl.common.config.diamond.DiamondConfigDataHandler";
    private static String propertyFile = "remote-config.properties";
    private static String handlerClassName;
    private static Class handlerClassObj;
    private static Constructor handlerConstructor;
    private static Properties prop;
    private static boolean useTCCL;

    private static void findSpecifiedConfigHandlerClass() {
        InputStream resource;
        ClassLoader currentCL = DefaultConfigDataHandlerFactory.getBaseClassLoader();
        while (true) {
            if (currentCL == null) {
                resource = ClassLoader.getSystemResourceAsStream(propertyFile);
                break;
            }
            resource = currentCL.getResourceAsStream(propertyFile);
            if (null != resource) break;
            currentCL = currentCL.getParent();
        }
        if (null != resource) {
            prop = new Properties();
            try {
                prop.load(resource);
                handlerClassName = prop.getProperty(HANDLER_CLASS);
                if (null == handlerClassName || "".equals(handlerClassName)) {
                    handlerClassName = DEFAULT_HANDLER_CLASS;
                }
            }
            catch (IOException e) {
                log.error((Object)("properties can not load " + propertyFile));
            }
        } else {
            handlerClassName = DEFAULT_HANDLER_CLASS;
        }
    }

    private static void createConstuctFromClassName() {
        ClassLoader currentCL = DefaultConfigDataHandlerFactory.getBaseClassLoader();
        handlerClassObj = DefaultConfigDataHandlerFactory.loadClass(handlerClassName, currentCL);
        if (null == handlerClassObj) {
            throw new IllegalArgumentException("can not get handler class:" + handlerClassName);
        }
        try {
            handlerConstructor = handlerClassObj.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private static Class loadClass(String className, ClassLoader currentCL) {
        log.info((Object)("Trying to load '" + className));
        try {
            Class<?> clazz = currentCL.loadClass(handlerClassName);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"can not load the class ");
        }
        return null;
    }

    private static ClassLoader getBaseClassLoader() {
        ClassLoader thisClassLoader = DefaultConfigDataHandlerFactory.class.getClassLoader();
        if (!useTCCL) {
            return thisClassLoader;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader baseClassLoader = DefaultConfigDataHandlerFactory.getLowestClassLoader(contextClassLoader, thisClassLoader);
        return baseClassLoader;
    }

    private static ClassLoader getLowestClassLoader(ClassLoader c1, ClassLoader c2) {
        ClassLoader current;
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        for (current = c1; current != null; current = current.getParent()) {
            if (current != c2) continue;
            return c1;
        }
        for (current = c2; current != null; current = current.getParent()) {
            if (current != c1) continue;
            return c2;
        }
        return null;
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    @Override
    public ConfigDataHandler getConfigDataHandler(String dataId) {
        return this.getConfigDataHandler(dataId, null);
    }

    @Override
    public ConfigDataHandler getConfigDataHandler(String dataId, ConfigDataListener configDataListener) {
        return this.getConfigDataHandlerC(dataId, configDataListener, new HashMap<String, String>());
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerWithListenerList(String dataId, List<ConfigDataListener> configDataListenerList) {
        return this.getConfigDataHandlerWithListenerListC(dataId, configDataListenerList, new HashMap<String, String>());
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerC(String dataId, ConfigDataListener configDataListener, Map<String, String> config) {
        return this.getConfigDataHandlerCE(dataId, configDataListener, null, config);
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerWithListenerListC(String dataId, List<ConfigDataListener> configDataListenerList, Map<String, String> config) {
        return this.getConfigDataHandlerWithListenerListCE(dataId, configDataListenerList, null, config);
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerE(String dataId, ConfigDataListener configDataListener, Executor executor) {
        return this.getConfigDataHandlerCE(dataId, configDataListener, executor, new HashMap<String, String>());
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerWithListenerListE(String dataId, List<ConfigDataListener> configDataListenerList, Executor executor) {
        return this.getConfigDataHandlerWithListenerListCE(dataId, configDataListenerList, executor, new HashMap<String, String>());
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerCE(String dataId, ConfigDataListener configDataListener, Executor executor, Map<String, String> config) {
        ArrayList<ConfigDataListener> configDataListenerList = new ArrayList<ConfigDataListener>();
        configDataListenerList.add(configDataListener);
        return this.getConfigDataHandlerWithListenerListCE(dataId, configDataListenerList, executor, config);
    }

    @Override
    public ConfigDataHandler getConfigDataHandlerWithListenerListCE(String dataId, List<ConfigDataListener> configDataListenerList, Executor executor, Map<String, String> config) {
        try {
            ConfigDataHandler instance = (ConfigDataHandler)handlerConstructor.newInstance(new Object[0]);
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            if (config != null) {
                configMap.putAll(config);
            }
            if (prop != null) {
                configMap.putAll(prop);
            }
            instance.init(dataId, configDataListenerList, configMap);
            return instance;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"illegal arguments!", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"handler init error!", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"securty limit,handler can not be init!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"constructor invode error!", (Throwable)e);
        }
        return null;
    }

    static {
        DefaultConfigDataHandlerFactory.findSpecifiedConfigHandlerClass();
        DefaultConfigDataHandlerFactory.createConstuctFromClassName();
        useTCCL = true;
    }
}

